/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BloodBottleItem
extends VampirismItem
implements IFactionExclusiveItem {
    public static final int AMOUNT = 9;
    private static final String name = "blood_bottle";
    private static final int MULTIPLIER = 100;
    private static final int capacity = 900;

    public static ItemStack getStackWithDamage(int damage) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.blood_bottle);
        stack.m_41721_(damage);
        return stack;
    }

    public BloodBottleItem() {
        super(name, new Item.Properties().m_41499_(9).m_41491_(VampirismMod.creativeTab).setNoRepair());
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        BlockEntity t = world.m_7702_(pos);
        return t != null && t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).isPresent();
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> list) {
        super.m_6787_(group, list);
        if (this.m_41389_(group)) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.blood_bottle);
            stack.m_41721_(9);
            list.add((Object)stack);
        }
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@Nonnull ItemStack stack) {
        return VReference.VAMPIRE_FACTION;
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level worldIn, @Nonnull LivingEntity entityLiving) {
        if (entityLiving instanceof IVampire) {
            int blood = BloodHelper.getBlood(stack);
            int drink = Math.min(blood, 100);
            ItemStack[] result = new ItemStack[1];
            int amt = BloodHelper.drain(stack, drink, IFluidHandler.FluidAction.EXECUTE, true, containerStack -> {
                result[0] = containerStack;
            });
            ((IVampire)entityLiving).drinkBlood(amt / 100, 0.0f, false);
            return result[0];
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).map(IFluidHandlerItem::getContainer).orElseGet(() -> super.m_5922_(stack, worldIn, entityLiving));
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 15;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new BloodBottleFluidHandler(stack, 900);
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof IVampire) {
            return;
        }
        if (!(player instanceof Player) || !player.m_6084_()) {
            player.m_21253_();
            return;
        }
        int blood = BloodHelper.getBlood(stack);
        VampirePlayer vampire = VampirePlayer.getOpt((Player)player).resolve().orElse(null);
        if (vampire == null || vampire.getLevel() == 0 || blood == 0 || !vampire.getBloodStats().needsBlood()) {
            player.m_21253_();
            return;
        }
        if (blood > 0 && count == 1) {
            InteractionHand activeHand = player.m_7655_();
            int drink = Math.min(blood, 300);
            if (BloodHelper.drain(stack, drink, IFluidHandler.FluidAction.EXECUTE, true, containerStack -> player.m_21008_(activeHand, containerStack)) > 0) {
                vampire.drinkBlood(Math.round((float)drink / 100.0f), 0.3f, false);
            }
            if ((blood = BloodHelper.getBlood(stack)) > 0) {
                player.m_6672_(player.m_7655_());
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return VampirePlayer.getOpt(playerIn).map(vampire -> {
            if (vampire.getLevel() == 0) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            if (vampire.getBloodStats().needsBlood() && stack.m_41613_() == 1) {
                playerIn.m_6672_(handIn);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }).orElse(new InteractionResultHolder(InteractionResult.PASS, (Object)stack));
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return false;
    }
}

