/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BloodBottleFluidHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    public static final int MULTIPLIER = 100;
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    private final int capacity;
    @Nonnull
    protected ItemStack container;

    public static int getAdjustedAmount(int amt) {
        return amt - amt % 100;
    }

    public BloodBottleFluidHandler(@Nonnull ItemStack container, int capacity) {
        this.container = container;
        this.capacity = capacity;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || resource == null || resource.getAmount() <= 0 || !ModFluids.blood.equals(resource.getFluid())) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int currentAmt = this.getBlood(this.container);
        if (currentAmt == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack(ModFluids.blood, Math.min(currentAmt, BloodBottleFluidHandler.getAdjustedAmount(maxDrain)));
        if (action.execute()) {
            this.setBlood(this.container, currentAmt - stack.getAmount());
            if (this.getBlood(this.container) == 0 && ((Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get()).booleanValue()) {
                this.container = new ItemStack((ItemLike)Items.f_42590_);
            }
        }
        return stack;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null) {
            return 0;
        }
        if (!resource.getFluid().equals(ModFluids.blood)) {
            return 0;
        }
        if (action.simulate()) {
            return Math.min(this.capacity - this.getBlood(this.container), BloodBottleFluidHandler.getAdjustedAmount(resource.getAmount()));
        }
        int itemamt = this.getBlood(this.container);
        int toFill = Math.min(this.capacity - itemamt, BloodBottleFluidHandler.getAdjustedAmount(resource.getAmount()));
        this.setBlood(this.container, itemamt + toFill);
        return toFill;
    }

    public int getBlood(ItemStack stack) {
        return stack.m_41720_() == ModItems.blood_bottle ? stack.m_41773_() * 100 : 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return new FluidStack(ModFluids.blood, this.getBlood(this.container));
    }

    public int getTankCapacity(int tank) {
        return 900;
    }

    public int getTanks() {
        return 1;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return ModFluids.blood.m_6212_(stack.getFluid());
    }

    public void setBlood(ItemStack stack, int amt) {
        stack.m_41721_(amt / 100);
    }
}

