/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.recipes;

import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import de.teamlapen.vampirism.api.items.IExtendedBrewingRecipeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import org.apache.commons.lang3.tuple.Triple;

public class ExtendedBrewingRecipeRegistry
implements IExtendedBrewingRecipeRegistry {
    private final List<ExtendedPotionMix> conversionMixes = new ArrayList<ExtendedPotionMix>();

    @Override
    public void addMix(ExtendedPotionMix potionMix) {
        this.conversionMixes.add(potionMix);
    }

    @Override
    public void addMix(ExtendedPotionMix[] mixPredicate) {
        this.conversionMixes.addAll(Arrays.asList(mixPredicate));
    }

    @Override
    public boolean brewPotions(NonNullList<ItemStack> inputs, ItemStack ingredient, ItemStack extraIngredient, IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities, int[] inputIndexes, boolean onlyExtended) {
        boolean brewed = false;
        int useMain = 0;
        int useExtra = 0;
        for (int i : inputIndexes) {
            Optional<Triple<ItemStack, Integer, Integer>> output = this.getOutput((ItemStack)inputs.get(i), ingredient, extraIngredient, capabilities, onlyExtended);
            if (!output.isPresent()) continue;
            Triple<ItemStack, Integer, Integer> triple = output.get();
            inputs.set(i, (Object)((ItemStack)triple.getLeft()));
            useMain = Math.max(useMain, (Integer)triple.getMiddle());
            useExtra = Math.max(useExtra, (Integer)triple.getRight());
            brewed = true;
        }
        ingredient.m_41774_(useMain);
        extraIngredient.m_41774_(useExtra);
        return brewed;
    }

    @Override
    public boolean canBrew(NonNullList<ItemStack> inputs, ItemStack ingredient, ItemStack extraIngredient, IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities, int[] inputIndexes) {
        if (ingredient.m_41619_()) {
            return false;
        }
        for (int i : inputIndexes) {
            if (!this.hasOutput((ItemStack)inputs.get(i), ingredient, extraIngredient, capabilities)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<Triple<ItemStack, Integer, Integer>> getOutput(ItemStack bottle, ItemStack ingredient, ItemStack extraIngredient, IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities, boolean onlyExtended) {
        if (bottle.m_41619_() || bottle.m_41613_() != 1) {
            return Optional.empty();
        }
        if (ingredient.m_41619_()) {
            return Optional.empty();
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)bottle);
        if (bottle.m_41720_() instanceof ThrowablePotionItem && potion.m_43488_().stream().anyMatch(a -> a.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL)) {
            return Optional.empty();
        }
        Item item = bottle.m_41720_();
        ArrayList<ExtendedPotionMix> possibleResults = new ArrayList<ExtendedPotionMix>();
        for (ExtendedPotionMix mix : this.conversionMixes) {
            if (mix.input.get() != potion || !mix.reagent1.filter(i -> i.test(ingredient)).isPresent() || ingredient.m_41613_() < mix.reagent1Count || mix.reagent2Count > 0 && (!mix.reagent2.filter(i -> i.test(extraIngredient)).isPresent() || extraIngredient.m_41613_() < mix.reagent2Count) || !mix.canBrew(capabilities)) continue;
            possibleResults.add(mix);
        }
        if (!possibleResults.isEmpty()) {
            possibleResults.sort((mix1, mix2) -> mix1.efficient ? (mix2.efficient ? 0 : -1) : (mix2.efficient ? 1 : 0));
            ExtendedPotionMix mix = (ExtendedPotionMix)possibleResults.get(0);
            return Optional.of(Triple.of((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)((Potion)mix.output.get())), (Object)mix.reagent1Count, (Object)mix.reagent2Count));
        }
        ItemStack output = BrewingRecipeRegistry.getOutput((ItemStack)bottle, (ItemStack)ingredient);
        return output.m_41619_() ? Optional.empty() : Optional.of(Triple.of((Object)output, (Object)1, (Object)0));
    }

    @Override
    public List<ExtendedPotionMix> getPotionMixes() {
        return Collections.unmodifiableList(this.conversionMixes);
    }

    @Override
    public boolean hasOutput(ItemStack input, ItemStack ingredient, ItemStack extraIngredient, IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities capabilities) {
        return this.getOutput(input, ingredient, extraIngredient, capabilities, false).isPresent();
    }

    @Override
    public boolean isValidExtraIngredient(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (ExtendedPotionMix mix : this.conversionMixes) {
            if (!mix.reagent2.filter(i -> i.test(stack)).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidIngredient(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (ExtendedPotionMix mix : this.conversionMixes) {
            if (!mix.reagent1.filter(i -> i.test(stack)).isPresent()) continue;
            return true;
        }
        return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
    }

    @Override
    public boolean isValidInput(ItemStack stack) {
        if (stack.m_41613_() != 1) {
            return false;
        }
        Item item = stack.m_41720_();
        return item == Items.f_42589_ || item == Items.f_42736_ || item == Items.f_42739_ || item == Items.f_42590_ || BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
    }
}

