/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.network.SelectMinionTaskPacket;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.IContainerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinionContainer
extends InventoryContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MinionEntity<?> minionEntity;
    @Nonnull
    private final IMinionTask<?, ?>[] availableTasks;
    @Nullable
    private final IMinionTask<?, ?> previousTask;
    private final boolean previousTaskLocked;
    private final int extraSlots;
    @Nullable
    private IMinionTask<?, ?> taskToActivate;
    private boolean taskLocked;

    @Nullable
    public static MinionContainer create(int id, Inventory playerInventory, MinionEntity<?> minionEntity) {
        Optional<IMinionInventory> minionInv = minionEntity.getInventory();
        return minionInv.map(inv -> new MinionContainer(id, playerInventory, minionEntity, (Container)inv, inv.getAvailableSize(), MinionContainer.createSelectors(minionEntity, inv.getAvailableSize()))).orElse(null);
    }

    private static InventoryContainer.SelectorInfo[] createSelectors(MinionEntity<?> minionEntity, int extraSlots) {
        InventoryContainer.SelectorInfo[] slots = new InventoryContainer.SelectorInfo[6 + extraSlots];
        slots[0] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.MAINHAND).and(stack -> stack.canEquip(EquipmentSlot.MAINHAND, (Entity)minionEntity)), 7, 60, false, 1, null);
        slots[1] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.OFFHAND).and(stack -> stack.canEquip(EquipmentSlot.OFFHAND, (Entity)minionEntity) || stack.m_41780_() == UseAnim.DRINK || stack.m_41780_() == UseAnim.EAT), 7, 78, false, 5, null);
        slots[2] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.FEET).and(stack -> stack.canEquip(EquipmentSlot.FEET, (Entity)minionEntity)), 81, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39696_));
        slots[3] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.LEGS).and(stack -> stack.canEquip(EquipmentSlot.LEGS, (Entity)minionEntity)), 63, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39695_));
        slots[4] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.CHEST).and(stack -> stack.canEquip(EquipmentSlot.CHEST, (Entity)minionEntity)), 45, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39694_));
        slots[5] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.HEAD).and(stack -> stack.canEquip(EquipmentSlot.HEAD, (Entity)minionEntity)), 27, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39693_));
        assert (extraSlots == 9 || extraSlots == 12 || extraSlots == 15) : "Minion inventory has unexpected size";
        for (int i = 0; i < extraSlots; ++i) {
            slots[6 + i] = new InventoryContainer.SelectorInfo(itemStack -> true, 27 + 18 * (i / 3), 42 + 18 * (i % 3));
        }
        return slots;
    }

    public MinionContainer(int id, Inventory playerInventory, MinionEntity<?> minionEntity, @Nonnull Container inventory, int extraSlots, InventoryContainer.SelectorInfo ... selectorInfos) {
        super(ModContainer.minion, id, playerInventory, ContainerLevelAccess.m_39289_((Level)minionEntity.f_19853_, (BlockPos)minionEntity.m_142538_()), inventory, selectorInfos);
        this.minionEntity = minionEntity;
        this.extraSlots = extraSlots;
        this.availableTasks = this.minionEntity.getAvailableTasks().toArray(new IMinionTask[0]);
        this.minionEntity.setInteractingPlayer(playerInventory.f_35978_);
        this.addPlayerSlots(playerInventory, 27, 103);
        this.previousTask = this.minionEntity.getCurrentTask().map(IMinionTask.IMinionTaskDesc::getTask).orElse(null);
        this.previousTaskLocked = this.taskLocked = this.minionEntity.isTaskLocked();
    }

    @Override
    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        if (this.minionEntity.f_19853_.m_5776_()) {
            this.sendChanges();
        }
        this.minionEntity.setInteractingPlayer(null);
    }

    @Nonnull
    public IMinionTask<?, ?>[] getAvailableTasks() {
        return this.availableTasks;
    }

    public int getExtraSlots() {
        return this.extraSlots;
    }

    public Optional<IMinionTask<?, ?>> getPreviousTask() {
        return Optional.ofNullable(this.previousTask);
    }

    @Nonnull
    public IMinionTask<?, ?> getSelectedTask() {
        return this.taskToActivate != null ? this.taskToActivate : (this.previousTask != null ? this.previousTask : MinionTasks.stay);
    }

    public boolean isTaskLocked() {
        return this.taskLocked;
    }

    public void setTaskLocked(boolean taskLocked) {
        this.taskLocked = taskLocked;
    }

    @Override
    public boolean m_6875_(@Nonnull Player playerIn) {
        return this.minionEntity.m_6084_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openConfigurationScreen() {
        this.minionEntity.openAppearanceScreen();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
        this.minionEntity.openStatsScreen();
    }

    public void setTaskToActivate(int id) {
        assert (id >= 0 && id < this.availableTasks.length);
        if (id >= 0 && id < this.availableTasks.length) {
            this.taskToActivate = this.availableTasks[id];
        }
    }

    private void sendChanges() {
        if (this.taskToActivate != null && this.taskToActivate != this.previousTask) {
            this.minionEntity.getMinionId().ifPresent(id -> VampirismMod.dispatcher.sendToServer(new SelectMinionTaskPacket((int)id, this.taskToActivate.getRegistryName())));
        }
        if (this.previousTaskLocked != this.taskLocked) {
            this.minionEntity.getMinionId().ifPresent(id -> VampirismMod.dispatcher.sendToServer(new InputEventPacket("lt", "" + id)));
        }
    }

    public static class Factory
    implements IContainerFactory<MinionContainer> {
        @Nullable
        public MinionContainer create(int windowId, Inventory inv, FriendlyByteBuf data) {
            Entity e;
            if (data == null) {
                return null;
            }
            int entityId = data.m_130242_();
            Entity entity = e = inv.f_35978_.f_19853_ == null ? null : inv.f_35978_.f_19853_.m_6815_(entityId);
            if (!(e instanceof MinionEntity)) {
                LOGGER.error("Cannot find related minion entity {}", (Object)entityId);
                return null;
            }
            return MinionContainer.create(windowId, inv, (MinionEntity)e);
        }
    }
}

