/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.HunterTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.HunterIntelItem;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.IContainerFactory;

public class HunterTableContainer
extends InventoryContainer
implements ContainerListener {
    private static final InventoryContainer.SelectorInfo[] SELECTOR_INFOS = new InventoryContainer.SelectorInfo[]{new InventoryContainer.SelectorInfo(Items.f_42517_, 15, 28), new InventoryContainer.SelectorInfo(ModItems.vampire_fang, 42, 28), new InventoryContainer.SelectorInfo(ModTags.Items.PURE_BLOOD, 69, 28), new InventoryContainer.SelectorInfo(ModItems.vampire_book, 96, 28)};
    private final SlotResult slotResult;
    private final int hunterLevel;
    private final HunterLevelingConf levelingConf = HunterLevelingConf.instance();
    private ItemStack missing = ItemStack.f_41583_;

    public HunterTableContainer(int id, Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super(ModContainer.hunter_table, id, playerInventory, worldPosCallable, (Container)new SimpleContainer(SELECTOR_INFOS.length), SELECTOR_INFOS);
        ((SimpleContainer)this.inventory).m_19164_((ContainerListener)this);
        this.slotResult = new SlotResult(this, (Container)new ResultContainer(){

            public int m_6893_() {
                return 1;
            }
        }, 4, 146, 28);
        this.m_38897_(this.slotResult);
        this.hunterLevel = FactionPlayerHandler.get(playerInventory.f_35978_).getCurrentLevel(VReference.HUNTER_FACTION);
        this.addPlayerSlots(playerInventory);
    }

    public void m_5757_(@Nonnull Container invBasic) {
        this.m_6199_(invBasic);
    }

    public ItemStack getMissingItems() {
        return this.missing;
    }

    public boolean isLevelValid(boolean considerTier) {
        return considerTier ? this.levelingConf.isLevelValidForTableTier(this.hunterLevel + 1, this.worldPos.m_6721_((world, blockPos) -> {
            BlockState state = world.m_8055_(blockPos);
            return state.m_61138_(HunterTableBlock.VARIANT) ? ((HunterTableBlock.TABLE_VARIANT)((Object)((Object)state.m_61143_(HunterTableBlock.VARIANT)))).tier : 0;
        }).orElse(0)) : this.levelingConf.isLevelValidForTable(this.hunterLevel + 1);
    }

    @Override
    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        if (!playerIn.m_20193_().f_46443_) {
            this.m_150411_(playerIn, this.inventory);
        }
    }

    public void m_6199_(@Nonnull Container inventoryIn) {
        if (this.isLevelValid(true)) {
            int[] req = this.levelingConf.getItemRequirementsForTable(this.hunterLevel + 1);
            this.missing = this.checkItems(req[0], req[1], req[2], req[3]);
            if (this.missing.m_41619_()) {
                this.slotResult.f_40218_.m_6836_(0, new ItemStack((ItemLike)HunterIntelItem.getIntelForExactlyLevel(this.hunterLevel + 1)));
            } else {
                this.slotResult.f_40218_.m_6836_(0, ItemStack.f_41583_);
            }
        }
    }

    @Override
    public boolean m_6875_(@Nonnull Player playerIn) {
        return HunterTableContainer.m_38889_((ContainerLevelAccess)this.worldPos, (Player)playerIn, (Block)ModBlocks.hunter_table);
    }

    protected void onPickupResult() {
        int[] req = this.levelingConf.getItemRequirementsForTable(this.hunterLevel + 1);
        InventoryHelper.removeItems(this.inventory, new int[]{1, req[0], req[1], req[3]});
    }

    private ItemStack checkItems(int fangs, int blood, int bloodLevel, int par3) {
        return InventoryHelper.checkItems(this.inventory, new Item[]{Items.f_42517_, ModItems.vampire_fang, PureBloodItem.getBloodItemForLevel(bloodLevel), ModItems.vampire_book}, new int[]{1, fangs, blood, par3});
    }

    private static class SlotResult
    extends Slot {
        private final HunterTableContainer hunterTableContainer;

        public SlotResult(HunterTableContainer container, Container inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
            this.hunterTableContainer = container;
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }

        public void m_142406_(@Nonnull Player playerIn, @Nonnull ItemStack stack) {
            this.hunterTableContainer.onPickupResult();
        }
    }

    public static class Factory
    implements IContainerFactory<HunterTableContainer> {
        public HunterTableContainer create(int windowId, Inventory inv, FriendlyByteBuf data) {
            BlockPos pos = data.m_130135_();
            return new HunterTableContainer(windowId, inv, ContainerLevelAccess.m_39289_((Level)inv.f_35978_.f_19853_, (BlockPos)pos));
        }
    }
}

