/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HunterBasicContainer
extends InventoryContainer {
    private static final InventoryContainer.SelectorInfo[] SELECTOR_INFOS = new InventoryContainer.SelectorInfo[]{new InventoryContainer.SelectorInfo(ModItems.vampire_blood_bottle, 27, 32)};
    private final IHunterPlayer player;
    @Nullable
    private final BasicHunterEntity entity;

    @Deprecated
    public HunterBasicContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, null);
    }

    public HunterBasicContainer(int id, Inventory playerInventory, @Nullable BasicHunterEntity hunter) {
        super(ModContainer.hunter_basic, id, playerInventory, hunter == null ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)hunter.f_19853_, (BlockPos)hunter.m_142538_()), (Container)new SimpleContainer(SELECTOR_INFOS.length), SELECTOR_INFOS);
        this.player = HunterPlayer.get(playerInventory.f_35978_);
        this.addPlayerSlots(playerInventory);
        this.entity = hunter;
    }

    public int getMissingCount() {
        int targetLevel = this.player.getLevel() + 1;
        ItemStack blood = this.inventory.m_8020_(0);
        HunterLevelingConf conf = HunterLevelingConf.instance();
        if (!conf.isLevelValidForBasicHunter(targetLevel)) {
            return -1;
        }
        int required = conf.getVampireBloodCountForBasicHunter(targetLevel);
        return blood.m_41619_() || !blood.m_41720_().equals((Object)ModItems.vampire_blood_bottle) ? required : Math.max(0, required - blood.m_41613_());
    }

    public boolean canLevelUp() {
        return this.getMissingCount() == 0;
    }

    public void onLevelUpClicked() {
        if (!this.canLevelUp()) {
            return;
        }
        int target = this.player.getLevel() + 1;
        this.inventory.m_7407_(0, HunterLevelingConf.instance().getVampireBloodCountForBasicHunter(target));
        FactionPlayerHandler.getOpt(this.player.getRepresentingPlayer()).ifPresent(h -> h.setFactionLevel(VReference.HUNTER_FACTION, target));
        this.player.getRepresentingPlayer().m_5661_((Component)new TranslatableComponent("container.vampirism.basic_hunter.levelup"), false);
        this.player.getRepresentingPlayer().m_6915_();
    }

    @Override
    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        if (!playerIn.m_20193_().f_46443_) {
            this.m_150411_(playerIn, this.inventory);
        }
    }

    @Override
    public boolean m_6875_(@Nonnull Player playerIn) {
        if (this.entity == null) {
            return false;
        }
        return new Vec3(playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_()).m_82554_(new Vec3(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_())) < 5.0;
    }
}

