/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.villager;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.BloodBottleItem;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.apache.logging.log4j.LogManager;

public class Trades {
    public static final VillagerTrades.ItemListing[] converted_trades = new VillagerTrades.ItemListing[]{new VillagerTrades.EmeraldForItems((ItemLike)ModItems.human_heart, 9, 2, 2), new VillagerTrades.ItemsForEmeralds((Item)ModItems.human_heart, 3, 9, 2), new ItemsForEmeraldsTradeWithDamage(BloodBottleItem.getStackWithDamage(9), 1, 3, 12, 2)};

    public static class ItemsForEmeraldsTradeWithDamage
    implements VillagerTrades.ItemListing {
        private final ItemStack result;
        private final int emeraldAmount;
        private final int resultAmount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public ItemsForEmeraldsTradeWithDamage(Item result, int emeraldAmount, int resultAmount, int givenXP) {
            this(new ItemStack((ItemLike)result), emeraldAmount, resultAmount, 12, givenXP);
        }

        public ItemsForEmeraldsTradeWithDamage(Item result, int emeraldAmount, int resultAmount, int maxUses, int givenXP) {
            this(new ItemStack((ItemLike)result), emeraldAmount, resultAmount, maxUses, givenXP);
        }

        public ItemsForEmeraldsTradeWithDamage(ItemStack result, int emeraldAmount, int resultAmount, int maxUses, int givenXP) {
            this(result, emeraldAmount, resultAmount, maxUses, givenXP, 0.05f);
        }

        public ItemsForEmeraldsTradeWithDamage(ItemStack result, int emeraldAmount, int resultAmount, int maxUses, int givenXP, float priceMultiplier) {
            this.result = result;
            this.emeraldAmount = emeraldAmount;
            this.resultAmount = resultAmount;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_5670_(@Nonnull Entity entity, @Nonnull Random random) {
            ItemStack second = new ItemStack((ItemLike)this.result.m_41720_(), this.resultAmount);
            second.m_41721_(this.result.m_41773_());
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldAmount), second, this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }

    public static class Price {
        private final int min;
        private final int max;

        public Price(int minIn, int maxIn) {
            this.max = maxIn;
            this.min = minIn;
        }

        int getPrice(Random rand) {
            if (this.min >= this.max) {
                return this.min;
            }
            return this.min + rand.nextInt(this.max - this.min);
        }
    }

    public static class BiomeMapForEmeralds
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final ResourceKey<Biome> destination;
        private final int maxUses;
        private final int villagerXp;

        public BiomeMapForEmeralds(int pEmeraldCost, ResourceKey<Biome> pDestination, int pMaxUses, int pVillagerXp) {
            this.emeraldCost = pEmeraldCost;
            this.destination = pDestination;
            this.maxUses = pMaxUses;
            this.villagerXp = pVillagerXp;
        }

        @Nullable
        public MerchantOffer m_5670_(Entity pTrader, Random pRand) {
            Level level = pTrader.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)level;
            Biome biome = serverlevel.m_142572_().m_206579_().m_175515_(Registry.f_122885_).m_123009_(this.destination).orElse(null);
            if (biome == null) {
                LogManager.getLogger().warn("Cannot find destination biome in registry{}", this.destination);
                return null;
            }
            Pair blockpos = serverlevel.m_207571_(b -> b.m_203565_(this.destination), pTrader.m_142538_(), 2400, 8);
            if (blockpos != null) {
                ItemStack itemstack = MapItem.m_42886_((Level)serverlevel, (int)((BlockPos)blockpos.getFirst()).m_123341_(), (int)((BlockPos)blockpos.getFirst()).m_123343_(), (byte)3, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)((BlockPos)blockpos.getFirst()), (String)"+", (MapDecoration.Type)MapDecoration.Type.TARGET_POINT);
                itemstack.m_41714_((Component)new TranslatableComponent("biome." + this.destination.m_135782_().m_135827_() + "." + this.destination.m_135782_().m_135815_()));
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)Items.f_42522_), itemstack, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }

    public static class BloodBottleForHeart
    implements VillagerTrades.ItemListing {
        private final int xp;
        private final Price price;
        private final Price selling;
        private final int damage;
        private final int maxUses;

        public BloodBottleForHeart(Price priceIn, Price sellingIn, int damageIn) {
            this(priceIn, sellingIn, damageIn, 2, 8);
        }

        BloodBottleForHeart(Price priceIn, Price sellingIn, int damageIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.selling = sellingIn;
            this.damage = damageIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        @Nullable
        public MerchantOffer m_5670_(@Nonnull Entity entity, @Nonnull Random random) {
            ItemStack bottle = new ItemStack((ItemLike)ModItems.blood_bottle, this.selling.getPrice(random));
            bottle.m_41721_(this.damage);
            return new MerchantOffer(new ItemStack((ItemLike)ModItems.human_heart, this.price.getPrice(random)), bottle, this.maxUses, this.xp, 0.2f);
        }
    }

    public static class ItemsForHeart
    implements VillagerTrades.ItemListing {
        private final int xp;
        private final Price price;
        private final ItemStack[] sellingItem;
        private final Price selling;
        private final int maxUses;

        public ItemsForHeart(Price priceIn, ItemLike sellingItemIn, Price sellingIn) {
            this(priceIn, new ItemStack[]{new ItemStack((ItemLike)sellingItemIn.m_5456_())}, sellingIn, 2, 8);
        }

        public ItemsForHeart(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn) {
            this(priceIn, sellingItemIn, sellingIn, 2, 8);
        }

        public ItemsForHeart(Price priceIn, ItemLike sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = new ItemStack[]{new ItemStack((ItemLike)sellingItemIn.m_5456_())};
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        public ItemsForHeart(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = sellingItemIn;
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        @Nullable
        public MerchantOffer m_5670_(@Nonnull Entity entity, @Nonnull Random random) {
            return new MerchantOffer(new ItemStack((ItemLike)ModItems.human_heart, this.price.getPrice(random)), new ItemStack((ItemLike)this.sellingItem[random.nextInt(this.sellingItem.length)].m_41720_(), this.selling.getPrice(random)), this.maxUses, this.xp, 0.2f);
        }
    }

    public static class ItemsForSouls
    implements VillagerTrades.ItemListing {
        private final int xp;
        private final Price price;
        private final ItemStack[] sellingItem;
        private final Price selling;
        private final int maxUses;

        public ItemsForSouls(Price priceIn, ItemLike sellingItemIn, Price sellingIn) {
            this(priceIn, new ItemStack[]{new ItemStack((ItemLike)sellingItemIn.m_5456_())}, sellingIn, 2, 8);
        }

        public ItemsForSouls(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn) {
            this(priceIn, sellingItemIn, sellingIn, 2, 8);
        }

        public ItemsForSouls(Price priceIn, ItemLike sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = new ItemStack[]{new ItemStack((ItemLike)sellingItemIn.m_5456_())};
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        public ItemsForSouls(Price priceIn, ItemStack[] sellingItemIn, Price sellingIn, int xpIn, int maxUsesIn) {
            this.price = priceIn;
            this.sellingItem = sellingItemIn;
            this.selling = sellingIn;
            this.xp = xpIn;
            this.maxUses = maxUsesIn;
        }

        @Nullable
        public MerchantOffer m_5670_(@Nonnull Entity entity, @Nonnull Random random) {
            return new MerchantOffer(new ItemStack((ItemLike)ModItems.soul_orb_vampire, this.price.getPrice(random)), new ItemStack((ItemLike)this.sellingItem[random.nextInt(this.sellingItem.length)].m_41720_(), this.selling.getPrice(random)), this.maxUses, this.xp, 0.2f);
        }
    }
}

