/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.google.common.collect.Lists;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.hunter.IHunter;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.client.gui.HunterMinionAppearanceScreen;
import de.teamlapen.vampirism.client.gui.HunterMinionStatsScreen;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.goals.AttackRangedCrossbowGoal;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.items.MinionUpgradeItem;
import de.teamlapen.vampirism.items.VampirismItemCrossbow;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class HunterMinionEntity
extends MinionEntity<HunterMinionData>
implements IHunter,
AttackRangedCrossbowGoal.IAttackWithCrossbow {
    private static final EntityDataAccessor<Boolean> RAISED_ARM = SynchedEntityData.m_135353_(HunterMinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean crossbowTask = false;
    private AttackRangedCrossbowGoal<HunterMinionEntity> crossbowGoal;
    private MeleeAttackGoal meleeGoal;

    public static void init() {
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return BasicHunterEntity.getAttributeBuilder();
    }

    public HunterMinionEntity(EntityType<? extends VampirismEntity> type, Level world) {
        super(type, world, VampirismAPI.factionRegistry().getPredicate(VReference.HUNTER_FACTION, true, true, false, false, null).or(e -> !(e instanceof IFactionEntity) && e instanceof Enemy && !(e instanceof Creeper)));
    }

    @Override
    @Nonnull
    public ItemStack getArrowStackForAttack(LivingEntity target) {
        return new ItemStack((ItemLike)ModItems.crossbow_arrow_normal);
    }

    @Override
    public List<IMinionTask<?, ?>> getAvailableTasks() {
        return Lists.newArrayList((Object[])new IMinionTask[]{MinionTasks.follow_lord, MinionTasks.defend_area, MinionTasks.stay, MinionTasks.collect_hunter_items, MinionTasks.protect_lord});
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19797_ % 100 == 0) {
            this.updateAttackGoal();
        }
    }

    public void setHatType(int type) {
        assert (type >= -1);
        this.getMinionData().ifPresent(d -> {
            d.hat = type;
        });
    }

    public int getHunterType() {
        return this.getMinionData().map(d -> d.type).map(t -> Math.max(0, t)).orElse(0);
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public boolean hasMinionSpecificSkin() {
        return this.getMinionData().map(d -> d.minionSkin).orElse(false);
    }

    public int getHatType() {
        return this.m_6844_(EquipmentSlot.HEAD).m_41619_() ? this.getMinionData().map(d -> d.hat).orElse(0) : -1;
    }

    @Override
    public boolean isCrossbowInMainhand() {
        return this.m_21205_().m_41720_() instanceof VampirismItemCrossbow;
    }

    public boolean isSwingingArms() {
        return (Boolean)this.m_20088_().m_135370_(RAISED_ARM);
    }

    protected void setSwingingArms(boolean b) {
        this.m_20088_().m_135381_(RAISED_ARM, (Object)b);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openAppearanceScreen() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new HunterMinionAppearanceScreen(this, Minecraft.m_91087_().f_91080_)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new HunterMinionStatsScreen(this, Minecraft.m_91087_().f_91080_)));
    }

    public void setHunterType(int type, boolean minionSkin) {
        this.getMinionData().ifPresent(d -> {
            d.type = type;
            d.minionSkin = minionSkin;
        });
    }

    public void setUseLordSkin(boolean useLordSkin) {
        this.getMinionData().ifPresent(d -> {
            d.useLordSkin = useLordSkin;
        });
    }

    @Override
    public boolean shouldRenderLordSkin() {
        return this.getMinionData().map(d -> d.useLordSkin).orElse(false);
    }

    @Override
    public void startTargeting() {
        this.setSwingingArms(true);
    }

    @Override
    public void stopTargeting() {
        this.setSwingingArms(false);
    }

    @Override
    protected boolean canConsume(ItemStack stack) {
        if (!super.canConsume(stack)) {
            return false;
        }
        boolean fullHealth = this.m_21223_() == this.m_21233_();
        return !stack.m_41614_() || !fullHealth || stack.m_41720_().m_41473_().m_38747_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(RAISED_ARM, (Object)false);
    }

    @Override
    protected void onMinionDataReceived(@Nonnull HunterMinionData data) {
        super.onMinionDataReceived(data);
        this.updateAttackGoal();
        this.updateAttributes();
    }

    @Override
    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack heldItem;
        if (!this.f_19853_.m_5776_() && this.isLord(player) && this.minionData != null && (heldItem = player.m_21120_(hand)).m_41720_() instanceof MinionUpgradeItem && ((MinionUpgradeItem)heldItem.m_41720_()).getFaction() == this.getFaction()) {
            if (((HunterMinionData)this.minionData).level + 1 >= ((MinionUpgradeItem)heldItem.m_41720_()).getMinLevel() && ((HunterMinionData)this.minionData).level + 1 <= ((MinionUpgradeItem)heldItem.m_41720_()).getMaxLevel()) {
                ++((HunterMinionData)this.minionData).level;
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                player.m_5661_((Component)new TranslatableComponent("text.vampirism.hunter_minion.equipment_upgrade"), false);
                HelperLib.sync(this);
            } else {
                player.m_5661_((Component)new TranslatableComponent("text.vampirism.hunter_minion.equipment_wrong"), false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.0, false);
        this.crossbowGoal = new AttackRangedCrossbowGoal<HunterMinionEntity>(this, 0.8, 60, 25.0f);
        this.f_21345_.m_25352_(1, (Goal)this.meleeGoal);
    }

    private void updateAttackGoal() {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        boolean usingCrossbow = this.isCrossbowInMainhand();
        if (this.crossbowTask && !usingCrossbow) {
            this.f_21345_.m_25363_(this.crossbowGoal);
            this.f_21345_.m_25352_(1, (Goal)this.meleeGoal);
            this.crossbowTask = false;
        } else if (!this.crossbowTask && usingCrossbow) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25352_(1, this.crossbowGoal);
            this.crossbowTask = true;
        }
    }

    private void updateAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(BalanceMobProps.mobProps.MINION_MAX_HEALTH + (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * (double)this.getMinionData().map(HunterMinionData::getHealthLevel).orElse(0).intValue());
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22281_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.m_22100_(3.0 + (double)BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_DMG * (double)this.getMinionData().map(HunterMinionData::getStrengthLevel).orElse(0).intValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    static {
        MinionData.registerDataType(HunterMinionData.ID, HunterMinionData::new);
    }

    public static class HunterMinionData
    extends MinionData {
        public static final ResourceLocation ID = new ResourceLocation("vampirism", "hunter");
        public static final int MAX_LEVEL = 6;
        public static final int MAX_LEVEL_INVENTORY = 2;
        public static final int MAX_LEVEL_HEALTH = 3;
        public static final int MAX_LEVEL_STRENGTH = 3;
        public static final int MAX_LEVEL_RESOURCES = 2;
        private int type;
        private int hat;
        private boolean useLordSkin;
        private boolean minionSkin;
        private int level;
        private int inventoryLevel;
        private int healthLevel;
        private int strengthLevel;
        private int resourceEfficiencyLevel;

        public HunterMinionData(String name, int type, int hat, boolean useLordSkin) {
            super(name, 9);
            this.type = type;
            this.hat = hat;
            this.useLordSkin = useLordSkin;
            this.level = 0;
            this.minionSkin = false;
        }

        private HunterMinionData() {
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.type = nbt.m_128451_("hunter_type");
            this.hat = nbt.m_128451_("hunter_hat");
            this.level = nbt.m_128451_("level");
            this.useLordSkin = nbt.m_128471_("use_lord_skin");
            this.inventoryLevel = nbt.m_128451_("l_inv");
            this.healthLevel = nbt.m_128451_("l_he");
            this.strengthLevel = nbt.m_128451_("l_str");
            this.resourceEfficiencyLevel = nbt.m_128451_("l_res");
            this.minionSkin = nbt.m_128471_("ms");
        }

        @Override
        public MutableComponent getFormattedName() {
            return super.getFormattedName().m_130938_(style -> style.m_131148_(VReference.HUNTER_FACTION.getChatColor()));
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public int getInventoryLevel() {
            return this.inventoryLevel;
        }

        @Override
        public int getInventorySize() {
            int size = this.getDefaultInventorySize();
            return this.inventoryLevel == 1 ? size + 3 : (this.inventoryLevel == 2 ? size + 6 : size);
        }

        public int getLevel() {
            return this.level;
        }

        public int getRemainingStatPoints() {
            return Math.max(0, this.level - this.inventoryLevel - this.healthLevel - this.resourceEfficiencyLevel - this.strengthLevel);
        }

        public int getResourceEfficiencyLevel() {
            return this.resourceEfficiencyLevel;
        }

        public int getStrengthLevel() {
            return this.strengthLevel;
        }

        @Override
        public void handleMinionAppearanceConfig(String newName, int ... data) {
            this.setName(newName);
            if (data.length >= 3) {
                this.type = data[0];
                this.hat = data[1];
                this.useLordSkin = (data[2] & 1) == 1;
                this.minionSkin = (data[2] & 2) == 2;
            }
        }

        @Override
        public boolean hasUsedSkillPoints() {
            return this.inventoryLevel + this.healthLevel + this.strengthLevel + this.resourceEfficiencyLevel > 0;
        }

        @Override
        public void resetStats(MinionEntity<?> entity) {
            assert (entity instanceof HunterMinionEntity);
            this.inventoryLevel = 0;
            this.healthLevel = 0;
            this.strengthLevel = 0;
            this.resourceEfficiencyLevel = 0;
            this.shrinkInventory(entity);
            ((HunterMinionEntity)entity).updateAttributes();
            super.resetStats(entity);
        }

        @Override
        public void serializeNBT(CompoundTag tag) {
            super.serializeNBT(tag);
            tag.m_128405_("hunter_type", this.type);
            tag.m_128405_("hunter_hat", this.hat);
            tag.m_128405_("level", this.level);
            tag.m_128405_("l_inv", this.inventoryLevel);
            tag.m_128405_("l_he", this.healthLevel);
            tag.m_128405_("l_str", this.strengthLevel);
            tag.m_128405_("l_res", this.resourceEfficiencyLevel);
            tag.m_128379_("use_lord_skin", this.useLordSkin);
            tag.m_128379_("ms", this.minionSkin);
        }

        public boolean setLevel(int level) {
            if (level < 0 || level > 6) {
                return false;
            }
            boolean levelup = level > this.level;
            this.level = level;
            return levelup;
        }

        @Override
        public boolean upgradeStat(int statId, MinionEntity<?> entity) {
            if (super.upgradeStat(statId, entity)) {
                return true;
            }
            if (this.getRemainingStatPoints() == 0) {
                LOGGER.warn("Cannot upgrade minion stat as no stat points are left");
                return false;
            }
            assert (entity instanceof HunterMinionEntity);
            switch (statId) {
                case 0: {
                    if (this.inventoryLevel >= 2) {
                        return false;
                    }
                    ++this.inventoryLevel;
                    this.getInventory().setAvailableSize(this.getInventorySize());
                    return true;
                }
                case 1: {
                    if (this.healthLevel >= 3) {
                        return false;
                    }
                    ++this.healthLevel;
                    ((HunterMinionEntity)entity).updateAttributes();
                    entity.m_21153_(entity.m_21233_());
                    return true;
                }
                case 2: {
                    if (this.strengthLevel >= 3) {
                        return false;
                    }
                    ++this.strengthLevel;
                    ((HunterMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 3: {
                    if (this.resourceEfficiencyLevel >= 2) {
                        return false;
                    }
                    ++this.resourceEfficiencyLevel;
                    return true;
                }
            }
            LOGGER.warn("Cannot upgrade minion stat {} as it does not exist", (Object)statId);
            return false;
        }

        @Override
        protected ResourceLocation getDataType() {
            return ID;
        }
    }
}

