/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IAggressiveVillager;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.VampirismVillagerEntity;
import de.teamlapen.vampirism.entity.goals.DefendVillageGoal;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class AggressiveVillagerEntity
extends VampirismVillagerEntity
implements IHunterMob,
IAggressiveVillager,
IVillageCaptureEntity {
    @Nullable
    private ICaptureAttributes villageAttributes;

    public static AggressiveVillagerEntity makeHunter(@Nonnull Villager villager) {
        AggressiveVillagerEntity hunter = (AggressiveVillagerEntity)ModEntities.villager_angry.m_20615_(villager.f_19853_);
        assert (hunter != null);
        CompoundTag nbt = new CompoundTag();
        if (villager.m_5803_()) {
            villager.m_5796_();
        }
        villager.m_20240_(nbt);
        hunter.m_20258_(nbt);
        hunter.m_20084_(Mth.m_14062_((Random)hunter.f_19796_));
        hunter.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ModItems.pitchfork));
        return hunter;
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampirismVillagerEntity.getAttributeBuilder().m_22268_(Attributes.f_22276_, BalanceMobProps.mobProps.HUNTER_VILLAGER_MAX_HEALTH);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public AggressiveVillagerEntity(EntityType<? extends AggressiveVillagerEntity> type, Level worldIn) {
        super(type, worldIn);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    @Override
    public void attackVillage(ICaptureAttributes villageAttributes) {
        this.villageAttributes = villageAttributes;
    }

    @Override
    public void defendVillage(ICaptureAttributes villageAttributes) {
        this.villageAttributes = villageAttributes;
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public boolean isAttackingVillage() {
        return false;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null;
    }

    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.pitchfork));
        return data;
    }

    public void m_35483_(@Nonnull ServerLevel serverWorldIn) {
    }

    @Override
    public void stopVillageAttackDefense() {
        Villager villager = (Villager)EntityType.f_20492_.m_20615_(this.f_19853_);
        assert (villager != null);
        this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        CompoundTag nbt = new CompoundTag();
        this.m_20240_(nbt);
        villager.m_20258_(nbt);
        villager.m_20084_(Mth.m_14062_((Random)this.f_19796_));
        UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)villager);
    }

    @Nonnull
    protected Component m_5677_() {
        return this.m_6095_().m_20676_();
    }

    protected void m_35424_(@Nonnull Brain<Villager> brainIn) {
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(8, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.55, false, 400, () -> true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.f_21346_.m_25352_(3, new DefendVillageGoal<AggressiveVillagerEntity>(this));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal<PathfinderMob>((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)){

            protected double m_7623_() {
                return super.m_7623_() / 2.0;
            }
        });
    }
}

