/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import com.mojang.authlib.GameProfile;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.hunter.IAdvancedHunter;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.IPlayerOverlay;
import de.teamlapen.vampirism.util.PlayerSkinHelper;
import de.teamlapen.vampirism.util.SupporterManager;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancedHunterEntity
extends HunterBaseEntity
implements IAdvancedHunter,
IPlayerOverlay,
IEntityActionUser {
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(AdvancedHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(AdvancedHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.m_135353_(AdvancedHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(AdvancedHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final int MAX_LEVEL = 1;
    private static final int MOVE_TO_RESTRICT_PRIO = 3;
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    private final EntityActionTier entitytier;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private Pair<ResourceLocation, Boolean> skinDetails;
    @Nullable
    private String lootBookId;
    private boolean attack;
    @Nullable
    private ICaptureAttributes villageAttributes;

    public static AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampirismEntity.getAttributeBuilder().m_22268_(Attributes.f_22276_, (double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION).m_22268_(Attributes.f_22281_, (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.m_22268_(Attributes.f_22279_, 0.285);
    }

    public AdvancedHunterEntity(EntityType<? extends AdvancedHunterEntity> type, Level world) {
        super(type, world, true);
        this.saveHome = true;
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.setDontDropEquipment();
        this.entitytier = EntityActionTier.High;
        this.entityclass = EntityClassType.getRandomClass(this.m_21187_());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<AdvancedHunterEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("level", this.getEntityLevel());
        nbt.m_128405_("type", this.getHunterType());
        nbt.m_128359_("texture", (String)this.m_20088_().m_135370_(TEXTURE));
        nbt.m_128359_("name", (String)this.m_20088_().m_135370_(NAME));
        nbt.m_128405_("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
        nbt.m_128379_("attack", this.attack);
        if (this.lootBookId != null) {
            nbt.m_128359_("lootBookId", this.lootBookId);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    @Override
    public void defendVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = false;
    }

    @Override
    public ActionHandlerEntity<?> getActionHandler() {
        return this.entityActionHandler;
    }

    public boolean m_7327_(@Nonnull Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag && this.m_21205_().m_41619_()) {
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
        return flag;
    }

    public Optional<String> getBookLootId() {
        return Optional.ofNullable(this.lootBookId);
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public int getHunterType() {
        return (Integer)this.m_20088_().m_135370_(TYPE);
    }

    @Override
    public int getEntityLevel() {
        return (Integer)this.m_20088_().m_135370_(LEVEL);
    }

    @Override
    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.m_20088_().m_135381_(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 1) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1000000, 1));
            }
        }
    }

    @Override
    public int getMaxEntityLevel() {
        return 1;
    }

    @Nonnull
    public Component m_7755_() {
        String senderName = (String)this.m_20088_().m_135370_(NAME);
        return "none".equals(senderName) ? super.m_7755_() : new TextComponent(senderName);
    }

    @Override
    @Nullable
    public Optional<Pair<ResourceLocation, Boolean>> getOverlayPlayerProperties() {
        if (this.skinDetails == null) {
            String name = this.getTextureName();
            if (name == null) {
                return Optional.empty();
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PlayerSkinHelper.obtainPlayerSkinPropertiesAsync(new GameProfile(null, name), p -> {
                this.skinDetails = p;
            }));
            this.skinDetails = PENDING_PROP;
        }
        return Optional.of(this.skinDetails);
    }

    @Override
    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    @Nullable
    public String getTextureName() {
        String texture = (String)this.m_20088_().m_135370_(TEXTURE);
        return "none".equals(texture) ? null : texture;
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean isLookingForHome() {
        return this.getHome() == null;
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag tagCompund) {
        super.m_7378_(tagCompund);
        if (tagCompund.m_128441_("level")) {
            this.setEntityLevel(tagCompund.m_128451_("level"));
        }
        if (tagCompund.m_128441_("type")) {
            this.m_20088_().m_135381_(TYPE, (Object)tagCompund.m_128451_("type"));
            this.m_20088_().m_135381_(NAME, (Object)tagCompund.m_128461_("name"));
            this.m_20088_().m_135381_(TEXTURE, (Object)tagCompund.m_128461_("texture"));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
        if (tagCompund.m_128441_("attack")) {
            this.attack = tagCompund.m_128471_("attack");
        }
        if (tagCompund.m_128441_("lootBookId")) {
            this.lootBookId = tagCompund.m_128461_("lootBookId");
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return super.m_6785_(distanceToClosestPlayer) && this.isLookingForHome();
    }

    @Override
    public void setCampArea(AABB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    @Override
    public void stopVillageAttackDefense() {
        this.m_6593_(null);
        this.villageAttributes = null;
    }

    public boolean m_6052_() {
        return true;
    }

    @Override
    public int suggestEntityLevel(Difficulty d) {
        if (this.f_19796_.nextBoolean()) {
            return (int)((float)(d.avgPercLevel * 1) / 100.0f);
        }
        return this.f_19796_.nextInt(2);
    }

    protected void m_8097_() {
        super.m_8097_();
        SupporterManager.Supporter supporter = SupporterManager.getInstance().getRandomHunter(this.f_19796_);
        this.m_20088_().m_135372_(LEVEL, (Object)-1);
        this.m_20088_().m_135372_(TYPE, (Object)supporter.typeId());
        this.m_20088_().m_135372_(NAME, (Object)(supporter.senderName() == null ? "none" : supporter.senderName()));
        this.m_20088_().m_135372_(TEXTURE, (Object)(supporter.textureName() == null ? "none" : supporter.textureName()));
        this.lootBookId = supporter.bookID();
    }

    protected int m_6552_(@Nonnull Player player) {
        return 10 * (1 + this.getEntityLevel());
    }

    @Override
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? ModEntities.advanced_hunter_imob : ModEntities.advanced_hunter;
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.tryCureSanguinare(player)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7, 50));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 13.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, VampireBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AttackVillageGoal<AdvancedHunterEntity>(this));
        this.f_21346_.m_25352_(2, new DefendVillageGoal<AdvancedHunterEntity>(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true, true));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, PatrollingMonster.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, StructureFeature.f_67028_)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getEntityLevel(), 0);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22276_);
        double d = BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION;
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.m_22100_(d + 30.0 * (double)l);
        AttributeInstance attributeInstance2 = this.m_21051_(Attributes.f_22281_);
        double d2 = BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER;
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance2.m_22100_(d2 + 3.0 * (double)l);
    }

    public static class IMob
    extends AdvancedHunterEntity
    implements Enemy {
        public IMob(EntityType<? extends AdvancedHunterEntity> type, Level world) {
            super(type, world);
        }
    }
}

