/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.goals;

import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class AttackRangedCrossbowGoal<T extends VampirismEntity>
extends Goal {
    private final T entity;
    private final double moveSpeedAmp;
    private final float maxAttackDistance;
    private final int attackCooldown;
    private int seeTime;
    private int strafingTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int attackTime;

    public AttackRangedCrossbowGoal(T entity, double speedAmplifier, int delay, float maxDistance) {
        this.entity = entity;
        this.moveSpeedAmp = speedAmplifier;
        this.attackCooldown = delay;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.entity.m_21573_().m_26571_()) && ((IAttackWithCrossbow)this.entity).isCrossbowInMainhand();
    }

    public boolean m_8036_() {
        return this.entity.m_5448_() != null && ((IAttackWithCrossbow)this.entity).isCrossbowInMainhand();
    }

    public void m_8056_() {
        super.m_8056_();
        ((IAttackWithCrossbow)this.entity).startTargeting();
    }

    public void m_8041_() {
        super.m_8041_();
        this.seeTime = 0;
        this.attackTime = -1;
        ((IAttackWithCrossbow)this.entity).stopTargeting();
    }

    public void m_8037_() {
        LivingEntity entitylivingbase = this.entity.m_5448_();
        if (entitylivingbase != null) {
            boolean couldSee;
            double d0 = this.entity.m_20275_(entitylivingbase.m_20185_(), entitylivingbase.m_142469_().f_82289_, entitylivingbase.m_20189_());
            boolean canSee = this.entity.m_21574_().m_148306_((Entity)entitylivingbase);
            boolean bl = couldSee = this.seeTime > 0;
            if (canSee != couldSee) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.entity.m_21573_().m_5624_((Entity)entitylivingbase, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.m_21187_().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.m_21187_().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.m_21391_((Entity)entitylivingbase, 30.0f, 30.0f);
            } else {
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, entitylivingbase.m_20299_(1.0f));
            }
            if (--this.attackTime <= 0 && this.seeTime >= -30) {
                this.attackWithCrossbow(entitylivingbase);
                this.attackTime = this.attackCooldown;
            }
        }
    }

    protected void attackWithCrossbow(LivingEntity target) {
        ItemStack arrows = ((IAttackWithCrossbow)this.entity).getArrowStackForAttack(target);
        CrossbowArrowEntity entityArrow = CrossbowArrowEntity.createWithShooter(this.entity.m_20193_(), this.entity, 0.0, 0.3f, !this.entity.m_21526_(), arrows);
        double sx = target.m_20185_() - entityArrow.m_20185_();
        double sy = target.m_142469_().f_82289_ + (double)(target.m_20206_() / 3.0f) - entityArrow.m_20186_();
        double sz = target.m_20189_() - entityArrow.m_20189_();
        double dist = Math.sqrt(sx * sx + sz * sz);
        entityArrow.m_6686_(sx, sy + dist * 0.2, sz, 1.6f, 13 - target.m_20193_().m_46791_().m_19028_() * 4);
        this.entity.m_5496_(ModSounds.crossbow, 0.5f, 1.0f);
        this.entity.m_20193_().m_7967_((Entity)entityArrow);
    }

    public static interface IAttackWithCrossbow {
        @Nonnull
        public ItemStack getArrowStackForAttack(LivingEntity var1);

        public boolean isCrossbowInMainhand();

        public void startTargeting();

        public void stopTargeting();
    }
}

