/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillage;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillageBuilder;
import de.teamlapen.vampirism.entity.factions.FactionVillage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class FactionVillageBuilder
implements IFactionVillageBuilder,
IFactionVillage {
    private Supplier<MobEffect> badOmenEffect = () -> null;
    private Supplier<ItemStack> bannerStack = () -> new ItemStack((ItemLike)Items.f_42660_);
    private Supplier<List<CaptureEntityEntry>> captureEntities = Collections::emptyList;
    private Supplier<VillagerProfession> factionVillageProfession = () -> VillagerProfession.f_35585_;
    private Class<? extends Mob> guardSuperClass = Mob.class;
    private Supplier<EntityType<? extends ITaskMasterEntity>> taskMasterEntity = () -> null;
    private Supplier<Block> fragileTotem = () -> Blocks.f_50016_;
    private Supplier<Block> craftedTotem = () -> Blocks.f_50016_;

    @Override
    public IFactionVillageBuilder badOmenEffect(Supplier<MobEffect> badOmenEffect) {
        this.badOmenEffect = badOmenEffect;
        return this;
    }

    @Override
    public IFactionVillageBuilder banner(Supplier<ItemStack> bannerItem) {
        this.bannerStack = bannerItem;
        return this;
    }

    @Override
    public IFactionVillageBuilder captureEntities(Supplier<List<CaptureEntityEntry>> captureEntities) {
        this.captureEntities = captureEntities;
        return this;
    }

    @Override
    public IFactionVillageBuilder factionVillagerProfession(Supplier<VillagerProfession> profession) {
        this.factionVillageProfession = profession;
        return this;
    }

    @Override
    public IFactionVillageBuilder guardSuperClass(Class<? extends Mob> clazz) {
        this.guardSuperClass = clazz;
        return this;
    }

    @Override
    public IFactionVillageBuilder taskMaster(Supplier<EntityType<? extends ITaskMasterEntity>> taskmaster) {
        this.taskMasterEntity = taskmaster;
        return this;
    }

    @Override
    public IFactionVillageBuilder totem(Supplier<Block> fragile, Supplier<Block> crafted) {
        this.fragileTotem = fragile;
        this.craftedTotem = crafted;
        return this;
    }

    @Override
    public FactionVillage build() {
        return new FactionVillage(this.badOmenEffect.get(), this.bannerStack.get(), (ImmutableList<CaptureEntityEntry>)ImmutableList.copyOf((Collection)this.captureEntities.get()), this.factionVillageProfession.get(), this.guardSuperClass, this.taskMasterEntity.get(), this.fragileTotem.get(), this.craftedTotem.get());
    }

    @Override
    @Deprecated
    public List<CaptureEntityEntry> getCaptureEntries() {
        return this.captureEntities.get();
    }

    @Override
    @Deprecated
    @Nonnull
    public VillagerProfession getFactionVillageProfession() {
        return this.factionVillageProfession.get();
    }

    @Override
    @Deprecated
    @Nonnull
    public Class<? extends Mob> getGuardSuperClass() {
        return this.guardSuperClass;
    }

    @Override
    @Deprecated
    @Nullable
    public EntityType<? extends ITaskMasterEntity> getTaskMasterEntity() {
        return this.taskMasterEntity.get();
    }

    @Override
    @Nullable
    public MobEffect getBadOmenEffect() {
        return this.badOmenEffect.get();
    }

    @Override
    @Nonnull
    public ItemStack getBanner() {
        return this.bannerStack.get();
    }

    @Override
    public boolean isBanner(@Nonnull ItemStack stack) {
        return ItemStack.m_41728_((ItemStack)stack, (ItemStack)this.bannerStack.get());
    }

    @Override
    @Nonnull
    public Block getTotemTopBlock(boolean crafted) {
        return crafted ? this.craftedTotem.get() : this.fragileTotem.get();
    }
}

