/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillage;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class FactionVillage
implements IFactionVillage {
    private final MobEffect badOmenEffect;
    private final ItemStack bannerStack;
    private final ImmutableList<CaptureEntityEntry> captureEntities;
    private final VillagerProfession factionVillageProfession;
    private final Class<? extends Mob> guardSuperClass;
    private final EntityType<? extends ITaskMasterEntity> taskMasterEntity;
    private final Block fragileTotem;
    private final Block craftedTotem;

    public FactionVillage(@Nullable MobEffect badOmenEffect, @Nonnull ItemStack bannerStack, @Nonnull ImmutableList<CaptureEntityEntry> captureEntities, @Nonnull VillagerProfession factionVillageProfession, @Nonnull Class<? extends Mob> guardSuperClass, @Nullable EntityType<? extends ITaskMasterEntity> taskMasterEntity, @Nonnull Block fragileTotem, @Nonnull Block craftedTotem) {
        this.badOmenEffect = badOmenEffect;
        this.bannerStack = bannerStack;
        this.captureEntities = captureEntities;
        this.factionVillageProfession = factionVillageProfession;
        this.guardSuperClass = guardSuperClass;
        this.taskMasterEntity = taskMasterEntity;
        this.fragileTotem = fragileTotem;
        this.craftedTotem = craftedTotem;
    }

    @Override
    @Nullable
    public MobEffect getBadOmenEffect() {
        return this.badOmenEffect;
    }

    @Override
    @Nonnull
    public ItemStack getBanner() {
        return this.bannerStack.m_41777_();
    }

    @Override
    public List<CaptureEntityEntry> getCaptureEntries() {
        return this.captureEntities;
    }

    @Override
    @Nonnull
    public VillagerProfession getFactionVillageProfession() {
        return this.factionVillageProfession;
    }

    @Override
    @Nonnull
    public Class<? extends Mob> getGuardSuperClass() {
        return this.guardSuperClass;
    }

    @Override
    @Nullable
    public EntityType<? extends ITaskMasterEntity> getTaskMasterEntity() {
        return this.taskMasterEntity;
    }

    @Override
    @Nonnull
    public Block getTotemTopBlock(boolean crafted) {
        return crafted ? this.craftedTotem : this.fragileTotem;
    }

    @Override
    public boolean isBanner(@Nonnull ItemStack stack) {
        return ItemStack.m_41728_((ItemStack)this.bannerStack, (ItemStack)stack);
    }
}

