/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionBuilder;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillageBuilder;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFactionBuilder;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.entity.factions.Faction;
import de.teamlapen.vampirism.entity.factions.FactionVillageBuilder;
import de.teamlapen.vampirism.entity.factions.PlayableFaction;
import de.teamlapen.vampirism.entity.factions.PredicateFaction;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.NonNullSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactionRegistry
implements IFactionRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Integer, Predicate<LivingEntity>> predicateMap = new HashMap<Integer, Predicate<LivingEntity>>();
    private List<Faction<?>> temp = new CopyOnWriteArrayList();
    private Faction<?>[] allFactions;
    private PlayableFaction<?>[] playableFactions;

    public void finish() {
        this.allFactions = this.temp.toArray(new Faction[0]);
        this.temp = null;
        ArrayList<PlayableFaction> temp2 = new ArrayList<PlayableFaction>();
        for (Faction<?> allFaction : this.allFactions) {
            allFaction.finish();
            if (!(allFaction instanceof PlayableFaction)) continue;
            temp2.add((PlayableFaction)allFaction);
        }
        this.playableFactions = temp2.toArray(new PlayableFaction[0]);
    }

    @Override
    @Nullable
    public IFaction<?> getFaction(Entity entity) {
        if (entity instanceof IFactionEntity) {
            return ((IFactionEntity)entity).getFaction();
        }
        if (entity instanceof Player) {
            return VampirismPlayerAttributes.get((Player)((Player)entity)).faction;
        }
        return null;
    }

    @Override
    @Nullable
    public IFaction<?> getFactionByID(ResourceLocation id) {
        if (this.allFactions == null) {
            return null;
        }
        for (Faction<?> f : this.allFactions) {
            if (!f.getID().equals((Object)id)) continue;
            return f;
        }
        return null;
    }

    public Faction<?>[] getFactions() {
        return this.allFactions;
    }

    public PlayableFaction<?>[] getPlayableFactions() {
        return this.playableFactions;
    }

    @Override
    public Predicate<LivingEntity> getPredicate(IFaction<?> thisFaction, boolean ignoreDisguise) {
        return this.getPredicate(thisFaction, true, true, true, ignoreDisguise, null);
    }

    @Override
    public Predicate<LivingEntity> getPredicate(IFaction<?> thisFaction, boolean player, boolean mob, boolean neutralPlayer, boolean ignoreDisguise, @Nullable IFaction<?> otherFaction) {
        Object predicate;
        int id;
        int key = 0;
        if (otherFaction != null) {
            id = otherFaction.hashCode();
            if (id > 63) {
                LOGGER.warn("Faction id over 64, predicates won't work");
            }
            key |= (id & 0x3F) << 10;
        }
        if (player) {
            key |= 0x200;
        }
        if (mob) {
            key |= 0x100;
        }
        if (neutralPlayer) {
            key |= 0x80;
        }
        if (ignoreDisguise) {
            key |= 0x40;
        }
        if ((id = thisFaction.hashCode()) > 64) {
            LOGGER.warn("Faction id over 64, predicates won't work");
        }
        if (this.predicateMap.containsKey(key |= id & 0x3F)) {
            predicate = this.predicateMap.get(key);
        } else {
            predicate = new PredicateFaction(thisFaction, player, mob, neutralPlayer, ignoreDisguise, otherFaction);
            this.predicateMap.put(key, (Predicate<LivingEntity>)predicate);
        }
        return predicate;
    }

    private void addFaction(Faction<?> faction) {
        if (this.temp == null) {
            throw new IllegalStateException(String.format("[Vampirism]You have to register factions during InterModEnqueueEvent. (%s)", faction.getID()));
        }
        this.temp.add(faction);
    }

    @Override
    public <T extends IFactionEntity> IFactionBuilder<T> createFaction(ResourceLocation id, Class<T> entityInterface) {
        if (!UtilLib.isNonNull(id, entityInterface)) {
            throw new IllegalArgumentException("[Vampirism] Parameter for faction cannot be null");
        }
        return new FactionBuilder<T>(id, entityInterface);
    }

    @Override
    public <T extends IFactionPlayer<T>> IPlayableFactionBuilder<T> createPlayableFaction(ResourceLocation id, Class<T> entityInterface, NonNullSupplier<Capability<T>> playerCapabilitySupplier) {
        if (!UtilLib.isNonNull(id, entityInterface, playerCapabilitySupplier)) {
            throw new IllegalArgumentException("[Vampirism] Parameters for faction cannot be null");
        }
        return new PlayableFactionBuilder<T>(id, entityInterface, playerCapabilitySupplier);
    }

    private class FactionBuilder<T extends IFactionEntity>
    implements IFactionBuilder<T> {
        protected final ResourceLocation id;
        protected final Class<T> entityInterface;
        protected int color = Color.WHITE.getRGB();
        protected boolean hostileTowardsNeutral;
        protected FactionVillageBuilder villageFactionData = new FactionVillageBuilder();
        protected TextColor chatColor;
        protected String name;
        protected String namePlural;

        public FactionBuilder(ResourceLocation id, Class<T> entityInterface) {
            this.id = id;
            this.entityInterface = entityInterface;
        }

        @Override
        public IFactionBuilder<T> color(int color) {
            this.color = color;
            return this;
        }

        @Override
        public IFactionBuilder<T> chatColor(TextColor color) {
            this.chatColor = color;
            return this;
        }

        @Override
        public IFactionBuilder<T> chatColor(ChatFormatting color) {
            if (!color.m_126664_()) {
                throw new IllegalArgumentException("Parameter must be a color");
            }
            this.chatColor = TextColor.m_131270_((ChatFormatting)color);
            return this;
        }

        @Override
        public IFactionBuilder<T> hostileTowardsNeutral() {
            this.hostileTowardsNeutral = true;
            return this;
        }

        @Override
        public IFactionBuilder<T> village(@Nonnull Consumer<IFactionVillageBuilder> villageBuilder) {
            villageBuilder.accept(this.villageFactionData);
            return this;
        }

        @Override
        public IFactionBuilder<T> name(@Nonnull String nameKey) {
            this.name = nameKey;
            return this;
        }

        @Override
        public IFactionBuilder<T> namePlural(@Nonnull String namePluralKey) {
            this.namePlural = namePluralKey;
            return this;
        }

        @Override
        public IFaction<T> register() {
            Faction<T> faction = new Faction<T>(this.id, this.entityInterface, this.color, this.hostileTowardsNeutral, this.villageFactionData, this.chatColor != null ? this.chatColor : TextColor.m_131266_((int)this.color), (Component)(this.name == null ? new TextComponent(this.id.toString()) : new TranslatableComponent(this.name)), (Component)(this.namePlural == null ? (this.name == null ? new TextComponent(this.id.toString()) : new TranslatableComponent(this.name)) : new TranslatableComponent(this.namePlural)));
            FactionRegistry.this.addFaction(faction);
            return faction;
        }
    }

    private class PlayableFactionBuilder<T extends IFactionPlayer<T>>
    extends FactionBuilder<T>
    implements IPlayableFactionBuilder<T> {
        protected final NonNullSupplier<Capability<T>> playerCapabilitySupplier;
        protected int highestLevel;
        protected int highestLordLevel;
        protected BiFunction<Integer, Boolean, Component> lordTitleFunction;
        protected Function<IRefinementItem.AccessorySlotType, IRefinementItem> refinementItemBySlot;

        public PlayableFactionBuilder(ResourceLocation id, Class<T> entityInterface, NonNullSupplier<Capability<T>> playerCapabilitySupplier) {
            super(id, entityInterface);
            this.highestLevel = 1;
            this.highestLordLevel = 0;
            this.playerCapabilitySupplier = playerCapabilitySupplier;
        }

        @Override
        public IPlayableFactionBuilder<T> color(int color) {
            return (IPlayableFactionBuilder)super.color(color);
        }

        @Override
        public IPlayableFactionBuilder<T> hostileTowardsNeutral() {
            return (IPlayableFactionBuilder)super.hostileTowardsNeutral();
        }

        @Override
        public IPlayableFactionBuilder<T> highestLevel(int highestLevel) {
            this.highestLevel = highestLevel;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> lordLevel(int highestLordLevel) {
            this.highestLordLevel = highestLordLevel;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> lordTitle(@Nonnull BiFunction<Integer, Boolean, Component> lordTitleFunction) {
            this.lordTitleFunction = lordTitleFunction;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> village(@Nonnull Consumer<IFactionVillageBuilder> villageBuilder) {
            return (IPlayableFactionBuilder)super.village(villageBuilder);
        }

        @Override
        public IPlayableFactionBuilder<T> refinementItems(@Nonnull Function<IRefinementItem.AccessorySlotType, IRefinementItem> refinementItemBySlot) {
            this.refinementItemBySlot = refinementItemBySlot;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> chatColor(@Nonnull TextColor color) {
            return (IPlayableFactionBuilder)super.chatColor(color);
        }

        @Override
        public IPlayableFactionBuilder<T> chatColor(ChatFormatting color) {
            return (IPlayableFactionBuilder)super.chatColor(color);
        }

        @Override
        public IPlayableFactionBuilder<T> name(@Nonnull String nameKey) {
            return (IPlayableFactionBuilder)super.name(nameKey);
        }

        @Override
        public IPlayableFactionBuilder<T> namePlural(@Nonnull String namePluralKey) {
            return (IPlayableFactionBuilder)super.namePlural(namePluralKey);
        }

        @Override
        public IPlayableFaction<T> register() {
            if (this.lordTitleFunction == null) {
                this.lordTitleFunction = (a, b) -> new TextComponent("Lord " + a);
            }
            PlayableFaction<T> faction = new PlayableFaction<T>(this.id, this.entityInterface, this.color, this.hostileTowardsNeutral, this.playerCapabilitySupplier, this.highestLevel, this.highestLordLevel, this.lordTitleFunction, this.villageFactionData, this.refinementItemBySlot, this.chatColor != null ? this.chatColor : TextColor.m_131266_((int)this.color), (Component)(this.name == null ? new TextComponent(this.id.toString()) : new TranslatableComponent(this.name)), (Component)(this.namePlural == null ? (this.name == null ? new TextComponent(this.id.toString()) : new TranslatableComponent(this.name)) : new TranslatableComponent(this.namePlural)));
            FactionRegistry.this.addFaction(faction);
            return faction;
        }
    }
}

