/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillage;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PathfinderMob;

public class Faction<T extends IFactionEntity>
implements IFaction<T> {
    private static int nextId = 0;
    protected final ResourceLocation id;
    private final Class<T> entityInterface;
    private final int color;
    private final boolean hostileTowardsNeutral;
    private final int integerId;
    @Nonnull
    private IFactionVillage villageFactionData;
    @Nonnull
    private final Component name;
    @Nonnull
    private final Component namePlural;
    @Nonnull
    private final TextColor chatColor;

    Faction(ResourceLocation id, Class<T> entityInterface, int color, boolean hostileTowardsNeutral, @Nonnull IFactionVillage villageFactionData, @Nonnull TextColor chatColor, @Nonnull Component name, @Nonnull Component namePlural) {
        this.id = id;
        this.entityInterface = entityInterface;
        this.color = color;
        this.hostileTowardsNeutral = hostileTowardsNeutral;
        this.villageFactionData = villageFactionData;
        this.chatColor = chatColor;
        this.name = name;
        this.namePlural = namePlural;
        this.integerId = nextId++;
    }

    void finish() {
        this.villageFactionData = this.villageFactionData.build();
    }

    public boolean equals(Object obj) {
        return obj instanceof Faction && this.id == ((Faction)obj).id;
    }

    @Override
    @Nonnull
    public TextColor getChatColor() {
        return this.chatColor;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public Class<T> getFactionEntityInterface() {
        return this.entityInterface;
    }

    @Override
    public ResourceLocation getID() {
        return this.id;
    }

    @Override
    @Nonnull
    public Component getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Component getNamePlural() {
        return this.namePlural;
    }

    @Override
    @Nonnull
    public IFactionVillage getVillageData() {
        return this.villageFactionData;
    }

    public int hashCode() {
        return this.integerId;
    }

    @Override
    public boolean isEntityOfFaction(PathfinderMob creature) {
        return this.entityInterface.isInstance(creature);
    }

    @Override
    public boolean isHostileTowardsNeutral() {
        return this.hostileTowardsNeutral;
    }

    public String toString() {
        return "Faction{id='" + this.integerId + "', hash=" + this.integerId + "}";
    }
}

