/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.ICurableConvertedCreature;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

public interface CurableConvertedCreature<T extends PathfinderMob, Z extends PathfinderMob>
extends ICurableConvertedCreature<T> {
    public Data<T> data();

    default public boolean hurtC(DamageSource damageSource, float amount) {
        PathfinderMob entity = (PathfinderMob)this;
        if (this.data().vulnerableToFire) {
            if (DamageSource.f_19305_.equals(damageSource)) {
                return entity.m_6469_(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amount));
            }
            if (DamageSource.f_19307_.equals(damageSource)) {
                return entity.m_6469_(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amount));
            }
        }
        return this.hurtSuper(damageSource, amount);
    }

    default public InteractionResult mobInteractC(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() != ModItems.cure_apple) {
            return this.mobInteractSuper(player, hand);
        }
        return this.interactWithCureItem(player, stack, (PathfinderMob)this);
    }

    @Override
    default public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        ((PathfinderMob)this).m_7292_(new MobEffectInstance(MobEffects.f_19605_, amt * 20));
    }

    default public Component getNameC(Supplier<Component> baseName) {
        if (this.data().name == null) {
            this.data().name = new TranslatableComponent("entity.vampirism.vampire").m_7220_(baseName.get());
        }
        return this.data().name;
    }

    default public void handleEntityEventC(byte id) {
        if (!this.handleSound(id, (PathfinderMob)this)) {
            this.handleEntityEventSuper(id);
        }
    }

    @Override
    default public boolean doesResistGarlic(EnumStrength strength) {
        return !strength.isStrongerThan(EnumStrength.NONE);
    }

    @Override
    @Nonnull
    default public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.data().garlicCache = Helper.getGarlicStrength((Entity)((PathfinderMob)this), iWorld);
        }
        return this.data().garlicCache;
    }

    @Override
    default public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.data().sundamageCache;
        }
        this.data().sundamageCache = Helper.gettingSundamge((LivingEntity)((PathfinderMob)this), iWorld, ((PathfinderMob)this).f_19853_.m_46473_());
        return this.data().sundamageCache;
    }

    @Override
    default public boolean isIgnoringSundamage() {
        return ((PathfinderMob)this).m_21023_(ModEffects.sunscreen);
    }

    default public void aiStepC(EntityType<T> originalType) {
        PathfinderMob entity = (PathfinderMob)this;
        if (!entity.f_19853_.f_46443_ && entity.m_6084_() && this.isConverting(entity)) {
            --this.data().conversionTime;
            if (this.data().conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)entity, originalType, timer -> {
                this.data().conversionTime = timer;
            })) {
                this.cureEntity((ServerLevel)entity.f_19853_, entity, originalType);
            }
        }
        if (entity.f_19797_ % 40 == 1) {
            this.isGettingGarlicDamage((LevelAccessor)entity.f_19853_, true);
        }
        if (entity.f_19797_ % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)entity.f_19853_, true);
        }
        if (!entity.f_19853_.f_46443_) {
            double dmg;
            if (this.isGettingSundamage((LevelAccessor)entity.f_19853_) && entity.f_19797_ % 40 == 11 && (dmg = entity.m_21051_((Attribute)ModAttributes.sundamage).m_22135_()) > 0.0) {
                entity.m_6469_(VReference.SUNDAMAGE, (float)dmg);
            }
            if (this.isGettingGarlicDamage((LevelAccessor)entity.f_19853_) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)entity.f_19853_), entity.f_19797_);
            }
            if (entity.m_6084_() && entity.m_20069_()) {
                entity.m_20301_(300);
                if (entity.f_19797_ % 16 == 4) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, 0));
                }
            }
        }
    }

    default public void dieC(DamageSource cause) {
        if (cause.m_7640_() instanceof CrossbowArrowEntity && Helper.isHunter(cause.m_7639_())) {
            this.data().dropSoul = true;
        } else if (cause.m_7640_() instanceof Player && Helper.isHunter(cause.m_7640_())) {
            ItemStack weapon = ((Player)cause.m_7640_()).m_21205_();
            if (!weapon.m_41619_() && weapon.m_41720_() instanceof IVampireFinisher) {
                this.data().dropSoul = true;
            }
        } else {
            this.data().dropSoul = false;
        }
    }

    default public void readAdditionalSaveDataC(@Nonnull CompoundTag compound) {
        if (compound.m_128425_("ConversionTime", 99) && compound.m_128451_("ConversionTime") > -1) {
            this.startConverting(compound.m_128403_("ConversionPlayer") ? compound.m_128342_("ConversionPlayer") : null, compound.m_128451_("ConversionTime"), (PathfinderMob)this);
        }
    }

    default public void addAdditionalSaveDataC(@Nonnull CompoundTag compound) {
        compound.m_128405_("ConversionTime", this.isConverting((PathfinderMob)this) ? this.data().conversionTime : -1);
        if (this.data().conversationStarter != null) {
            compound.m_128362_("ConversionPlayer", this.data().conversationStarter);
        }
    }

    @Override
    default public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @Nonnull PathfinderMob entity) {
        ICurableConvertedCreature.super.startConverting(conversionStarterIn, conversionTimeIn, entity);
        this.data().conversationStarter = conversionStarterIn;
        this.data().conversionTime = conversionTimeIn;
    }

    @Override
    default public boolean useBlood(int amt, boolean allowPartial) {
        ((PathfinderMob)this).m_7292_(new MobEffectInstance(MobEffects.f_19613_, amt * 20));
        return true;
    }

    @Override
    default public boolean wantsBlood() {
        return false;
    }

    default public float calculateFireDamage(float amount) {
        return amount;
    }

    default public void tickDeathC() {
        PathfinderMob entity = (PathfinderMob)this;
        if (entity.f_20919_ == 19 && !entity.f_19853_.f_46443_ && this.data().dropSoul && entity.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            entity.f_19853_.m_7967_((Entity)new SoulOrbEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoulOrbEntity.VARIANT.VAMPIRE));
        }
    }

    default public void registerGoalsC() {
        PathfinderMob entity = (PathfinderMob)this;
        entity.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal(entity, PathfinderMob.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION)));
        entity.f_21345_.m_25352_(4, (Goal)new RestrictSunGoal(entity));
        entity.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(entity, new Class[0]));
        entity.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)entity, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        entity.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)entity, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, false, false, false, null)));
    }

    @Override
    default public LivingEntity getRepresentingEntity() {
        return (PathfinderMob)this;
    }

    public void handleEntityEventSuper(byte var1);

    public InteractionResult mobInteractSuper(@Nonnull Player var1, @Nonnull InteractionHand var2);

    public boolean hurtSuper(DamageSource var1, float var2);

    public static <T extends PathfinderMob, Z extends PathfinderMob> void createFrom() {
    }

    public static class Data<T> {
        public boolean vulnerableToFire = true;
        public EnumStrength garlicCache = EnumStrength.NONE;
        public T entityCreature;
        public boolean sundamageCache;
        public boolean dropSoul = false;
        @Nullable
        public Component name;
        public int conversionTime;
        public UUID conversationStarter;
    }
}

