/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.api.entity.convertible.ICurableConvertedCreature;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.VampirismVillagerEntity;
import de.teamlapen.vampirism.entity.villager.Trades;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.VillagerGoalPackages;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

public class ConvertedVillagerEntity
extends VampirismVillagerEntity
implements ICurableConvertedCreature<Villager> {
    public static final List<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES;
    private static final EntityDataAccessor<Boolean> CONVERTING;
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean sundamageCache;
    private int bloodTimer = 0;
    private int conversionTime;
    private UUID conversationStarter;

    public ConvertedVillagerEntity(EntityType<? extends ConvertedVillagerEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ConversionTime", this.isConverting((PathfinderMob)this) ? this.conversionTime : -1);
        if (this.conversationStarter != null) {
            compound.m_128362_("ConversionPlayer", this.conversationStarter);
        }
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.isConverting((PathfinderMob)this)) {
            --this.conversionTime;
            if (this.conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20492_, timer -> {
                this.conversionTime = timer;
            })) {
                this.cureEntity((ServerLevel)this.f_19853_, (PathfinderMob)this, (EntityType<Villager>)EntityType.f_20492_);
            }
        }
        if (this.f_19797_ % 40 == 1) {
            this.isGettingGarlicDamage((LevelAccessor)this.f_19853_, true);
        }
        if (this.f_19797_ % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)this.f_19853_, true);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.isGettingSundamage((LevelAccessor)this.f_19853_) && this.f_19797_ % 40 == 11) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 42));
            }
            if (this.isGettingGarlicDamage((LevelAccessor)this.f_19853_) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)this.f_19853_), this.f_19797_);
            }
        }
        ++this.bloodTimer;
        super.m_8107_();
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public Villager cureEntity(ServerLevel world, PathfinderMob entity, EntityType<Villager> newType) {
        Player playerentity;
        Villager villager = ICurableConvertedCreature.super.cureEntity(world, entity, newType);
        villager.m_141967_(this.m_7141_());
        villager.m_35455_((Tag)this.m_35517_().m_26179_((DynamicOps)NbtOps.f_128958_).getValue());
        villager.m_35476_(this.m_6616_());
        villager.m_35546_(this.m_7809_());
        if (this.conversationStarter != null && (playerentity = world.m_46003_(this.conversationStarter)) instanceof ServerPlayer) {
            ModAdvancements.TRIGGER_CURED_VAMPIRE_VILLAGER.trigger((ServerPlayer)playerentity, (Entity)this, villager);
            world.m_8670_(ReputationEventType.f_26985_, (Entity)playerentity, (ReputationEventHandler)villager);
        }
        return villager;
    }

    @Override
    public boolean m_7327_(@Nonnull Entity entity) {
        if (!this.f_19853_.f_46443_ && this.wantsBlood() && entity instanceof Player && !Helper.isHunter(entity) && !UtilLib.canReallySee((LivingEntity)entity, (LivingEntity)this, true)) {
            int amt = VampirePlayer.getOpt((Player)entity).map(vampire -> vampire.onBite(this)).orElse(0);
            this.drinkBlood(amt, 0.7f);
            return true;
        }
        return super.m_7327_(entity);
    }

    @Override
    public EntityDataAccessor<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, amt * 20));
        this.bloodTimer = -1200 - this.f_19796_.nextInt(1200);
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    protected Component m_5677_() {
        ResourceLocation profName = this.m_7141_().m_35571_().getRegistryName();
        return new TranslatableComponent(EntityType.f_20492_.m_20675_() + "." + (String)(!"minecraft".equals(profName.m_135827_()) ? profName.m_135827_() + "." : "") + profName.m_135815_());
    }

    public void m_7822_(byte id) {
        if (!this.handleSound(id, (PathfinderMob)this)) {
            super.m_7822_(id);
        }
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.f_19853_.m_46473_());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @Nonnull
    public InteractionResult m_6071_(Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() != ModItems.cure_apple) {
            return super.m_6071_(player, hand);
        }
        return this.interactWithCureItem(player, stack, (PathfinderMob)this);
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("ConversionTime", 99) && compound.m_128451_("ConversionTime") > -1) {
            this.startConverting(compound.m_128403_("ConversionPlayer") ? compound.m_128342_("ConversionPlayer") : null, compound.m_128451_("ConversionTime"), (PathfinderMob)this);
        }
    }

    @Override
    public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @Nonnull PathfinderMob entity) {
        ICurableConvertedCreature.super.startConverting(conversionStarterIn, conversionTimeIn, entity);
        this.conversationStarter = conversionStarterIn;
        this.conversionTime = conversionTimeIn;
    }

    public void m_35424_(@Nonnull Brain<Villager> brain) {
        VillagerProfession villagerprofession = this.m_7141_().m_35571_();
        float f = (float)this.m_21051_(Attributes.f_22279_).m_22135_();
        if (this.m_6162_()) {
            brain.m_21912_(Schedule.f_38014_);
            brain.m_21900_(Activity.f_37981_, VillagerGoalPackages.m_24583_((float)f));
        } else {
            brain.m_21912_(ModVillage.converted_default);
            brain.m_21903_(Activity.f_37980_, VillagerGoalPackages.m_24589_((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26360_, (Object)MemoryStatus.VALUE_PRESENT)));
        }
        brain.m_21900_(Activity.f_37978_, VillagerGoalPackages.m_24585_((VillagerProfession)villagerprofession, (float)f));
        brain.m_21903_(Activity.f_37983_, VillagerGoalPackages.m_24595_((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26362_, (Object)MemoryStatus.VALUE_PRESENT)));
        brain.m_21900_(Activity.f_37982_, VillagerGoalPackages.m_24592_((VillagerProfession)villagerprofession, (float)f));
        brain.m_21900_(Activity.f_37979_, VillagerGoalPackages.m_24598_((VillagerProfession)villagerprofession, (float)f));
        brain.m_21900_(Activity.f_37984_, VillagerGoalPackages.m_24601_((VillagerProfession)villagerprofession, (float)f));
        brain.m_21900_(Activity.f_37986_, VillagerGoalPackages.m_24604_((VillagerProfession)villagerprofession, (float)f));
        brain.m_21900_(Activity.f_37985_, VillagerGoalPackages.m_24607_((VillagerProfession)villagerprofession, (float)f));
        brain.m_21900_(Activity.f_37987_, VillagerGoalPackages.m_24610_((VillagerProfession)villagerprofession, (float)f));
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21889_(Activity.f_37979_);
        brain.m_21862_(this.f_19853_.m_46468_(), this.f_19853_.m_46467_());
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodTimer > 0;
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, amt * 20));
        this.bloodTimer = 0;
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerConvertingData((PathfinderMob)this);
    }

    @Nonnull
    protected Brain<?> m_8075_(@Nonnull Dynamic<?> dynamicIn) {
        Brain brain = Brain.m_21923_((Collection)f_35367_, SENSOR_TYPES).m_22073_(dynamicIn);
        this.m_35424_((Brain<Villager>)brain);
        return brain;
    }

    protected void m_7604_() {
        super.m_7604_();
        if (!this.m_6616_().isEmpty() && this.m_21187_().nextInt(3) == 0) {
            this.m_35277_(this.m_6616_(), Trades.converted_trades, 1);
        }
    }

    static {
        CONVERTING = SynchedEntityData.m_135353_(ConvertedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SENSOR_TYPES = Lists.newArrayList((Iterable)Villager.f_35368_);
        SENSOR_TYPES.remove(SensorType.f_26815_);
        SENSOR_TYPES.add(ModVillage.vampire_villager_hostiles);
    }

    public static class ConvertingHandler
    implements IConvertingHandler<Villager> {
        @Override
        public IConvertedCreature<Villager> createFrom(Villager entity) {
            CompoundTag nbt = new CompoundTag();
            entity.m_20240_(nbt);
            ConvertedVillagerEntity converted = (ConvertedVillagerEntity)ModEntities.villager_converted.m_20615_(entity.f_19853_);
            converted.m_20258_(nbt);
            converted.m_20084_(Mth.m_14062_((Random)converted.f_19796_));
            converted.f_20883_ = entity.f_20883_;
            converted.f_20885_ = entity.f_20885_;
            return converted;
        }
    }
}

