/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.action.vampire;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.action.vampire.VampireEntityAction;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class SpeedEntityAction<T extends PathfinderMob>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public static final UUID UUIDS = UUID.fromString("2b49cf70-b634-4e85-8c3e-0147919eaf54");

    public SpeedEntityAction(EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public void activate(T entity) {
    }

    @Override
    public void deactivate(T entity) {
        ((IFactionEntity)entity).getRepresentingEntity().m_21051_(Attributes.f_22279_).m_22120_(UUIDS);
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaSpeedCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.eaSpeedDuration.get() * 20;
    }

    @Override
    public int getWeight(PathfinderMob entity) {
        if (entity.m_5448_() == null) {
            return 0;
        }
        double distanceToTarget = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()).m_82492_(entity.m_5448_().m_20185_(), entity.m_5448_().m_20186_(), entity.m_5448_().m_20189_()).m_82553_();
        if (distanceToTarget > 10.0) {
            return 3;
        }
        if (distanceToTarget > 5.0) {
            return 2;
        }
        return 1;
    }

    @Override
    public void onUpdate(T entity, int duration) {
        if (((IFactionEntity)entity).getRepresentingEntity().m_21051_(Attributes.f_22279_).m_22111_(UUIDS) == null) {
            ((IFactionEntity)entity).getRepresentingEntity().m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier(UUIDS, "speedaction", ((Double)VampirismConfig.BALANCE.eaSpeedAmount.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (duration % 5 == 0) {
            double maxDist = 0.5;
            ModParticles.spawnParticlesServer(entity.m_20193_(), (ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_() + entity.m_21187_().nextDouble() * maxDist - maxDist / 2.0, entity.m_20186_() + 0.1, entity.m_20189_() + entity.m_21187_().nextDouble() * maxDist - maxDist / 2.0, 3, 0.3f, 0.3f, 0.3f, 0.02f);
        }
    }
}

