/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.action;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.actions.EntityActionEntry;
import de.teamlapen.vampirism.api.entity.actions.IActionHandlerEntity;
import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.actions.IInstantAction;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;

public class ActionHandlerEntity<T extends PathfinderMob>
implements IActionHandlerEntity {
    private final T entity;
    private final List<IEntityAction> availableActions;
    private int preActivation = 0;
    private int cooldown = 0;
    private int duration = 0;
    private float minimumHealthThreshold;
    @Nullable
    private IEntityAction action;
    private boolean isPlayerTarget;

    public ActionHandlerEntity(T entityIn) {
        this.entity = entityIn;
        this.availableActions = ((IEntityActionUser)entityIn).getAvailableActions();
    }

    @Override
    public void deactivateAction() {
        this.deactivateAction(null);
    }

    @Nullable
    public IEntityAction getAction() {
        return this.action;
    }

    public void handle() {
        if (!((PathfinderMob)this.entity).f_19853_.f_46443_ && this.availableActions != null && !this.availableActions.isEmpty()) {
            if (this.entity.m_5448_() instanceof Player) {
                if (this.isPlayerTarget) {
                    this.updateHandler();
                } else {
                    this.startExecuting();
                    this.isPlayerTarget = true;
                }
            } else if (this.isPlayerTarget) {
                this.isPlayerTarget = false;
                this.deactivateAction();
            }
        }
    }

    @Override
    public boolean isActionActive(IEntityAction action) {
        return this.action != null && this.action.equals(action) && this.duration > 0;
    }

    public boolean isPlayerTarget() {
        return this.isPlayerTarget;
    }

    public void read(CompoundTag nbt) {
        if (nbt.m_128441_("activeAction")) {
            this.deactivateAction((IEntityAction)ModRegistries.ENTITYACTIONS.getValue(new ResourceLocation(nbt.m_128461_("activeAction"))));
            this.isPlayerTarget = true;
        }
    }

    public void startExecuting() {
        this.action = null;
        this.cooldown = 50;
        this.duration = -1;
        this.preActivation = -1;
    }

    public void write(CompoundTag nbt) {
        if (this.isPlayerTarget() && this.action != null) {
            nbt.m_128359_("activeAction", this.action.getRegistryName().toString());
        }
    }

    private void activateAction() {
        if (this.action instanceof ILastingAction) {
            ((ILastingAction)this.action).activate(this.entity);
        } else if (this.action instanceof IInstantAction) {
            ((IInstantAction)this.action).activate(this.entity);
        }
    }

    private void cancelActivation() {
        this.preActivation = -1;
        this.duration = -1;
        this.cooldown = 100;
    }

    @Nullable
    private IEntityAction chooseNewAction() {
        ArrayList entry = Lists.newArrayList();
        int weightsum = 0;
        for (IEntityAction e : this.availableActions) {
            int weight = e.getWeight((PathfinderMob)this.entity);
            if (weight <= 0) continue;
            entry.add(new EntityActionEntry(weight, e));
            weightsum += weight;
        }
        if (weightsum > 0) {
            return WeightedRandom.m_146320_((Random)this.entity.m_21187_(), (List)entry, (int)weightsum).map(EntityActionEntry::getAction).orElse(null);
        }
        return null;
    }

    private void deactivateAction(@Nullable IEntityAction actionIn) {
        IEntityAction action;
        IEntityAction iEntityAction = action = actionIn != null ? actionIn : this.action;
        if (action instanceof ILastingAction) {
            ((ILastingAction)action).deactivate(this.entity);
        }
    }

    private void updateAction() {
        if (this.action instanceof ILastingAction) {
            ((ILastingAction)this.action).onUpdate(this.entity, this.duration);
        }
    }

    private void updateHandler() {
        if (this.preActivation == 0) {
            this.activateAction();
            --this.preActivation;
        } else if (this.preActivation > 0) {
            this.updatePreAction();
            --this.preActivation;
            if (this.entity.m_21223_() < this.minimumHealthThreshold) {
                this.cancelActivation();
            }
        } else if (this.duration == 0) {
            this.deactivateAction();
            --this.duration;
        } else if (this.duration > 0) {
            --this.duration;
            this.updateAction();
        } else if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            this.action = this.chooseNewAction();
            if (this.action == null) {
                this.cancelActivation();
                return;
            }
            this.cooldown = this.action.getCooldown(((IAdjustableLevel)this.entity).getEntityLevel());
            this.preActivation = this.action.getPreActivationTime();
            this.minimumHealthThreshold = (float)((double)this.entity.m_21223_() - (double)this.entity.m_21233_() * (Double)VampirismConfig.BALANCE.eaHealthThreshold.get());
            if (this.action instanceof ILastingAction) {
                this.duration = ((ILastingAction)this.action).getDuration(((IAdjustableLevel)this.entity).getEntityLevel());
            }
        }
    }

    private void updatePreAction() {
        if (this.action instanceof ILastingAction) {
            ((ILastingAction)this.action).updatePreAction(this.entity, this.preActivation);
        } else if (this.action instanceof IInstantAction) {
            ((IInstantAction)this.action).updatePreAction(this.entity, this.preActivation);
        }
    }
}

