/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.IEntityWithHome;
import de.teamlapen.vampirism.api.entity.IVampirismEntity;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.particle.GenericParticleData;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class VampirismEntity
extends PathfinderMob
implements IEntityWithHome,
IVampirismEntity {
    private final Goal moveTowardsRestriction = new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0);
    protected boolean hasArms = true;
    protected boolean peaceful = false;
    protected boolean saveHome = false;
    @Nullable
    private AABB home;
    private boolean moveTowardsRestrictionAdded = false;
    private int moveTowardsRestrictionPrio = -1;
    private int randomTickDivider;
    private boolean doImobConversion = false;

    public static boolean spawnPredicateVampireFog(LevelAccessor world, BlockPos blockPos) {
        return world.m_204166_(blockPos).m_203656_(ModTags.Biomes.IS_VAMPIRE_BIOME) || world instanceof Level && VampirismWorld.getOpt((Level)world).map(vh -> vh.isInsideArtificialVampireFogArea(blockPos)).orElse(false) != false;
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return PathfinderMob.m_21183_().m_22266_(Attributes.f_22281_).m_22268_(Attributes.f_22277_, 16.0).m_22266_(Attributes.f_22282_);
    }

    public VampirismEntity(EntityType<? extends VampirismEntity> type, Level world) {
        super(type, world);
    }

    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.saveHome && this.home != null) {
            int[] h = new int[]{(int)this.home.f_82288_, (int)this.home.f_82289_, (int)this.home.f_82290_, (int)this.home.f_82291_, (int)this.home.f_82292_, (int)this.home.f_82293_};
            nbt.m_128385_("home", h);
            if (this.moveTowardsRestrictionAdded && this.moveTowardsRestrictionPrio > -1) {
                nbt.m_128405_("homeMovePrio", this.moveTowardsRestrictionPrio);
            }
        }
    }

    @Override
    @Nullable
    public AABB getHome() {
        return this.home;
    }

    public void m_8107_() {
        if (this.hasArms) {
            this.m_21203_();
        }
        super.m_8107_();
    }

    public boolean m_5545_(@Nonnull LevelAccessor worldIn, @Nonnull MobSpawnType spawnReasonIn) {
        return (this.peaceful || worldIn.m_46791_() != Difficulty.PEACEFUL) && super.m_5545_(worldIn, spawnReasonIn);
    }

    @Override
    public boolean isWithinHomeDistance(double x, double y, double z) {
        if (this.home != null) {
            return this.home.m_82390_(new Vec3(x, y, z));
        }
        return true;
    }

    @Override
    public BlockPos getHomePosition() {
        return this.m_21534_();
    }

    public boolean m_21533_() {
        return this.isWithinHomeDistance(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public boolean m_21444_(@Nonnull BlockPos pos) {
        return this.isWithinHomeDistance(pos);
    }

    public void m_7378_(@Nonnull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("home")) {
            this.saveHome = true;
            int[] h = nbt.m_128465_("home");
            this.setHome(new AABB((double)h[0], (double)h[1], (double)h[2], (double)h[3], (double)h[4], (double)h[5]));
            if (nbt.m_128441_("homeMovePrio")) {
                this.setMoveTowardsRestriction(nbt.m_128451_("moveHomePrio"), true);
            }
        }
    }

    public void m_21446_(@Nonnull BlockPos pos, int distance) {
        this.setHomeArea(pos, distance);
    }

    @Override
    public void setHome(@Nullable AABB home) {
        this.home = home;
        if (home != null) {
            int posX = (int)(home.f_82288_ + (home.f_82291_ - home.f_82288_) / 2.0);
            int posY = (int)(home.f_82289_ + (home.f_82292_ - home.f_82289_) / 2.0);
            int posZ = (int)(home.f_82290_ + (home.f_82293_ - home.f_82290_) / 2.0);
            super.m_21446_(new BlockPos(posX, posY, posZ), (int)home.m_82309_());
        } else {
            super.m_21446_(new BlockPos(0, 0, 0), -1);
        }
    }

    @Override
    public void setHomeArea(BlockPos pos, int r) {
        this.setHome(new AABB(pos.m_142082_(-r, -r, -r), pos.m_142082_(r, r, r)));
    }

    public void m_8119_() {
        super.m_8119_();
        this.checkImobConversion();
        if (!this.f_19853_.f_46443_ && !this.peaceful && this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (--this.randomTickDivider <= 0) {
            this.randomTickDivider = 70 + this.f_19796_.nextInt(50);
            this.onRandomTick();
        }
    }

    protected void disableImobConversion() {
        this.doImobConversion = false;
    }

    protected void disableMoveTowardsRestriction() {
        if (this.moveTowardsRestrictionAdded) {
            this.f_21345_.m_25363_(this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = false;
        }
    }

    protected void enableImobConversion() {
        if (!(this instanceof IFactionEntity)) {
            throw new IllegalStateException("Can only do IMob conversion for IFactionEntity");
        }
        this.doImobConversion = true;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12038_;
    }

    @Nonnull
    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_12040_, SoundEvents.f_12037_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12039_;
    }

    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return this.m_6095_();
    }

    @Nonnull
    protected SoundEvent m_5501_() {
        return SoundEvents.f_12042_;
    }

    @Nonnull
    protected SoundEvent m_5509_() {
        return SoundEvents.f_12041_;
    }

    protected boolean isLowLightLevel(LevelAccessor iWorld) {
        BlockPos blockpos = new BlockPos(this.m_20185_(), this.m_142469_().f_82289_, this.m_20189_());
        if (iWorld.m_45517_(LightLayer.SKY, blockpos) > this.f_19796_.nextInt(32)) {
            return false;
        }
        if (iWorld.m_45517_(LightLayer.BLOCK, blockpos) > 0) {
            return false;
        }
        int i = iWorld.m_46803_(blockpos);
        if (iWorld instanceof Level && ((Level)iWorld).m_46470_()) {
            i = iWorld.m_46803_(blockpos);
        }
        return i <= this.f_19796_.nextInt(8);
    }

    protected void onRandomTick() {
    }

    protected void setDontDropEquipment() {
        Arrays.fill(this.f_21348_, 0.0f);
        Arrays.fill(this.f_21347_, 0.0f);
    }

    protected void setMoveTowardsRestriction(int prio, boolean active) {
        if (this.moveTowardsRestrictionAdded) {
            if (active && this.moveTowardsRestrictionPrio == prio) {
                return;
            }
            this.f_21345_.m_25363_(this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = false;
        }
        if (active) {
            this.f_21345_.m_25352_(prio, this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = true;
            this.moveTowardsRestrictionPrio = prio;
        }
    }

    protected boolean m_6149_() {
        return true;
    }

    protected void teleportAway() {
        this.m_6842_(true);
        ModParticles.spawnParticlesServer(this.f_19853_, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "effect_6"), 10, 657930, 0.6f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 1.0, 1.0, 1.0, 0.0);
        this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        this.m_146870_();
    }

    private void checkImobConversion() {
        if (this.doImobConversion && !this.f_19853_.f_46443_ && this.f_19797_ % 256 == 0 && this.m_6084_()) {
            boolean current = this instanceof Enemy;
            boolean convert = false;
            VampirismConfig.Server.IMobOptions opt = (VampirismConfig.Server.IMobOptions)((Object)VampirismConfig.SERVER.entityIMob.get());
            if (ServerLifecycleHooks.getCurrentServer().m_6982_()) {
                convert = opt == VampirismConfig.Server.IMobOptions.ALWAYS_IMOB != current;
            } else if (opt == VampirismConfig.Server.IMobOptions.SMART) {
                Player player = VampirismMod.proxy.getClientPlayer();
                if (player != null && player.m_6084_()) {
                    IPlayableFaction<?> f = VampirismPlayerAttributes.get((Player)player).faction;
                    IFaction<?> thisFaction = ((IFactionEntity)((Object)this)).getFaction();
                    boolean hostile = f == null ? thisFaction.isHostileTowardsNeutral() : !thisFaction.equals(f);
                    convert = hostile != current;
                }
            } else {
                boolean bl = convert = opt == VampirismConfig.Server.IMobOptions.ALWAYS_IMOB != current;
            }
            if (convert) {
                EntityType<?> t = this.getIMobTypeOpt(!current);
                Helper.createEntity(t, this.f_19853_).ifPresent(newEntity -> {
                    CompoundTag nbt = new CompoundTag();
                    this.m_20240_(nbt);
                    newEntity.m_20258_(nbt);
                    newEntity.m_20084_(Mth.m_14062_((Random)this.f_19796_));
                    assert (newEntity instanceof LivingEntity);
                    UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)newEntity);
                });
            }
        }
    }

    public boolean m_6573_(@Nonnull Player player) {
        return false;
    }
}

