/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.core.ModEntities;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class ThrowableItemEntity
extends ThrowableProjectile
implements ItemSupplier {
    private static final Logger LOGGER = LogManager.getLogger(ThrowableItemEntity.class);
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(ThrowableItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public ThrowableItemEntity(Level worldIn, LivingEntity thrower) {
        super(ModEntities.throwable_item, thrower, worldIn);
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        ItemStack stack = this.m_7846_();
        if (!stack.m_41619_()) {
            compound.m_128365_("thrownItem", (Tag)stack.m_41739_(new CompoundTag()));
        }
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nonnull
    public ItemStack m_7846_() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM);
    }

    public void setItem(@Nonnull ItemStack stack) {
        if (!stack.m_41619_() && !(stack.m_41720_() instanceof IVampirismThrowableItem)) {
            throw new IllegalArgumentException("EntityThrowable only accepts IVampirismThrowableItem, but not " + stack);
        }
        this.m_20088_().m_135381_(ITEM, (Object)stack);
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        ItemStack stack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("thrownItem"));
        if (stack.m_41619_()) {
            this.m_146870_();
        } else {
            this.setItem(stack);
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ITEM, (Object)ItemStack.f_41583_);
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_6532_(@Nonnull HitResult result) {
        ItemStack stack = this.m_7846_();
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            if (item instanceof IVampirismThrowableItem) {
                ((IVampirismThrowableItem)item).onImpact(this, stack, result, this.f_19853_.f_46443_);
            } else {
                LOGGER.warn("Saved item ({}) is not an instance of IVampirismThrowableItem. This should not be able to happen", (Object)stack);
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.m_146870_();
        }
    }

    public static interface IVampirismThrowableItem {
        public void onImpact(ThrowableItemEntity var1, ItemStack var2, HitResult var3, boolean var4);
    }
}

