/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.actions.IActionHandlerEntity;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.action.EntityActions;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;

public class DamageHandler {
    public static void affectVampireGarlicSplash(IVampire vampire, EnumStrength strength, double distSq, boolean directHit) {
        if (vampire.doesResistGarlic(strength)) {
            return;
        }
        if (distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            DamageHandler.affectVampireGarlic(vampire, strength, (float)(10.0 * affect), false);
        }
    }

    public static void affectVampireGarlicDirect(IVampire vampire, EnumStrength strength) {
        DamageHandler.affectVampireGarlic(vampire, strength, 20.0f, false);
    }

    private static void affectVampireGarlic(IVampire vampire, EnumStrength strength, float multiplier, boolean ambient) {
        IActionHandler<IVampirePlayer> actionHandler;
        if (strength == EnumStrength.NONE) {
            return;
        }
        LivingEntity entity = vampire.getRepresentingEntity();
        entity.m_7292_(new MobEffectInstance(ModEffects.garlic, (int)(multiplier * 20.0f), strength.getStrength() - 1, ambient, true));
        if (entity instanceof Player && ((Player)entity).m_150110_().f_35937_) {
            return;
        }
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, (int)(multiplier * 20.0f), 1, ambient, false));
        if (strength == EnumStrength.MEDIUM || strength == EnumStrength.STRONG) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)(multiplier * 20.0f), 1, ambient, false));
            if (strength == EnumStrength.STRONG) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, (int)(multiplier / 2.0f * 20.0f), 0, ambient, false));
            }
        }
        if (vampire instanceof IVampirePlayer && (actionHandler = ((IVampirePlayer)vampire).getActionHandler()).isActionActive(VampireActions.disguise_vampire)) {
            actionHandler.toggleAction(VampireActions.disguise_vampire);
        }
    }

    public static void affectVampireGarlicAmbient(IVampire vampire, EnumStrength strength, int ticks) {
        if (ticks % 37 == 7) {
            DamageHandler.affectVampireGarlic(vampire, strength, 5.0f, true);
        }
    }

    public static void affectEntityHolyWaterSplash(LivingEntity entity, EnumStrength strength, double distSq, boolean directHit) {
        DamageHandler.affectEntityHolyWaterSplash(entity, strength, distSq, directHit, null);
    }

    public static void affectEntityHolyWaterSplash(LivingEntity entity, EnumStrength strength, double distSq, boolean directHit, @Nullable LivingEntity source) {
        IActionHandlerEntity h;
        if (!entity.m_6084_()) {
            return;
        }
        boolean vampire = Helper.isVampire((Entity)entity);
        if (entity.m_5801_() && (vampire || MobType.f_21641_.equals(entity.m_6336_())) && distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            if (!vampire) {
                affect *= 0.5;
            }
            double amount = affect * ((double)((Integer)VampirismConfig.BALANCE.holyWaterSplashDamage.get()).intValue() * (strength == EnumStrength.WEAK ? 1.0 : (strength == EnumStrength.MEDIUM ? (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() : (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() * (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get()))) + 0.5;
            if (entity instanceof Player) {
                int l = VampirismPlayerAttributes.get((Player)((Player)entity)).vampireLevel;
                amount = DamageHandler.scaleDamageWithLevel(l, 14, amount * 0.8, amount * 1.3);
            } else if (entity instanceof VampireBaronEntity) {
                int l = ((VampireBaronEntity)entity).getEntityLevel();
                amount = DamageHandler.scaleDamageWithLevel(l, 4, amount * 0.8, amount * 2.0);
            }
            entity.m_6469_(VReference.HOLY_WATER, (float)amount);
        }
        if (vampire && entity instanceof Player) {
            VampirePlayer.getOpt((Player)entity).map(VampirePlayer::getActionHandler).ifPresent(actionHandler -> {
                if (actionHandler.isActionActive(VampireActions.disguise_vampire)) {
                    actionHandler.toggleAction(VampireActions.disguise_vampire);
                }
                if (actionHandler.isActionActive(VampireActions.vampire_invisibility)) {
                    actionHandler.toggleAction(VampireActions.vampire_invisibility);
                }
            });
        } else if (vampire && entity instanceof IEntityActionUser && (h = ((IEntityActionUser)entity).getActionHandler()).isActionActive(EntityActions.entity_invisible)) {
            h.deactivateAction();
        }
        if (vampire) {
            if (strength.isStrongerThan(EnumStrength.WEAK)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, ((Integer)VampirismConfig.BALANCE.holyWaterNauseaDuration.get()).intValue(), 2));
            }
            if (strength.isStrongerThan(EnumStrength.MEDIUM)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, ((Integer)VampirismConfig.BALANCE.holyWaterBlindnessDuration.get()).intValue(), 1));
            }
        }
    }

    private static double scaleDamageWithLevel(int level, int maxLevel, double minDamage, double maxDamage) {
        return minDamage + (double)level / (double)maxLevel * (maxDamage - minDamage);
    }
}

