/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class CrossbowArrowEntity
extends AbstractArrow
implements IEntityCrossbowArrow {
    @Nonnull
    private ItemStack arrowStack = new ItemStack((ItemLike)ModItems.crossbow_arrow_normal);
    private boolean ignoreHurtTimer = false;

    public static CrossbowArrowEntity createWithShooter(Level world, LivingEntity shooter, double heightOffset, double centerOffset, boolean rightHanded, ItemStack arrow) {
        double yaw = (double)((shooter.m_146908_() - 90.0f) / 180.0f) * Math.PI;
        if (rightHanded) {
            yaw += Math.PI;
        }
        double posX = shooter.m_20185_() - Math.sin(yaw) * centerOffset;
        double posZ = shooter.m_20189_() + Math.cos(yaw) * centerOffset;
        CrossbowArrowEntity entityArrow = new CrossbowArrowEntity(world, posX, shooter.m_20186_() + (double)shooter.m_20192_() - (double)0.1f + heightOffset, posZ, arrow);
        entityArrow.m_5602_((Entity)shooter);
        return entityArrow;
    }

    public CrossbowArrowEntity(EntityType<? extends CrossbowArrowEntity> type, Level world) {
        super(type, world);
    }

    public CrossbowArrowEntity(Level worldIn, double x, double y, double z, ItemStack arrow) {
        this(ModEntities.crossbow_arrow, worldIn);
        this.m_6034_(x, y, z);
        this.arrowStack = arrow.m_41777_();
        this.arrowStack.m_41764_(1);
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("arrowStack", (Tag)this.arrowStack.m_41739_(new CompoundTag()));
    }

    public CrossbowArrowItem.EnumArrowType getArrowType() {
        return this.arrowStack.m_41720_() instanceof CrossbowArrowItem ? ((CrossbowArrowItem)this.arrowStack.m_41720_()).getType() : CrossbowArrowItem.EnumArrowType.NORMAL;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Random getRNG() {
        return this.f_19796_;
    }

    @Override
    public void setIgnoreHurtTimer() {
        this.ignoreHurtTimer = true;
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.arrowStack.deserializeNBT(compound.m_128469_("arrowStack"));
    }

    protected void m_7761_(@Nonnull LivingEntity living) {
        super.m_7761_(living);
        Item item = this.arrowStack.m_41720_();
        if (item instanceof IVampirismCrossbowArrow) {
            if (this.ignoreHurtTimer && living.f_19802_ > 0) {
                living.f_19802_ = 0;
            }
            ((IVampirismCrossbowArrow)item).onHitEntity(this.arrowStack, living, this, this.m_37282_());
        }
    }

    @Nonnull
    protected ItemStack m_7941_() {
        return this.arrowStack;
    }

    protected void m_8060_(@Nonnull BlockHitResult blockRayTraceResult) {
        Item item = this.arrowStack.m_41720_();
        if (item instanceof IVampirismCrossbowArrow) {
            ((IVampirismCrossbowArrow)item).onHitBlock(this.arrowStack, blockRayTraceResult.m_82425_(), this, this.m_37282_());
        }
        super.m_8060_(blockRayTraceResult);
    }
}

