/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.SanguinareEffectInstance;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.EffectRenderer;

public class SanguinareEffect
extends VampirismEffect {
    public static void addRandom(LivingEntity entity, boolean player) {
        int avgDuration = 20 * (player ? (Integer)VampirismConfig.BALANCE.vpSanguinareAverageDuration.get() : BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION);
        int duration = (int)((entity.m_21187_().nextFloat() + 0.5f) * (float)avgDuration);
        SanguinareEffectInstance effect = new SanguinareEffectInstance(duration);
        Preconditions.checkNotNull((Object)((Object)effect));
        if (!((Boolean)VampirismConfig.BALANCE.canCancelSanguinare.get()).booleanValue()) {
            effect.setCurativeItems(new ArrayList());
        }
        entity.m_7292_((MobEffectInstance)effect);
    }

    public SanguinareEffect(String name, MobEffectCategory effectType, int potionColor) {
        super(name, effectType, potionColor);
        this.m_19472_(Attributes.f_22281_, "22663B89-116E-49DC-9B6B-9971489B5BE5", 2.0, AttributeModifier.Operation.ADDITION);
    }

    @Override
    public List<ItemStack> getCurativeItems() {
        List<ItemStack> l = super.getCurativeItems();
        l.add(new ItemStack((ItemLike)ModItems.garlic_bread));
        return l;
    }

    @Override
    public void m_6742_(@Nonnull LivingEntity entity, int amplifier) {
        if (entity.f_19853_.f_46443_ || !entity.m_6084_()) {
            return;
        }
        if (entity instanceof PathfinderMob) {
            ExtendedCreature.getSafe((Entity)entity).ifPresent(IExtendedCreatureVampirism::makeVampire);
        }
        if (entity instanceof Player) {
            VampirePlayer.getOpt((Player)entity).ifPresent(VampirePlayer::onSanguinareFinished);
        }
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        return duration == 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<EffectRenderer> consumer) {
        consumer.accept(new EffectRenderer(){

            @OnlyIn(value=Dist.CLIENT)
            public void renderInventoryEffect(MobEffectInstance effect, EffectRenderingInventoryScreen<?> gui, PoseStack mStack, int x, int y, float z) {
                String s = UtilLib.translate(effect.m_19544_().m_19481_(), new Object[0]);
                gui.f_96547_.m_92750_(mStack, s, (float)(x + 10 + 18), (float)(y + 6), 0xFFFFFF);
            }

            public void renderHUDEffect(MobEffectInstance effect, GuiComponent gui, PoseStack mStack, int x, int y, float z, float alpha) {
            }

            @OnlyIn(value=Dist.CLIENT)
            public boolean shouldRenderInvText(MobEffectInstance effect) {
                return false;
            }
        });
    }
}

