/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.blockentity.TotemHelper;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class BadOmenEffect
extends MobEffect {
    public static void handlePotentialBannerKill(@Nullable Entity offender, IFactionEntity victim) {
        if (offender instanceof Player) {
            MobEffect badOmen;
            IPlayableFaction<?> playerFaction;
            Player player = (Player)offender;
            IFaction<?> faction = victim.getFaction();
            if (faction.getVillageData().isBanner(victim.getRepresentingEntity().m_6844_(EquipmentSlot.HEAD)) && (playerFaction = VampirismPlayerAttributes.get((Player)player).faction) != null && playerFaction != faction && (badOmen = faction.getVillageData().getBadOmenEffect()) != null) {
                int i;
                MobEffectInstance inst = player.m_21124_(badOmen);
                int n = i = inst != null ? Math.min(inst.m_19564_() + 1, 4) : 0;
                if (inst != null) {
                    player.m_6234_(badOmen);
                }
                player.m_7292_(new MobEffectInstance(badOmen, 120000, i, false, false, true));
            }
        }
    }

    public BadOmenEffect(String modID, ResourceLocation faction) {
        super(MobEffectCategory.NEUTRAL, 745784);
        this.setRegistryName(modID, "bad_omen_" + faction.m_135815_());
    }

    public abstract IFaction<?> getFaction();

    public void m_6742_(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        if (entityLivingBaseIn instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)entityLivingBaseIn;
            if (!entityLivingBaseIn.m_5833_()) {
                ServerLevel serverWorld = playerEntity.m_183503_();
                if (serverWorld.m_46791_() == Difficulty.PEACEFUL) {
                    return;
                }
                TotemHelper.getTotemNearPos(serverWorld, entityLivingBaseIn.m_142538_(), true).ifPresent(totem -> {
                    if (totem.getControllingFaction() != this.getFaction()) {
                        int level = Math.min(amplifier, 4);
                        if (totem.initiateCaptureOrIncreaseBadOmenLevel(this.getFaction(), null, level + 1, 0.0f)) {
                            entityLivingBaseIn.m_21195_((MobEffect)this);
                        }
                    }
                });
            }
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

