/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.advancements.SkillUnlockedTrigger;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
public class ShapelessWeaponTableRecipeBuilder
extends ShapelessRecipeBuilder {
    private int lava = 1;
    private ISkill<?>[] skills;
    private int level = 1;

    public static ShapelessWeaponTableRecipeBuilder shapelessWeaponTable(ItemLike result, int count) {
        return new ShapelessWeaponTableRecipeBuilder(result, count);
    }

    public static ShapelessWeaponTableRecipeBuilder shapelessWeaponTable(ItemLike result) {
        return new ShapelessWeaponTableRecipeBuilder(result, 1);
    }

    public ShapelessWeaponTableRecipeBuilder(ItemLike resultIn, int countIn) {
        super(resultIn, countIn);
    }

    @Nonnull
    public ShapelessWeaponTableRecipeBuilder group(@Nullable String groupIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_142409_(groupIn);
    }

    @Nonnull
    public ShapelessWeaponTableRecipeBuilder requires(ItemLike itemIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_126209_(itemIn);
    }

    @Nonnull
    public ShapelessWeaponTableRecipeBuilder requires(ItemLike itemIn, int quantity) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_126211_(itemIn, quantity);
    }

    @Nonnull
    public ShapelessWeaponTableRecipeBuilder requires(Ingredient ingredientIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_126184_(ingredientIn);
    }

    @Nonnull
    public ShapelessWeaponTableRecipeBuilder requires(Ingredient ingredientIn, int quantity) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_126186_(ingredientIn, quantity);
    }

    @Nonnull
    public ShapelessWeaponTableRecipeBuilder requires(TagKey<Item> tagIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_206419_(tagIn);
    }

    public void m_142700_(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        id = new ResourceLocation(id.m_135827_(), "weapontable/" + id.m_135815_());
        this.f_126176_.m_138386_("has_skill", (CriterionTriggerInstance)SkillUnlockedTrigger.builder(this.skills != null && this.skills.length >= 1 ? this.skills[0] : HunterSkills.weapon_table));
        this.m_126207_(id);
        this.f_126176_.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumerIn.accept((FinishedRecipe)new Result(id, this.f_126173_, this.f_126174_, this.f_126177_ == null ? "" : this.f_126177_, this.f_126175_, this.f_126176_, new ResourceLocation(id.m_135827_(), "recipes/" + this.f_126173_.m_41471_().m_40783_() + "/" + id.m_135815_()), this.lava, this.skills != null ? this.skills : new ISkill[]{}, this.level));
    }

    public ShapelessWeaponTableRecipeBuilder lava(int amount) {
        this.lava = amount;
        return this;
    }

    public ShapelessWeaponTableRecipeBuilder level(int level) {
        this.level = level;
        return this;
    }

    @Nonnull
    public ShapelessWeaponTableRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_142284_(name, criterionIn);
    }

    public ShapelessWeaponTableRecipeBuilder skills(ISkill<?> ... skills) {
        this.skills = skills;
        return this;
    }

    private static class Result
    extends ShapelessRecipeBuilder.Result {
        private final int lava;
        private final ISkill<?>[] skills;
        private final int level;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<Ingredient> ingredientsIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn, int lavaIn, ISkill<?>[] skillsIn, int levelIn) {
            super(idIn, resultIn, countIn, groupIn, ingredientsIn, advancementBuilderIn, advancementIdIn);
            this.lava = lavaIn;
            this.skills = skillsIn;
            this.level = levelIn;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return ModRecipes.shapeless_crafting_weapontable;
        }

        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            json.addProperty("lava", (Number)this.lava);
            JsonArray skills = new JsonArray();
            for (ISkill<?> skill : this.skills) {
                skills.add(skill.getRegistryName().toString());
            }
            json.add("skill", (JsonElement)skills);
            json.addProperty("level", (Number)this.level);
        }
    }
}

