/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.advancements.SkillUnlockedTrigger;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
public class ShapedWeaponTableRecipeBuilder
extends ShapedRecipeBuilder {
    private final JsonObject extraNbt;
    private int lava = 1;
    private ISkill<?>[] skills;
    private int level = 1;

    public static ShapedWeaponTableRecipeBuilder shapedWeaponTable(ItemLike item) {
        return new ShapedWeaponTableRecipeBuilder(item, 1, null);
    }

    public static ShapedWeaponTableRecipeBuilder shapedWeaponTable(ItemLike item, int count) {
        return new ShapedWeaponTableRecipeBuilder(item, count, null);
    }

    public static ShapedWeaponTableRecipeBuilder shapedWeaponTable(ItemLike item, int count, JsonObject nbt) {
        return new ShapedWeaponTableRecipeBuilder(item, count, nbt);
    }

    public ShapedWeaponTableRecipeBuilder(ItemLike item, int count, @Nullable JsonObject extraNbt) {
        super(item, count);
        this.extraNbt = extraNbt;
    }

    @Nonnull
    public ShapedWeaponTableRecipeBuilder define(Character symbol, ItemLike itemIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_126127_(symbol, itemIn);
    }

    @Nonnull
    public ShapedWeaponTableRecipeBuilder define(Character symbol, Ingredient ingredientIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_126124_(symbol, ingredientIn);
    }

    @Nonnull
    public ShapedWeaponTableRecipeBuilder define(Character symbol, TagKey<Item> tagIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_206416_(symbol, tagIn);
    }

    @Nonnull
    public ShapedWeaponTableRecipeBuilder group(@Nullable String groupIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_142409_(groupIn);
    }

    @Nonnull
    public ShapedWeaponTableRecipeBuilder pattern(String patternIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_126130_(patternIn);
    }

    public ShapedWeaponTableRecipeBuilder lava(int amount) {
        this.lava = amount;
        return this;
    }

    public ShapedWeaponTableRecipeBuilder level(int level) {
        this.level = level;
        return this;
    }

    public void m_142700_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        id = new ResourceLocation(id.m_135827_(), "weapontable/" + id.m_135815_());
        this.f_126110_.m_138386_("has_skill", (CriterionTriggerInstance)SkillUnlockedTrigger.builder(this.skills != null && this.skills.length >= 1 ? this.skills[0] : HunterSkills.weapon_table));
        this.m_126143_(id);
        this.f_126110_.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept((FinishedRecipe)new Result(id, this.f_126106_, this.f_126107_, this.f_126111_ == null ? "" : this.f_126111_, this.f_126108_, this.f_126109_, this.f_126110_, new ResourceLocation(id.m_135827_(), "recipes/" + this.f_126106_.m_41471_().m_40783_() + "/" + id.m_135815_()), this.lava, this.skills != null ? this.skills : new ISkill[]{}, this.level, this.extraNbt));
    }

    @Nonnull
    public ShapedWeaponTableRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_142284_(name, criterionIn);
    }

    public ShapedWeaponTableRecipeBuilder skills(ISkill<?> ... skills) {
        this.skills = skills;
        return this;
    }

    private static class Result
    extends ShapedRecipeBuilder.Result {
        private final int lava;
        private final ISkill<?>[] skills;
        private final int level;
        private final JsonObject extraNbt;

        public Result(ResourceLocation id, Item item, int count, String group, List<String> pattern, Map<Character, Ingredient> ingredients, Advancement.Builder advancementBuilder, ResourceLocation advancementId, int lava, ISkill<?>[] skills, int level, JsonObject extraNbt) {
            super(id, item, count, group, pattern, ingredients, advancementBuilder, advancementId);
            this.lava = lava;
            this.skills = skills;
            this.level = level;
            this.extraNbt = extraNbt;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return ModRecipes.shaped_crafting_weapontable;
        }

        public void m_7917_(JsonObject jsonObject) {
            super.m_7917_(jsonObject);
            jsonObject.addProperty("lava", (Number)this.lava);
            JsonArray skills = new JsonArray();
            for (ISkill<?> skill : this.skills) {
                skills.add(skill.getRegistryName().toString());
            }
            jsonObject.add("skill", (JsonElement)skills);
            jsonObject.addProperty("level", (Number)this.level);
            if (this.extraNbt != null) {
                jsonObject.get("result").getAsJsonObject().add("nbt", (JsonElement)this.extraNbt);
            }
        }
    }
}

