/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import de.teamlapen.vampirism.entity.BlindingBatEntity;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.ThrowableItemEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCowEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedDonkeyEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedHorseEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedMuleEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedSheepEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedVillagerEntity;
import de.teamlapen.vampirism.entity.converted.SpecialConvertingHandler;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import de.teamlapen.vampirism.entity.hunter.AggressiveVillagerEntity;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.hunter.DummyHunterTrainerEntity;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTaskMasterEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.BasicVampireEntity;
import de.teamlapen.vampirism.entity.vampire.DummyBittenAnimalEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireTaskMasterEntity;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="vampirism")
public class ModEntities {
    public static final EntityType<AdvancedHunterEntity> advanced_hunter;
    public static final EntityType<AdvancedHunterEntity.IMob> advanced_hunter_imob;
    public static final EntityType<AdvancedVampireEntity> advanced_vampire;
    public static final EntityType<AdvancedVampireEntity.IMob> advanced_vampire_imob;
    public static final EntityType<BlindingBatEntity> blinding_bat;
    public static final EntityType<ConvertedCreatureEntity<?>> converted_creature;
    public static final EntityType<ConvertedCreatureEntity.IMob> converted_creature_imob;
    public static final EntityType<ConvertedSheepEntity> converted_sheep;
    public static final EntityType<ConvertedCowEntity> converted_cow;
    public static final EntityType<ConvertedDonkeyEntity> converted_donkey;
    public static final EntityType<ConvertedMuleEntity> converted_mule;
    public static final EntityType<ConvertedHorseEntity> converted_horse;
    public static final EntityType<CrossbowArrowEntity> crossbow_arrow;
    public static final EntityType<DarkBloodProjectileEntity> dark_blood_projectile;
    public static final EntityType<DummyBittenAnimalEntity> dummy_creature;
    public static final EntityType<HunterTrainerEntity> hunter_trainer;
    public static final EntityType<DummyHunterTrainerEntity> hunter_trainer_dummy;
    public static final EntityType<AreaParticleCloudEntity> particle_cloud;
    public static final EntityType<SoulOrbEntity> soul_orb;
    public static final EntityType<ThrowableItemEntity> throwable_item;
    public static final EntityType<BasicVampireEntity> vampire;
    public static final EntityType<BasicVampireEntity.IMob> vampire_imob;
    public static final EntityType<VampireBaronEntity> vampire_baron;
    public static final EntityType<BasicHunterEntity> hunter;
    public static final EntityType<BasicHunterEntity.IMob> hunter_imob;
    public static final EntityType<AggressiveVillagerEntity> villager_angry;
    public static final EntityType<ConvertedVillagerEntity> villager_converted;
    public static final EntityType<VampireMinionEntity> vampire_minion;
    public static final EntityType<HunterMinionEntity> hunter_minion;
    public static final EntityType<VampireTaskMasterEntity> task_master_vampire;
    public static final EntityType<HunterTaskMasterEntity> task_master_hunter;
    private static final Set<EntityType<?>> ALL_ENTITIES;

    static void registerCustomExtendedCreatures() {
        IVampirismEntityRegistry registry = VampirismAPI.entityRegistry();
    }

    static void registerConvertibles() {
        Function<String, ResourceLocation> overlay = name -> new ResourceLocation("vampirism", String.format("textures/entity/vanilla/%s_overlay.png", name));
        IVampirismEntityRegistry registry = VampirismAPI.entityRegistry();
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20557_, overlay.apply("cow"), new ConvertedCowEntity.ConvertingHandler());
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20466_, overlay.apply("llama"));
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20505_, overlay.apply("cat"));
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20507_, overlay.apply("panda"));
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20510_, overlay.apply("pig"));
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20514_, overlay.apply("polarbear"));
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20517_, overlay.apply("rabbit"));
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20520_, overlay.apply("sheep"), new ConvertedSheepEntity.ConvertingHandler());
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20492_, null, new ConvertedVillagerEntity.ConvertingHandler());
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20457_, overlay.apply("horse"), new SpecialConvertingHandler(converted_horse));
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20560_, overlay.apply("horse"), new SpecialConvertingHandler(converted_donkey));
        registry.addConvertible((EntityType<? extends PathfinderMob>)EntityType.f_20503_, overlay.apply("horse"), new SpecialConvertingHandler(converted_mule));
    }

    static void registerEntities(IForgeRegistry<EntityType<?>> registry) {
        registry.register(advanced_hunter);
        registry.register(ModEntities.prepareEntityType("advanced_hunter_imob", EntityType.Builder.m_20704_(AdvancedHunterEntity.IMob::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), false));
        registry.register(advanced_vampire);
        registry.register(ModEntities.prepareEntityType("advanced_vampire_imob", EntityType.Builder.m_20704_(AdvancedVampireEntity.IMob::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), false));
        registry.register(blinding_bat);
        registry.register(converted_creature);
        registry.register(ModEntities.prepareEntityType("converted_creature_imob", EntityType.Builder.m_20704_(ConvertedCreatureEntity.IMob::new, (MobCategory)MobCategory.CREATURE), false));
        registry.register(ModEntities.prepareEntityType("converted_sheep", EntityType.Builder.m_20704_(ConvertedSheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f), false));
        registry.register(ModEntities.prepareEntityType("converted_cow", EntityType.Builder.m_20704_(ConvertedCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f), false));
        registry.register(ModEntities.prepareEntityType("crossbow_arrow", EntityType.Builder.m_20704_(CrossbowArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setCustomClientFactory((spawnEntity, world) -> new CrossbowArrowEntity((EntityType<? extends CrossbowArrowEntity>)crossbow_arrow, (Level)world)), false));
        registry.register(ModEntities.prepareEntityType("dark_blood_projectile", EntityType.Builder.m_20704_(DarkBloodProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.6f, 1.95f).m_20719_().setCustomClientFactory((spawnEntity, world) -> new DarkBloodProjectileEntity((EntityType<? extends DarkBloodProjectileEntity>)dark_blood_projectile, (Level)world)), false));
        registry.register(dummy_creature);
        registry.register(hunter_trainer);
        registry.register(ModEntities.prepareEntityType("hunter_trainer_dummy", EntityType.Builder.m_20704_(DummyHunterTrainerEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.6f, 1.95f), true));
        registry.register(ModEntities.prepareEntityType("particle_cloud", EntityType.Builder.m_20704_(AreaParticleCloudEntity::new, (MobCategory)MobCategory.MISC).m_20699_(6.0f, 0.5f).m_20719_().setCustomClientFactory((spawnEntity, world) -> new AreaParticleCloudEntity((EntityType<? extends AreaParticleCloudEntity>)particle_cloud, (Level)world)), false));
        registry.register(ModEntities.prepareEntityType("soul_orb", EntityType.Builder.m_20704_(SoulOrbEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20719_().setCustomClientFactory((spawnEntity, world) -> new SoulOrbEntity((EntityType<? extends SoulOrbEntity>)soul_orb, (Level)world)), false));
        registry.register(ModEntities.prepareEntityType("throwable_item", EntityType.Builder.m_20704_(ThrowableItemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setCustomClientFactory((spawnEntity, world) -> new ThrowableItemEntity((EntityType<? extends ThrowableItemEntity>)throwable_item, (Level)world)), false));
        registry.register(vampire);
        registry.register(ModEntities.prepareEntityType("vampire_imob", EntityType.Builder.m_20704_(BasicVampireEntity.IMob::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), false));
        registry.register(vampire_baron);
        registry.register(hunter);
        registry.register(ModEntities.prepareEntityType("hunter_imob", EntityType.Builder.m_20704_(BasicHunterEntity.IMob::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), false));
        registry.register(ModEntities.prepareEntityType("villager_angry", EntityType.Builder.m_20704_(AggressiveVillagerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f), false));
        registry.register(ModEntities.prepareEntityType("villager_converted", EntityType.Builder.m_20704_(ConvertedVillagerEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), false));
        registry.register(ModEntities.prepareEntityType("converted_horse", EntityType.Builder.m_20704_(ConvertedHorseEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.3964844f, 1.6f), false));
        registry.register(ModEntities.prepareEntityType("vampire_minion", EntityType.Builder.m_20704_(VampireMinionEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f), false));
        registry.register(ModEntities.prepareEntityType("converted_donkey", EntityType.Builder.m_20704_(ConvertedDonkeyEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.3964844f, 1.5f), false));
        registry.register(ModEntities.prepareEntityType("converted_mule", EntityType.Builder.m_20704_(ConvertedMuleEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.3964844f, 1.5f), false));
        VampireMinionEntity.init();
        HunterMinionEntity.init();
        registry.register(ModEntities.prepareEntityType("hunter_minion", EntityType.Builder.m_20704_(HunterMinionEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f), false));
        registry.register(ModEntities.prepareEntityType("task_master_vampire", EntityType.Builder.m_20704_(VampireTaskMasterEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true));
        registry.register(ModEntities.prepareEntityType("task_master_hunter", EntityType.Builder.m_20704_(HunterTaskMasterEntity::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true));
    }

    static void registerSpawns() {
        SpawnPlacements.m_21754_(advanced_hunter, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HunterBaseEntity::spawnPredicateHunter);
        SpawnPlacements.m_21754_(advanced_vampire, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VampireBaseEntity::spawnPredicateVampire);
        SpawnPlacements.m_21754_(blinding_bat, (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlindingBatEntity::spawnPredicate);
        SpawnPlacements.m_21754_(dummy_creature, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DummyBittenAnimalEntity::spawnPredicate);
        SpawnPlacements.m_21754_(converted_creature, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate);
        SpawnPlacements.m_21754_(converted_sheep, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate);
        SpawnPlacements.m_21754_(converted_cow, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate);
        SpawnPlacements.m_21754_(hunter_trainer, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
        SpawnPlacements.m_21754_(hunter_trainer_dummy, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
        SpawnPlacements.m_21754_(vampire, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VampireBaseEntity::spawnPredicateVampire);
        SpawnPlacements.m_21754_(vampire_baron, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VampireBaronEntity::spawnPredicateBaron);
        SpawnPlacements.m_21754_(hunter, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HunterBaseEntity::spawnPredicateHunter);
        SpawnPlacements.m_21754_(villager_angry, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
        SpawnPlacements.m_21754_(villager_converted, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
    }

    static void onRegisterEntityTypeAttributes(EntityAttributeCreationEvent event) {
        event.put(advanced_hunter, AdvancedHunterEntity.getAttributeBuilder().m_22265_());
        event.put(advanced_hunter_imob, AdvancedHunterEntity.getAttributeBuilder().m_22265_());
        event.put(advanced_vampire, AdvancedVampireEntity.getAttributeBuilder().m_22265_());
        event.put(advanced_vampire_imob, AdvancedVampireEntity.getAttributeBuilder().m_22265_());
        event.put(blinding_bat, Bat.m_27455_().m_22265_());
        event.put(converted_creature, BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put(converted_creature_imob, BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put(converted_horse, ConvertedHorseEntity.getAttributeBuilder().m_22265_());
        event.put(converted_sheep, BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put(converted_cow, BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put(converted_donkey, ConvertedDonkeyEntity.getAttributeBuilder().m_22265_());
        event.put(converted_mule, ConvertedMuleEntity.getAttributeBuilder().m_22265_());
        event.put(dummy_creature, BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put(hunter, BasicHunterEntity.getAttributeBuilder().m_22265_());
        event.put(hunter_imob, BasicHunterEntity.getAttributeBuilder().m_22265_());
        event.put(hunter_trainer, HunterTrainerEntity.getAttributeBuilder().m_22265_());
        event.put(hunter_trainer_dummy, HunterTrainerEntity.getAttributeBuilder().m_22265_());
        event.put(vampire, BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put(vampire_imob, BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put(vampire_baron, VampireBaronEntity.getAttributeBuilder().m_22265_());
        event.put(villager_angry, AggressiveVillagerEntity.getAttributeBuilder().m_22265_());
        event.put(villager_converted, ConvertedVillagerEntity.getAttributeBuilder().m_22265_());
        event.put(hunter_minion, HunterMinionEntity.getAttributeBuilder().m_22265_());
        event.put(vampire_minion, VampireMinionEntity.getAttributeBuilder().m_22265_());
        event.put(task_master_hunter, HunterTaskMasterEntity.getAttributeBuilder().m_22265_());
        event.put(task_master_vampire, VampireTaskMasterEntity.getAttributeBuilder().m_22265_());
    }

    static void onModifyEntityTypeAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)ModAttributes.sundamage);
        event.add(EntityType.f_20532_, (Attribute)ModAttributes.blood_exhaustion);
    }

    private static <T extends Entity> EntityType<T> prepareEntityType(String id, EntityType.Builder<T> builder, boolean spawnable) {
        EntityType.Builder type = builder.setTrackingRange(80).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
        if (!spawnable) {
            type.m_20698_();
        }
        EntityType entry = type.m_20712_("vampirism:" + id);
        entry.setRegistryName("vampirism", id);
        if (VampirismMod.inDataGen) {
            ALL_ENTITIES.add(entry);
        }
        return entry;
    }

    static void fixMapping(RegistryEvent.MissingMappings<EntityType<?>> missingMappings) {
        missingMappings.getAllMappings().forEach(mapping -> {
            if (mapping.key.equals((Object)new ResourceLocation("vampirism:vampire_hunter"))) {
                mapping.remap(hunter);
            } else if (mapping.key.equals((Object)new ResourceLocation("vampirism:vampire_hunter_imob"))) {
                mapping.remap(hunter_imob);
            }
        });
    }

    public static Set<EntityType<?>> getAllEntities() {
        return ImmutableSet.copyOf(ALL_ENTITIES);
    }

    static {
        advanced_hunter_imob = (EntityType)UtilLib.getNull();
        advanced_vampire_imob = (EntityType)UtilLib.getNull();
        converted_creature_imob = (EntityType)UtilLib.getNull();
        converted_sheep = (EntityType)UtilLib.getNull();
        converted_cow = (EntityType)UtilLib.getNull();
        converted_donkey = (EntityType)UtilLib.getNull();
        converted_mule = (EntityType)UtilLib.getNull();
        converted_horse = (EntityType)UtilLib.getNull();
        crossbow_arrow = (EntityType)UtilLib.getNull();
        dark_blood_projectile = (EntityType)UtilLib.getNull();
        hunter_trainer_dummy = (EntityType)UtilLib.getNull();
        particle_cloud = (EntityType)UtilLib.getNull();
        soul_orb = (EntityType)UtilLib.getNull();
        throwable_item = (EntityType)UtilLib.getNull();
        vampire_imob = (EntityType)UtilLib.getNull();
        hunter_imob = (EntityType)UtilLib.getNull();
        villager_angry = (EntityType)UtilLib.getNull();
        villager_converted = (EntityType)UtilLib.getNull();
        vampire_minion = (EntityType)UtilLib.getNull();
        hunter_minion = (EntityType)UtilLib.getNull();
        task_master_vampire = (EntityType)UtilLib.getNull();
        task_master_hunter = (EntityType)UtilLib.getNull();
        ALL_ENTITIES = Sets.newHashSet();
        hunter = ModEntities.prepareEntityType("hunter", EntityType.Builder.m_20704_(BasicHunterEntity::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
        hunter_trainer = ModEntities.prepareEntityType("hunter_trainer", EntityType.Builder.m_20704_(HunterTrainerEntity::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
        advanced_hunter = ModEntities.prepareEntityType("advanced_hunter", EntityType.Builder.m_20704_(AdvancedHunterEntity::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
        vampire_baron = ModEntities.prepareEntityType("vampire_baron", EntityType.Builder.m_20704_(VampireBaronEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
        vampire = ModEntities.prepareEntityType("vampire", EntityType.Builder.m_20704_(BasicVampireEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
        advanced_vampire = ModEntities.prepareEntityType("advanced_vampire", EntityType.Builder.m_20704_(AdvancedVampireEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
        converted_creature = ModEntities.prepareEntityType("converted_creature", EntityType.Builder.m_20704_(ConvertedCreatureEntity::new, (MobCategory)MobCategory.CREATURE), false);
        dummy_creature = ModEntities.prepareEntityType("dummy_creature", EntityType.Builder.m_20704_(DummyBittenAnimalEntity::new, (MobCategory)MobCategory.CREATURE), true);
        blinding_bat = ModEntities.prepareEntityType("blinding_bat", EntityType.Builder.m_20704_(BlindingBatEntity::new, (MobCategory)MobCategory.AMBIENT).m_20699_(0.5f, 0.9f), true);
    }
}

