/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.effects.FreezeEffect;
import de.teamlapen.vampirism.effects.OblivionEffect;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.effects.ThirstEffect;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.effects.VampirismNightVisionPotion;
import de.teamlapen.vampirism.effects.VampirismPoisonEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ObjectHolder(value="vampirism")
public class ModEffects {
    public static final MobEffect sanguinare = (MobEffect)UtilLib.getNull();
    public static final MobEffect thirst = (MobEffect)UtilLib.getNull();
    public static final MobEffect saturation = (MobEffect)UtilLib.getNull();
    public static final MobEffect sunscreen = (MobEffect)UtilLib.getNull();
    public static final MobEffect disguise_as_vampire = (MobEffect)UtilLib.getNull();
    public static final MobEffect fire_protection = (MobEffect)UtilLib.getNull();
    public static final MobEffect garlic = (MobEffect)UtilLib.getNull();
    public static final MobEffect poison = (MobEffect)UtilLib.getNull();
    public static final MobEffect freeze = (MobEffect)UtilLib.getNull();
    public static final MobEffect neonatal = (MobEffect)UtilLib.getNull();
    public static final MobEffect oblivion = (MobEffect)UtilLib.getNull();
    public static final MobEffect armor_regeneration = (MobEffect)UtilLib.getNull();
    public static final MobEffect bad_omen_hunter = (MobEffect)UtilLib.getNull();
    public static final MobEffect bad_omen_vampire = (MobEffect)UtilLib.getNull();
    private static final Logger LOGGER = LogManager.getLogger();
    private static MobEffect modded_night_vision;
    private static MobEffect vanilla_night_vision;

    static void registerEffects(IForgeRegistry<MobEffect> registry) {
        vanilla_night_vision = MobEffects.f_19611_;
        registry.register((IForgeRegistryEntry)new VampirismNightVisionPotion());
        registry.register((IForgeRegistryEntry)new ThirstEffect("thirst", MobEffectCategory.HARMFUL, 859494));
        registry.register((IForgeRegistryEntry)new SanguinareEffect("sanguinare", MobEffectCategory.NEUTRAL, 6949000));
        registry.register((IForgeRegistryEntry)new VampirismEffect("saturation", MobEffectCategory.BENEFICIAL, 14483200));
        registry.register((IForgeRegistryEntry)new VampirismEffect("sunscreen", MobEffectCategory.BENEFICIAL, 0xFFF100).m_19472_((Attribute)ModAttributes.sundamage, "9dc9420c-3e5e-41c7-9ba4-ff70e9dc69fc", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        registry.register((IForgeRegistryEntry)new VampirismEffect("fire_protection", MobEffectCategory.BENEFICIAL, 14981690));
        registry.register((IForgeRegistryEntry)new VampirismEffect("disguise_as_vampire", MobEffectCategory.NEUTRAL, 0x999900));
        registry.register((IForgeRegistryEntry)new VampirismEffect("garlic", MobEffectCategory.HARMFUL, 0xFFFFFF));
        registry.register((IForgeRegistryEntry)new VampirismPoisonEffect("poison", 5149489));
        registry.register((IForgeRegistryEntry)new FreezeEffect("freeze"));
        registry.register((IForgeRegistryEntry)new VampirismEffect("neonatal", MobEffectCategory.NEUTRAL, 0xFFBBBB).m_19472_(Attributes.f_22281_, "377d132d-d091-43b2-8a8f-b940f9bc894c", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_(Attributes.f_22279_, "ad6d7def-46e2-485f-afba-39252767f114", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL));
        registry.register((IForgeRegistryEntry)new OblivionEffect("oblivion", MobEffectCategory.NEUTRAL, 5149489));
        registry.register((IForgeRegistryEntry)new VampirismEffect("armor_regeneration", MobEffectCategory.NEUTRAL, 13727298));
        registry.register((IForgeRegistryEntry)new BadOmenEffect("vampirism", REFERENCE.HUNTER_PLAYER_KEY){

            @Override
            public IFaction<?> getFaction() {
                return VReference.HUNTER_FACTION;
            }
        });
        registry.register((IForgeRegistryEntry)new BadOmenEffect("vampirism", REFERENCE.VAMPIRE_PLAYER_KEY){

            @Override
            public IFaction<?> getFaction() {
                return VReference.VAMPIRE_FACTION;
            }
        });
    }

    static void fixNightVisionEffectTypesUnsafe() {
        LOGGER.info("Fixing vanilla night vision potion types");
        try {
            for (MobEffectInstance effect : Potions.f_43603_.m_43488_()) {
                if (!effect.m_19544_().equals(vanilla_night_vision)) continue;
                ObfuscationReflectionHelper.setPrivateValue(MobEffectInstance.class, (Object)effect, (Object)modded_night_vision, (String)"effect");
            }
            for (MobEffectInstance effect : Potions.f_43604_.m_43488_()) {
                if (!effect.m_19544_().equals(vanilla_night_vision)) continue;
                ObfuscationReflectionHelper.setPrivateValue(MobEffectInstance.class, (Object)effect, (Object)modded_night_vision, (String)"effect");
            }
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException e) {
            LOGGER.error("Unable to modify vanilla night vision types. Potion tileInventory and more might not work", (Throwable)e);
        }
    }

    static boolean checkNightVision() {
        if (!(MobEffects.f_19611_ instanceof VampirismNightVisionPotion)) {
            LOGGER.warn("Vampirism was not able to register it's night vision potion");
            return false;
        }
        return true;
    }
}

