/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.config;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.config.BalanceConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BalanceBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, Map<String, Conf>> categoryConfigMap;
    private final Map<String, String> categoryPrefixMap;
    private final ConcurrentHashMap<String, Consumer<? extends Conf>> balanceModifications = new ConcurrentHashMap();
    private Map<String, Conf> activeCategory;
    @Nullable
    private String currentComment;

    private static void setVal(BalanceConfig conf, String name, Object value) {
        try {
            Field f = BalanceConfig.class.getDeclaredField(name);
            f.setAccessible(true);
            f.set(conf, value);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Failed to set Balance value as expected", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Illegal access when trying to set Balance value as expected", (Throwable)e);
        }
    }

    BalanceBuilder() {
        this.categoryConfigMap = new HashMap<String, Map<String, Conf>>();
        this.categoryPrefixMap = new HashMap<String, String>();
    }

    public void addBalanceModifier(String key, Consumer<? extends Conf> modifier) {
        if (this.balanceModifications.put(key, modifier) != null && VampirismMod.inDev) {
            LOGGER.warn("Overriding existing config modifier for {}", (Object)key);
        }
    }

    public void build(BalanceConfig conf, ForgeConfigSpec.Builder builder) {
        if (this.balanceModifications.size() > 0) {
            LOGGER.info("Building balance configuration with {} modifications", (Object)this.balanceModifications.size());
        }
        for (Map.Entry<String, Map<String, Conf>> stringMapEntry : this.categoryConfigMap.entrySet()) {
            String category = stringMapEntry.getKey();
            String catPrefix = this.categoryPrefixMap.getOrDefault(category, category);
            builder.push(category);
            for (Map.Entry<String, Conf> stringConfEntry : stringMapEntry.getValue().entrySet()) {
                String name = stringConfEntry.getKey();
                Object fullName = catPrefix.isEmpty() ? name : catPrefix + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
                Conf c = stringConfEntry.getValue();
                Consumer<? extends Conf> modifier = this.balanceModifications.get(fullName);
                if (modifier != null) {
                    try {
                        modifier.accept(c);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to apply balance config modifier for " + (String)fullName, (Throwable)e);
                    }
                }
                ForgeConfigSpec.ConfigValue<?> val = c.build(builder);
                BalanceBuilder.setVal(conf, (String)fullName, val);
            }
            builder.pop();
        }
        this.categoryConfigMap.clear();
        this.balanceModifications.clear();
        this.categoryPrefixMap.clear();
        this.currentComment = null;
    }

    public BalanceBuilder category(String name, String prefix) {
        this.activeCategory = new HashMap<String, Conf>();
        this.categoryConfigMap.put(name, this.activeCategory);
        this.categoryPrefixMap.put(name, prefix);
        return this;
    }

    public void checkFields(BalanceConfig config) throws IllegalStateException {
        try {
            for (Field declaredField : BalanceConfig.class.getDeclaredFields()) {
                declaredField.setAccessible(true);
                if (declaredField.get(config) != null) continue;
                throw new IllegalStateException("Config value " + declaredField.getName() + " is not set");
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Illegal access when checking balance fields", (Throwable)e);
        }
    }

    public BalanceBuilder comment(String comment) {
        this.currentComment = comment;
        return this;
    }

    public BalanceBuilder config(Conf value) {
        this.activeCategory.put(value.name, value);
        return this;
    }

    public ForgeConfigSpec.BooleanValue define(String name, boolean defaultValue) {
        this.add(new BoolConf(name, defaultValue));
        return null;
    }

    public ForgeConfigSpec.IntValue defineInRange(String name, int def, int min, int max) {
        this.add(new IntConf(name, def, min, max));
        return null;
    }

    public ForgeConfigSpec.DoubleValue defineInRange(String name, double def, double min, double max) {
        this.add(new DoubleConf(name, def, min, max));
        return null;
    }

    public ForgeConfigSpec.ConfigValue<List<? extends String>> defineList(String name, List<String> defaultValues, Predicate<Object> validator) {
        this.add(new StringList(name, defaultValues, validator));
        return null;
    }

    private void add(Conf c) {
        if (this.currentComment != null) {
            c.comment(this.currentComment);
            this.currentComment = null;
        }
        this.activeCategory.put(c.name, c);
    }

    public static abstract class Conf {
        protected final String name;
        @Nullable
        private String comment = null;

        protected Conf(String name) {
            this.name = name;
        }

        public final ForgeConfigSpec.ConfigValue<?> build(ForgeConfigSpec.Builder builder) {
            if (this.comment != null) {
                builder.comment(this.comment);
            }
            return this.buildInternal(builder);
        }

        public void comment(String comment) {
            this.comment = comment;
        }

        @Nullable
        public String getComment() {
            return this.comment;
        }

        protected abstract ForgeConfigSpec.ConfigValue<?> buildInternal(ForgeConfigSpec.Builder var1);
    }

    public static class BoolConf
    extends Conf {
        private boolean defaultValue;

        protected BoolConf(String name, boolean defaultValue) {
            super(name);
            this.defaultValue = defaultValue;
        }

        public boolean isDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        protected ForgeConfigSpec.ConfigValue<?> buildInternal(ForgeConfigSpec.Builder builder) {
            return builder.define(this.name, this.defaultValue);
        }
    }

    public static class IntConf
    extends Conf {
        private final int minValue;
        private final int maxValue;
        private int defaultValue;

        IntConf(String name, int defaultValue, int minValue, int maxValue) {
            super(name);
            this.defaultValue = defaultValue;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public ForgeConfigSpec.ConfigValue<?> buildInternal(ForgeConfigSpec.Builder builder) {
            return builder.defineInRange(this.name, this.defaultValue, this.minValue, this.maxValue);
        }

        public int getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
        }
    }

    public static class DoubleConf
    extends Conf {
        private final double min;
        private final double max;
        private double defaultValue;

        DoubleConf(String name, double defaultValue, double min, double max) {
            super(name);
            this.defaultValue = defaultValue;
            this.min = min;
            this.max = max;
        }

        public double getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(double defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        protected ForgeConfigSpec.ConfigValue<?> buildInternal(ForgeConfigSpec.Builder builder) {
            return builder.defineInRange(this.name, this.defaultValue, this.min, this.max);
        }
    }

    public static class StringList
    extends Conf {
        private final List<String> defaultValue;
        private final Predicate<Object> elementValidator;

        StringList(String name, List<String> defaultValue, Predicate<Object> validator) {
            super(name);
            this.defaultValue = new ArrayList<String>(defaultValue);
            this.elementValidator = validator;
        }

        public void addValue(String s) {
            if (this.elementValidator.test(s)) {
                this.defaultValue.add(s);
            }
        }

        @Override
        public ForgeConfigSpec.ConfigValue<?> buildInternal(ForgeConfigSpec.Builder builder) {
            return builder.defineList(this.name, Collections.unmodifiableList(this.defaultValue), this.elementValidator);
        }

        public void removeValue(String s) {
            this.defaultValue.remove(s);
        }
    }
}

