/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.command.arguments.SkillArgument;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SkillCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return SkillCommand.create(Commands.m_82127_((String)"skills"));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> create(ArgumentBuilder<CommandSourceStack, ?> builder) {
        return builder.requires(context -> context.m_6761_(3)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)SkillArgument.skills()).executes(context -> SkillCommand.skill((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "type"), false))).then(Commands.m_82127_((String)"force").executes(context -> SkillCommand.skill((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "type"), true)))).then(Commands.m_82127_((String)"disableall").executes(context -> SkillCommand.disableall((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_())));
    }

    private static int disableall(CommandSourceStack commandSource, ServerPlayer asPlayer) {
        IFactionPlayer factionPlayer;
        IFactionPlayer iFactionPlayer = factionPlayer = asPlayer.m_6084_() ? (IFactionPlayer)FactionPlayerHandler.getCurrentFactionPlayer((Player)asPlayer).orElse(null) : null;
        if (factionPlayer == null) {
            commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.noinfaction"), false);
            return 0;
        }
        factionPlayer.getSkillHandler().resetSkills();
        return 0;
    }

    private static int skill(CommandSourceStack commandSource, ServerPlayer asPlayer, ISkill skill, boolean force) {
        IFactionPlayer factionPlayer;
        IFactionPlayer iFactionPlayer = factionPlayer = asPlayer.m_6084_() ? (IFactionPlayer)FactionPlayerHandler.getCurrentFactionPlayer((Player)asPlayer).orElse(null) : null;
        if (factionPlayer == null) {
            commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.noinfaction"), false);
            return 0;
        }
        if (factionPlayer.getSkillHandler().isSkillEnabled(skill)) {
            factionPlayer.getSkillHandler().disableSkill(skill);
            commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.disabled"), false);
            return 0;
        }
        ISkillHandler.Result result = factionPlayer.getSkillHandler().canSkillBeEnabled(skill);
        if (force) {
            result = ISkillHandler.Result.OK;
        }
        switch (result) {
            case OK: {
                factionPlayer.getSkillHandler().enableSkill(skill);
                commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.enabled", new Object[]{skill.getRegistryName() + " (" + skill.getName().getString() + ")"}), false);
                break;
            }
            case ALREADY_ENABLED: {
                commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.alreadyenabled", new Object[]{skill.getName()}), false);
                break;
            }
            case PARENT_NOT_ENABLED: {
                ISkill<T>[] skills = factionPlayer.getSkillHandler().getParentSkills(skill);
                if (skills == null || skills.length == 0) {
                    return 0;
                }
                if (skills.length == 1) {
                    commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.parent", new Object[]{skills[0].getRegistryName()}), false);
                    break;
                }
                commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.parents", new Object[]{skills[0].getRegistryName(), skills[1].getRegistryName()}), false);
                break;
            }
            case NO_POINTS: {
                commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.nopoints"), false);
                break;
            }
            case OTHER_NODE_SKILL: {
                commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.othernode"), false);
                break;
            }
            case NOT_FOUND: {
                commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.otherfaction"), false);
                break;
            }
            case LOCKED_BY_OTHER_NODE: {
                commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.locked"), false);
                break;
            }
            case LOCKED_BY_PLAYER_STATE: {
                commandSource.m_81354_((Component)new TranslatableComponent("command.vampirism.test.skill.locked_player_state"), false);
            }
        }
        return 0;
    }
}

