/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class SkillArgument
implements ArgumentType<ISkill<?>> {
    public static final DynamicCommandExceptionType SKILL_NOT_FOUND = new DynamicCommandExceptionType(particle -> new TranslatableComponent("command.vampirism.argument.skill.notfound", new Object[]{particle}));
    private static final Collection<String> EXAMPLES = Arrays.asList("skill", "modid:skill");

    public static SkillArgument skills() {
        return new SkillArgument();
    }

    public static ISkill<?> getSkill(CommandContext<CommandSourceStack> context, String name) {
        return (ISkill)context.getArgument(name, ISkill.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_((Iterable)ModRegistries.SKILLS.getKeys(), (SuggestionsBuilder)builder);
    }

    public ISkill<?> parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.m_135818_((StringReader)reader);
        ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(id);
        if (skill == null) {
            throw SKILL_NOT_FOUND.create((Object)id);
        }
        return skill;
    }
}

