/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import de.teamlapen.vampirism.blockentity.CoffinBlockEntity;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.CoffinModel;
import de.teamlapen.vampirism.client.render.tiles.VampirismBESR;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CoffinBESR
extends VampirismBESR<CoffinBlockEntity> {
    private final int maxLidPos = 61;
    private final CoffinModel model;
    private final ResourceLocation[] textures = new ResourceLocation[DyeColor.values().length];
    private final Logger LOGGER = LogManager.getLogger();

    public CoffinBESR(BlockEntityRendererProvider.Context context) {
        this.model = new CoffinModel(context.m_173582_(ModEntitiesRender.COFFIN));
        for (DyeColor e : DyeColor.values()) {
            this.textures[e.m_41060_()] = new ResourceLocation("vampirism", "textures/block/coffin/coffin_" + e.m_7912_() + ".png");
        }
    }

    public void render(CoffinBlockEntity tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource iRenderTypeBuffer, int i, int i1) {
        if (!tile.renderAsItem) {
            boolean occupied;
            if (!this.isHeadSafe(tile.m_58904_(), tile.m_58899_())) {
                return;
            }
            boolean bl = occupied = tile.m_58898_() && CoffinBlock.isOccupied((BlockGetter)tile.m_58904_(), tile.m_58899_());
            if (!occupied && tile.lidPos > 0) {
                --tile.lidPos;
            } else if (occupied && tile.lidPos < 61) {
                ++tile.lidPos;
            }
        } else {
            tile.lidPos = 61;
        }
        this.model.rotateLid(this.calcLidAngle(tile.lidPos));
        int color = Math.min(tile.color.m_41060_(), 15);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        matrixStack.m_85836_();
        this.adjustRotatePivotViaState(tile, matrixStack);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        matrixStack.m_85837_(0.0, 0.0, -1.0);
        VertexConsumer vertexBuilder = iRenderTypeBuffer.m_6299_(RenderType.m_110446_((ResourceLocation)this.textures[color]));
        this.model.m_7695_(matrixStack, vertexBuilder, i, i1, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    private float calcLidAngle(int pos) {
        if (pos == 61) {
            return 0.0f;
        }
        if (pos == 0) {
            return 2.3561945f;
        }
        return (float)(-Math.pow(1.02, pos) + 1.0 + 2.356194490192345);
    }

    private boolean isHeadSafe(Level world, BlockPos pos) {
        try {
            return CoffinBlock.isHead((BlockGetter)world, pos);
        }
        catch (IllegalArgumentException e) {
            this.LOGGER.error("Failed to check coffin head at {} caused by wrong blockstate. Block at that pos: {}", (Object)pos, (Object)world.m_8055_(pos));
        }
        catch (Exception e) {
            this.LOGGER.error("Failed to check coffin head.", (Throwable)e);
        }
        return false;
    }
}

