/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.particle;

import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class FlyingBloodEntityParticle
extends TextureSheetParticle {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_AGE = 60;
    private final Entity entity;

    public FlyingBloodEntityParticle(ClientLevel world, double posX, double posY, double posZ, Entity entity, boolean direct) {
        super(world, posX, posY, posZ, 0.0, 0.0, 0.0);
        Validate.notNull((Object)entity);
        this.entity = entity;
        this.f_107227_ = 0.95f;
        this.f_107228_ = 0.05f;
        this.f_107229_ = 0.05f;
        this.f_107225_ = direct ? 30 : 60;
        if (direct) {
            this.f_107215_ = (this.f_107208_.f_46441_.nextDouble() - 0.5) / 5.0;
            this.f_107216_ = this.f_107208_.f_46441_.nextDouble() / 5.0;
            this.f_107217_ = (this.f_107208_.f_46441_.nextDouble() - 0.5) / 5.0;
        } else {
            this.f_107215_ = this.f_107208_.f_46441_.nextDouble() - 0.5;
            this.f_107216_ = this.f_107208_.f_46441_.nextDouble() + 0.2;
            this.f_107217_ = this.f_107208_.f_46441_.nextDouble() - 0.5;
        }
        this.m_108337_(Minecraft.m_91087_().f_91061_.f_107296_.m_118316_(new ResourceLocation("minecraft", "particle/critical_hit")));
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        double wayX = this.entity.m_20185_() - this.f_107212_;
        double wayY = this.entity.m_20186_() + (double)this.entity.m_20192_() - this.f_107213_;
        double wayZ = this.entity.m_20189_() - this.f_107214_;
        int tleft = this.f_107225_ - this.f_107224_;
        if (tleft < this.f_107225_ / 2) {
            this.f_107215_ = wayX / (double)tleft;
            this.f_107216_ = wayY / (double)tleft;
            this.f_107217_ = wayZ / (double)tleft;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<FlyingBloodEntityParticleData> {
        @Nullable
        public Particle createParticle(FlyingBloodEntityParticleData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Entity e = worldIn.m_6815_(typeIn.getEntityID());
            if (e == null) {
                LOGGER.warn("Could not find entity {} for flying blood particle", (Object)typeIn.getEntityID());
                return null;
            }
            return new FlyingBloodEntityParticle(worldIn, x, y, z, e, typeIn.getDirect());
        }
    }
}

