/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.HunterEquipmentModel;
import de.teamlapen.vampirism.client.render.entities.DualBipedRenderer;
import de.teamlapen.vampirism.client.render.layers.HunterEquipmentLayer;
import de.teamlapen.vampirism.client.render.layers.PlayerBodyOverlayLayer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class HunterMinionRenderer
extends DualBipedRenderer<HunterMinionEntity, PlayerModel<HunterMinionEntity>> {
    private final Pair<ResourceLocation, Boolean>[] textures = this.gatherTextures("textures/entity/hunter", true);
    private final Pair<ResourceLocation, Boolean>[] minionSpecificTextures = this.gatherTextures("textures/entity/minion/hunter", false);

    public HunterMinionRenderer(EntityRendererProvider.Context context) {
        super(context, new PlayerModel(context.m_174023_(ModEntitiesRender.GENERIC_BIPED), false), new PlayerModel(context.m_174023_(ModEntitiesRender.GENERIC_BIPED_SLIM), true), 0.5f);
        this.m_115326_(new PlayerBodyOverlayLayer(this));
        this.m_115326_(new HunterEquipmentLayer(this, context.m_174027_(), minion -> minion.m_6844_(EquipmentSlot.MAINHAND).m_41619_() ? (minion.m_6844_(EquipmentSlot.OFFHAND).m_41619_() ? HunterEquipmentModel.StakeType.FULL : HunterEquipmentModel.StakeType.AXE_ONLY) : HunterEquipmentModel.StakeType.NONE, e -> HunterEquipmentModel.HatType.from(e.getHatType())));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModEntitiesRender.GENERIC_BIPED_ARMOR_INNER)), new HumanoidModel(context.m_174023_(ModEntitiesRender.GENERIC_BIPED_ARMOR_OUTER))));
    }

    public int getHunterTextureCount() {
        return this.textures.length;
    }

    public int getMinionSpecificTextureCount() {
        return this.minionSpecificTextures.length;
    }

    @Override
    protected Pair<ResourceLocation, Boolean> determineTextureAndModel(HunterMinionEntity entity) {
        Pair<ResourceLocation, Boolean> p;
        Pair<ResourceLocation, Boolean> pair = p = entity.hasMinionSpecificSkin() && this.minionSpecificTextures.length > 0 ? this.minionSpecificTextures[entity.getHunterType() % this.minionSpecificTextures.length] : this.textures[entity.getHunterType() % this.textures.length];
        if (entity.shouldRenderLordSkin()) {
            return entity.getOverlayPlayerProperties().map(Pair::getRight).map(b -> Pair.of((Object)((ResourceLocation)p.getLeft()), (Object)b)).orElse(p);
        }
        return p;
    }

    @Override
    protected void renderSelected(HunterMinionEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ((PlayerModel)this.f_115290_).f_102816_ = entityIn.isSwingingArms() ? HumanoidModel.ArmPose.CROSSBOW_HOLD : HumanoidModel.ArmPose.ITEM;
        super.renderSelected(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void scale(HunterMinionEntity entityIn, PoseStack matrixStackIn, float partialTickTime) {
        float s = entityIn.m_6134_();
        matrixStackIn.m_85841_(s, s, s);
    }

    protected void renderNameTag(@Nonnull HunterMinionEntity pEntity, @Nonnull Component pDisplayName, PoseStack pMatrixStack, @Nonnull MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, (double)0.4f, 0.0);
        super.m_7649_((Entity)pEntity, pDisplayName, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }
}

