/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DualBipedRenderer<T extends Mob, M extends HumanoidModel<T>>
extends HumanoidMobRenderer<T, M> {
    private final M modelA;
    private final M modelB;
    private ResourceLocation currentTexture;

    public DualBipedRenderer(EntityRendererProvider.Context context, M modelBipedInA, M modelBipedInB, float shadowSize) {
        super(context, modelBipedInA, shadowSize);
        this.modelA = modelBipedInA;
        this.modelB = modelBipedInB;
    }

    @Nonnull
    public ResourceLocation m_5478_(@Nonnull T entity) {
        return this.currentTexture != null ? this.currentTexture : super.m_5478_(entity);
    }

    public final void m_7392_(@Nonnull T entityIn, float entityYaw, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn) {
        Pair<ResourceLocation, Boolean> b = this.determineTextureAndModel(entityIn);
        this.currentTexture = (ResourceLocation)b.getLeft();
        this.f_115290_ = (Boolean)b.getRight() != false ? this.modelB : this.modelA;
        this.renderSelected(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected abstract Pair<ResourceLocation, Boolean> determineTextureAndModel(T var1);

    protected void renderSelected(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected Pair<ResourceLocation, Boolean>[] separateSlimTextures(Stream<ResourceLocation> set) {
        return (Pair[])set.map(r -> {
            boolean b = r.m_135815_().endsWith("slim.png");
            return Pair.of((Object)r, (Object)b);
        }).toArray(Pair[]::new);
    }

    protected Pair<ResourceLocation, Boolean>[] gatherTextures(String dirPath, boolean required) {
        ArrayList hunterTextures = new ArrayList(Minecraft.m_91087_().m_91098_().m_6540_(dirPath, s -> s.endsWith(".png")));
        Pair<ResourceLocation, Boolean>[] textures = this.separateSlimTextures(hunterTextures.stream().filter(r -> "vampirism".equals(r.m_135827_())));
        if (textures.length == 0 && required) {
            throw new IllegalStateException("Must have at least one hunter texture: vampirism:" + dirPath + "/texture.png");
        }
        return textures;
    }
}

