/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.armor;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.armor.VampirismArmorModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClothingBootsModel
extends VampirismArmorModel {
    private static final String RIGHT_BOOT = "right_boot";
    private static final String RIGHT_TOES = "right_toes";
    private static final String LEFT_BOOT = "left_boot";
    private static final String LEFT_TOES = "left_toes";
    private static ClothingBootsModel instance;
    public ModelPart rightBoot;
    public ModelPart leftBoot;
    public ModelPart leftToes;
    public ModelPart rightToes;

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        CubeDeformation scale = new CubeDeformation(0.4f);
        part.m_171599_(RIGHT_BOOT, CubeListBuilder.m_171558_().m_171488_(-2.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, scale), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        part.m_171599_(RIGHT_TOES, CubeListBuilder.m_171558_().m_171514_(2, 9).m_171488_(-2.0f, 10.0f, -4.0f, 4.0f, 2.0f, 2.0f, scale), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        part.m_171599_(LEFT_BOOT, CubeListBuilder.m_171558_().m_171514_(16, 0).m_171488_(-2.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, scale), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        part.m_171599_(LEFT_TOES, CubeListBuilder.m_171558_().m_171514_(18, 9).m_171488_(-2.0f, 10.0f, -4.0f, 4.0f, 2.0f, 2.0f, scale), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)16);
    }

    public static ClothingBootsModel getAdjustedInstance(HumanoidModel<?> wearerModel) {
        if (instance == null) {
            instance = new ClothingBootsModel(Minecraft.m_91087_().m_167973_().m_171103_(ModEntitiesRender.CLOTHING_BOOTS));
        }
        instance.copyFromHumanoid(wearerModel);
        return instance;
    }

    public ClothingBootsModel(ModelPart part) {
        this.rightBoot = part.m_171324_(RIGHT_BOOT);
        this.rightToes = part.m_171324_(RIGHT_TOES);
        this.leftBoot = part.m_171324_(LEFT_BOOT);
        this.leftToes = part.m_171324_(LEFT_TOES);
    }

    @Override
    protected Iterable<ModelPart> getLeftLegModels() {
        return ImmutableList.of((Object)this.leftBoot, (Object)this.leftToes);
    }

    @Override
    protected Iterable<ModelPart> getRightLegModels() {
        return ImmutableList.of((Object)this.rightBoot, (Object)this.rightToes);
    }
}

