/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;

public class BaronessAttireModel
extends EntityModel<VampireBaronEntity> {
    private static final String VEIL = "veil";
    private static final String DRESS_ARM_LEFT = "dress_arm_left";
    private static final String DRESS_ARM_RIGHT = "dress_arm_right";
    private static final String DRESS_CURTAIN = "dress_curtain";
    private static final String HOOD = "hood";
    private static final String HAT = "hat";
    private static final String HAT2 = "hat2";
    private static final String DRESS_TORSO = "dress_torso";
    private static final String CLOAK = "cloak";
    public ModelPart dressTorso;
    public ModelPart dressArmBandRight;
    public ModelPart dressArmBandLeft;
    public ModelPart hat;
    public ModelPart hood;
    public ModelPart dressCurtain;
    public ModelPart hat2;
    public ModelPart veil;
    public ModelPart cloak;
    private float enragedProgress = 0.0f;

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        PartDefinition hat = part.m_171599_(HAT, CubeListBuilder.m_171558_().m_171514_(68, 36).m_171481_(-3.0f, -8.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.f_171404_);
        PartDefinition hood = part.m_171599_(HOOD, CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-4.5f, -8.5f, -4.0f, 9.0f, 9.0f, 9.0f), PartPose.f_171404_);
        PartDefinition dressTorso = part.m_171599_(DRESS_TORSO, CubeListBuilder.m_171558_().m_171514_(72, 30).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.4f)), PartPose.f_171404_);
        hat.m_171599_(VEIL, CubeListBuilder.m_171558_().m_171514_(32, 28).m_171481_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.f_171404_);
        part.m_171599_(DRESS_ARM_LEFT, CubeListBuilder.m_171558_().m_171514_(60, 46).m_171488_(0.0f, 2.0f, -2.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)4.0f, (float)2.0f, (float)0.0f));
        dressTorso.m_171599_(DRESS_CURTAIN, CubeListBuilder.m_171558_().m_171514_(64, 43).m_171481_(-6.0f, 0.0f, -4.0f, 12.0f, 11.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        hat.m_171599_(HAT2, CubeListBuilder.m_171558_().m_171514_(72, 30).m_171481_(-2.0f, -11.0f, -2.0f, 4.0f, 2.0f, 4.0f), PartPose.f_171404_);
        hood.m_171599_(CLOAK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.5f, -1.0f, -2.5f, 17.0f, 22.0f, 5.0f), PartPose.m_171430_((float)0.31415927f, (float)0.0f, (float)0.0f));
        part.m_171599_(DRESS_ARM_RIGHT, CubeListBuilder.m_171558_().m_171514_(60, 46).m_171488_(-3.0f, 2.0f, -2.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-4.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public BaronessAttireModel(ModelPart part) {
        this.dressTorso = part.m_171324_(DRESS_TORSO);
        this.dressArmBandLeft = part.m_171324_(DRESS_ARM_LEFT);
        this.dressArmBandRight = part.m_171324_(DRESS_ARM_RIGHT);
        this.hat = part.m_171324_(HAT);
        this.hood = part.m_171324_(HOOD);
        this.dressCurtain = this.dressTorso.m_171324_(DRESS_CURTAIN);
        this.hat2 = this.hat.m_171324_(HAT2);
        this.veil = this.hat.m_171324_(VEIL);
        this.cloak = this.hood.m_171324_(CLOAK);
    }

    public void prepareMobModel(VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.enragedProgress = entityIn.getEnragedProgress();
    }

    public void m_7695_(@Nonnull PoseStack matrixStackIn, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.dressArmBandLeft.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.dressArmBandRight.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.dressTorso.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.hat.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(1.0f - 0.5f * this.enragedProgress, 1.0f - 0.7f * this.enragedProgress, 1.0f - 0.5f * this.enragedProgress);
        this.hood.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.m_85849_();
    }

    public void setRotateAngle(ModelPart renderer, float x, float y, float z) {
        renderer.f_104203_ = x;
        renderer.f_104204_ = y;
        renderer.f_104205_ = z;
    }

    public void setupAnim(@Nonnull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float bodyRotateY = 0.0f;
        float headRotateY = 0.0f;
        headRotateY = netHeadYaw * ((float)Math.PI / 180);
        if (this.f_102608_ > 0.0f) {
            HumanoidArm handside = this.getSwingingSide(entityIn);
            float f1 = this.f_102608_;
            bodyRotateY = Mth.m_14031_((float)(Mth.m_14116_((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (handside == HumanoidArm.LEFT) {
                bodyRotateY *= -1.0f;
            }
        }
        this.hat.f_104204_ = bodyRotateY + headRotateY;
        this.veil.f_104204_ = bodyRotateY + headRotateY;
        this.hood.f_104204_ = bodyRotateY + headRotateY;
        this.hat2.f_104204_ = bodyRotateY + headRotateY;
        this.cloak.f_104204_ = bodyRotateY;
        this.dressCurtain.f_104204_ = bodyRotateY;
        this.dressTorso.f_104204_ = bodyRotateY;
        this.dressArmBandLeft.f_104204_ = bodyRotateY;
        this.dressArmBandRight.f_104204_ = bodyRotateY;
    }

    protected HumanoidArm getSwingingSide(VampireBaronEntity entity) {
        HumanoidArm handside = entity.m_5737_();
        return entity.f_20912_ == InteractionHand.MAIN_HAND ? handside : handside.m_20828_();
    }
}

