/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.widget;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWithDummyWidget;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.client.gui.ExtendedScreen;
import de.teamlapen.vampirism.inventory.container.TaskContainer;
import de.teamlapen.vampirism.player.tasks.req.ItemRequirement;
import de.teamlapen.vampirism.player.tasks.reward.ItemRewardInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.gui.GuiUtils;

public class TaskItem<T extends Screen>
extends ScrollableListWithDummyWidget.ListItem<ITaskInstance> {
    protected static final ResourceLocation TASKMASTER_GUI_TEXTURE = new ResourceLocation("vampirism", "textures/gui/taskmaster.png");
    protected static final Component REWARD = new TranslatableComponent("gui.vampirism.taskmaster.reward").m_130940_(ChatFormatting.UNDERLINE);
    protected static final Component REQUIREMENT = new TranslatableComponent("gui.vampirism.taskmaster.requirement").m_130940_(ChatFormatting.UNDERLINE);
    protected static final Component REQUIREMENT_STRIKE = REQUIREMENT.m_6879_().m_130940_(ChatFormatting.STRIKETHROUGH);
    protected static final ItemStack SKULL_ITEM = new ItemStack((ItemLike)Blocks.f_50310_);
    protected static final ItemStack PAPER = new ItemStack((ItemLike)Items.f_42516_);
    protected final T screen;
    protected final IFactionPlayer<?> factionPlayer;
    private final TaskActionButton taskButton;
    private final Map<ITaskInstance, List<Component>> toolTips = Maps.newHashMap();

    public TaskItem(ITaskInstance item, ScrollableListWithDummyWidget<ITaskInstance> list, boolean isDummy, T screen, IFactionPlayer<?> factionPlayer) {
        super(item, list, isDummy);
        this.screen = screen;
        this.factionPlayer = factionPlayer;
        this.taskButton = isDummy ? new TaskActionButton(0, 0) : null;
    }

    public List<Component> getTooltipFromItem2(ItemStack itemStack, boolean strikeThough, @Nullable String bonus) {
        List list = itemStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        ArrayList list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                MutableComponent t = ((Component)list.get(0)).m_6881_().m_130946_(" " + (bonus != null ? bonus : "") + itemStack.m_41613_());
                if (strikeThough) {
                    t.m_130940_(ChatFormatting.STRIKETHROUGH);
                }
                list1.add(t);
                continue;
            }
            list1.add(strikeThough ? ((Component)list.get(i)).m_6881_().m_130940_(ChatFormatting.STRIKETHROUGH) : (Component)list.get(i));
        }
        return list1;
    }

    @Override
    public boolean onDummyClick(double mouseX, double mouseY) {
        this.taskButton.m_5716_(mouseX, mouseY);
        return true;
    }

    @Override
    public void renderDummy(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
        RenderSystem.m_69482_();
        GuiUtils.drawContinuousTexturedBox((PoseStack)matrixStack, (ResourceLocation)TASKMASTER_GUI_TEXTURE, (int)x, (int)y, (int)17, (int)208, (int)listWidth, (int)itemHeight, (int)136, (int)21, (int)3, (int)3, (int)3, (int)3, (float)zLevel);
        RenderSystem.m_69465_();
        ITaskRewardInstance reward = ((ITaskInstance)this.item).getReward();
        if (reward instanceof ItemRewardInstance) {
            ItemStack stack = ((ItemRewardInstance)reward).getReward();
            ((ExtendedScreen)this.screen).getItemRenderer().m_115203_(stack, x + 3 + 113 - 21, y + 2);
            ((ExtendedScreen)this.screen).getItemRenderer().m_115174_(((Screen)this.screen).f_96547_, stack, x + 3 + 113 - 21, y + 2, "" + Math.min(stack.m_41613_(), stack.m_41741_()));
        } else {
            ((ExtendedScreen)this.screen).getItemRenderer().m_115203_(PAPER, x + 3 + 113 - 21, y + 2);
        }
        List<TaskRequirement.Requirement<?>> requirements = ((ITaskInstance)this.item).getTask().getRequirement().getAll();
        block4: for (int i = 0; i < requirements.size(); ++i) {
            TaskRequirement.Requirement<?> requirement = requirements.get(i);
            switch (requirement.getType()) {
                case ITEMS: {
                    ItemStack stack = ((ItemRequirement)requirement).getItemStack();
                    ((ExtendedScreen)this.screen).getItemRenderer().m_115203_(stack, x + 3 + 3 + i * 20, y + 2);
                    ((ExtendedScreen)this.screen).getItemRenderer().m_115174_(((Screen)this.screen).f_96547_, stack, x + 3 + 3 + i * 20, y + 2, "" + Math.min(stack.m_41613_(), stack.m_41741_()));
                    continue block4;
                }
                case ENTITY: 
                case ENTITY_TAG: {
                    ((ExtendedScreen)this.screen).getItemRenderer().m_115203_(SKULL_ITEM, x + 3 + 3 + i * 20, y + 2);
                    ((ExtendedScreen)this.screen).getItemRenderer().m_115174_(((Screen)this.screen).f_96547_, SKULL_ITEM, x + 3 + 3 + i * 20, y + 2, "" + requirement.getAmount(this.factionPlayer));
                    continue block4;
                }
                default: {
                    ((ExtendedScreen)this.screen).getItemRenderer().m_115203_(PAPER, x + 3 + 3 + i * 20, y + 2);
                }
            }
        }
        this.taskButton.f_93620_ = x + listWidth - 17;
        this.taskButton.f_93621_ = y + 4;
        this.taskButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderDummyToolTip(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
        if (mouseX >= x + 3 + 113 - 21 + 1 && mouseX < x + 3 + 113 - 21 + 16 + 1 && mouseY >= y + 2 && mouseY < y + 2 + 16) {
            ITaskRewardInstance reward = ((ITaskInstance)this.item).getReward();
            if (reward instanceof ItemRewardInstance) {
                this.renderItemTooltip(matrixStack, ((ItemRewardInstance)reward).getReward(), mouseX, mouseY, REWARD, false, null);
            } else {
                this.renderItemTooltip(matrixStack, ((ITaskInstance)this.item).getTask(), mouseX, mouseY);
            }
        }
        List<TaskRequirement.Requirement<?>> requirements = ((ITaskInstance)this.item).getTask().getRequirement().getAll();
        for (int i = 0; i < requirements.size(); ++i) {
            if (mouseX < x + 3 + 3 + i * 20 || mouseX >= x + 3 + 16 + 3 + i * 20 || mouseY < y + 2 || mouseY >= y + 2 + 16) continue;
            this.renderRequirementTool(matrixStack, (ITaskInstance)this.item, requirements.get(i), mouseX, mouseY);
        }
        this.taskButton.m_7428_(matrixStack, mouseX, mouseY);
    }

    @Override
    public void renderItem(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
        RenderSystem.m_69482_();
        TaskContainer container = ((ExtendedScreen)this.screen).getTaskContainer();
        if (container.isCompleted((ITaskInstance)this.item)) {
            RenderSystem.m_157429_((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        } else {
            boolean remainsTime;
            boolean isUnique = ((ITaskInstance)this.item).isUnique();
            boolean bl = remainsTime = ((ITaskInstance)this.item).getTaskTimeStamp() - Minecraft.m_91087_().f_91073_.m_46467_() > 0L;
            if (container.canCompleteTask((ITaskInstance)this.item)) {
                if (isUnique) {
                    RenderSystem.m_157429_((float)1.0f, (float)0.8558594f, (float)0.0f, (float)1.0f);
                } else {
                    RenderSystem.m_157429_((float)0.0f, (float)0.9f, (float)0.0f, (float)1.0f);
                }
            } else if (container.isTaskNotAccepted((ITaskInstance)this.item)) {
                if (isUnique) {
                    RenderSystem.m_157429_((float)0.64f, (float)0.57f, (float)0.5f, (float)1.0f);
                } else {
                    RenderSystem.m_157429_((float)0.55f, (float)0.55f, (float)0.55f, (float)1.0f);
                }
            } else if (!isUnique && !remainsTime) {
                RenderSystem.m_157429_((float)1.0f, (float)0.33333334f, (float)0.33333334f, (float)1.0f);
            } else if (isUnique) {
                RenderSystem.m_157429_((float)1.0f, (float)0.9f, (float)0.6f, (float)1.0f);
            } else {
                RenderSystem.m_157429_((float)0.85f, (float)1.0f, (float)0.85f, (float)1.0f);
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TASKMASTER_GUI_TEXTURE);
        GuiComponent.m_93143_((PoseStack)matrixStack, (int)x, (int)y, (int)this.screen.m_93252_(), (float)17.0f, (float)187.0f, (int)136, (int)21, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)matrixStack, (int)(x + 132), (int)y, (int)this.screen.m_93252_(), (float)150.0f, (float)187.0f, (int)3, (int)21, (int)256, (int)256);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Optional<FormattedCharSequence> text = Optional.ofNullable((FormattedCharSequence)((Screen)this.screen).f_96547_.m_92923_((FormattedText)((ITaskInstance)this.item).getTask().getTranslation(), 131).get(0));
        text.ifPresent(t -> ((Screen)this.screen).f_96547_.m_92877_(matrixStack, t, (float)(x + 2), (float)(y + 4), 3419941));
        if (!((ExtendedScreen)this.screen).getTaskContainer().isTaskNotAccepted((ITaskInstance)this.item) && !((ITaskInstance)this.item).isUnique()) {
            TranslatableComponent msg;
            long remainingTime = ((ITaskInstance)this.item).getTaskTimeStamp() - Minecraft.m_91087_().f_91073_.m_46467_();
            if (remainingTime >= 0L) {
                long hours = (remainingTime /= 20L) / 60L / 60L;
                long minutes = remainingTime / 60L % 60L;
                long seconds = remainingTime % 60L;
                String time = hours + ":";
                if (minutes < 10L) {
                    time = time + "0";
                }
                time = time + minutes + ":";
                if (seconds < 10L) {
                    time = time + "0";
                }
                time = time + seconds;
                msg = new TextComponent(time);
            } else {
                msg = new TranslatableComponent("text.vampirism.task_failed");
            }
            int width = ((Screen)this.screen).f_96547_.m_92852_((FormattedText)msg);
            int color = 0xAAAAAA;
            if ((float)remainingTime < (float)((ITaskInstance)this.item).getTaskDuration() / 20.0f * 0.1f) {
                color = 0xFF5555;
            }
            ((Screen)this.screen).f_96547_.m_92763_(matrixStack, (Component)msg, (float)(x + 134 - width), (float)(y + 12), color);
        }
        RenderSystem.m_69465_();
    }

    @Override
    public void renderItemToolTip(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
        List<Component> toolTips = this.toolTips.getOrDefault(this.item, Lists.newArrayList());
        if (toolTips.isEmpty()) {
            this.generateTaskToolTip((ITaskInstance)this.item, toolTips);
        }
        this.screen.m_96597_(matrixStack, toolTips, mouseX, mouseY);
    }

    private void clickButton(Button id) {
        ((ExtendedScreen)this.screen).getTaskContainer().pressButton((ITaskInstance)this.item);
    }

    private void generateTaskToolTip(ITaskInstance taskInfo, List<Component> toolTips) {
        Task task = taskInfo.getTask();
        toolTips.clear();
        toolTips.add((Component)task.getTranslation().m_6879_().m_130938_(style -> style.m_131148_(((ExtendedScreen)this.screen).getTaskContainer().getFactionColor())));
        if (task.useDescription()) {
            toolTips.add(task.getDescription());
            toolTips.add((Component)new TextComponent(" "));
        }
        if (((ExtendedScreen)this.screen).getTaskContainer().isTaskNotAccepted(taskInfo)) {
            toolTips.add((Component)new TranslatableComponent("gui.vampirism.taskmaster.not_accepted"));
        } else {
            for (List<TaskRequirement.Requirement<?>> requirements : task.getRequirement().requirements().values()) {
                if (requirements == null) continue;
                TaskRequirement.Type type = requirements.get(0).getType();
                boolean completed = ((ExtendedScreen)this.screen).getTaskContainer().areRequirementsCompleted(taskInfo, type);
                MutableComponent title = new TranslatableComponent(type.getTranslationKey()).m_130946_(":");
                if (completed) {
                    title.m_130940_(ChatFormatting.STRIKETHROUGH);
                }
                toolTips.add((Component)title);
                for (TaskRequirement.Requirement<?> requirement : requirements) {
                    TranslatableComponent desc;
                    int completedAmount = ((ExtendedScreen)this.screen).getTaskContainer().getRequirementStatus(taskInfo, requirement);
                    switch (type) {
                        case ITEMS: {
                            TranslatableComponent translatableComponent = ((Item)requirement.getStat(this.factionPlayer)).m_41466_().m_6879_().m_130946_(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        case STATS: {
                            TranslatableComponent translatableComponent = new TranslatableComponent("stat." + requirement.getStat(this.factionPlayer).toString().replace(':', '.')).m_130946_(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        case ENTITY: {
                            TranslatableComponent translatableComponent = ((EntityType)requirement.getStat(this.factionPlayer)).m_20676_().m_6879_().m_130946_(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        case ENTITY_TAG: {
                            TranslatableComponent translatableComponent = new TranslatableComponent("tasks.vampirism." + ((TagKey)requirement.getStat(this.factionPlayer)).f_203868_()).m_130946_(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        default: {
                            TranslatableComponent translatableComponent = desc = new TranslatableComponent(task.getTranslationKey() + ".req." + requirement.getId().toString().replace(':', '.'));
                        }
                    }
                    if (completed || ((ExtendedScreen)this.screen).getTaskContainer().isRequirementCompleted(taskInfo, requirement)) {
                        desc.m_130940_(ChatFormatting.STRIKETHROUGH);
                    }
                    toolTips.add((Component)new TextComponent("  ").m_7220_((Component)desc));
                }
            }
        }
        this.toolTips.put(taskInfo, toolTips);
    }

    private void renderDefaultRequirementToolTip(PoseStack mStack, ITaskInstance task, TaskRequirement.Requirement<?> requirement, int x, int y, boolean strikeThrough) {
        ArrayList tooltips = Lists.newArrayList();
        tooltips.add(strikeThrough ? REQUIREMENT_STRIKE : REQUIREMENT);
        TranslatableComponent text = new TranslatableComponent(task.getTask().getTranslationKey() + ".req." + requirement.getId().toString().replace(':', '.'));
        if (strikeThrough) {
            text.m_130940_(ChatFormatting.STRIKETHROUGH);
        }
        tooltips.add(text);
        this.screen.m_96597_(mStack, (List)tooltips, x, y);
    }

    private void renderGenericRequirementTooltip(PoseStack mStack, TaskRequirement.Type type, int x, int y, MutableComponent text, boolean strikeThrough) {
        ArrayList tooltips = Lists.newArrayList();
        MutableComponent title = new TranslatableComponent(type.getTranslationKey()).m_130946_(":");
        if (strikeThrough) {
            text.m_130940_(ChatFormatting.STRIKETHROUGH);
            title.m_130940_(ChatFormatting.STRIKETHROUGH);
        }
        tooltips.add(strikeThrough ? REQUIREMENT_STRIKE : REQUIREMENT);
        tooltips.add(title.m_130940_(ChatFormatting.ITALIC));
        tooltips.add(new TextComponent("  ").m_7220_((Component)text));
        this.screen.m_96597_(mStack, (List)tooltips, x, y);
    }

    private void renderItemTooltip(PoseStack mStack, ItemStack stack, int x, int y, Component text, boolean strikeThrough, @Nullable String bonus) {
        List<Component> tooltips = this.getTooltipFromItem2(stack, strikeThrough, bonus);
        tooltips.add(0, text);
        this.screen.m_96597_(mStack, tooltips, x, y);
    }

    private void renderItemTooltip(PoseStack mStack, Task task, int x, int y) {
        ArrayList tooltips = Lists.newArrayList((Object[])new Component[]{REWARD});
        tooltips.add(new TranslatableComponent(task.getTranslationKey() + ".reward"));
        this.screen.m_96597_(mStack, (List)tooltips, x, y);
    }

    private void renderRequirementTool(PoseStack mStack, ITaskInstance task, TaskRequirement.Requirement<?> requirement, int x, int y) {
        boolean notAccepted = ((ExtendedScreen)this.screen).getTaskContainer().isTaskNotAccepted((ITaskInstance)this.item);
        boolean completed = ((ExtendedScreen)this.screen).getTaskContainer().isRequirementCompleted((ITaskInstance)this.item, requirement);
        int completedAmount = ((ExtendedScreen)this.screen).getTaskContainer().getRequirementStatus((ITaskInstance)this.item, requirement);
        switch (requirement.getType()) {
            case ITEMS: {
                this.renderItemTooltip(mStack, ((ItemRequirement)requirement).getItemStack(), x, y, completed ? REQUIREMENT_STRIKE : REQUIREMENT, completed, notAccepted ? null : completedAmount + "/");
                break;
            }
            case ENTITY: {
                this.renderGenericRequirementTooltip(mStack, TaskRequirement.Type.ENTITY, x, y, ((EntityType)requirement.getStat(this.factionPlayer)).m_20676_().m_6879_().m_130946_((String)(notAccepted ? " " : " " + completedAmount + "/") + requirement.getAmount(this.factionPlayer)), completed);
                break;
            }
            case ENTITY_TAG: {
                this.renderGenericRequirementTooltip(mStack, TaskRequirement.Type.ENTITY_TAG, x, y, new TranslatableComponent("tasks.vampirism." + ((TagKey)requirement.getStat(this.factionPlayer)).f_203868_()).m_130946_((String)(notAccepted ? " " : " " + completedAmount + "/") + requirement.getAmount(this.factionPlayer)), completed);
                break;
            }
            case STATS: {
                this.renderGenericRequirementTooltip(mStack, TaskRequirement.Type.STATS, x, y, new TranslatableComponent("stat." + requirement.getStat(this.factionPlayer).toString().replace(':', '.')).m_130946_((String)(notAccepted ? " " : " " + completedAmount + "/") + requirement.getAmount(this.factionPlayer)), completed);
                break;
            }
            default: {
                this.renderDefaultRequirementToolTip(mStack, task, requirement, x, y, completed);
            }
        }
    }

    private class TaskActionButton
    extends ImageButton {
        public TaskActionButton(int xPos, int yPos) {
            super(xPos, yPos, 14, 13, 0, 0, 0, TASKMASTER_GUI_TEXTURE, 0, 0, TaskItem.this::clickButton, (Component)new TextComponent(""));
        }

        public void m_5716_(double mouseX, double mouseY) {
            if (mouseX > (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY > (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_)) {
                super.m_5716_(mouseX, mouseY);
            }
        }

        public void m_6303_(@Nonnull PoseStack mStack, int mouseX, int mouseY, float p_renderButton_3_) {
            TaskContainer.TaskAction action = ((ExtendedScreen)TaskItem.this.screen).getTaskContainer().buttonAction((ITaskInstance)TaskItem.this.item);
            RenderSystem.m_69482_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)TASKMASTER_GUI_TEXTURE);
            int j = switch (action) {
                case TaskContainer.TaskAction.ACCEPT -> 190;
                case TaskContainer.TaskAction.COMPLETE -> 176;
                default -> 204;
            };
            TaskActionButton.m_93133_((PoseStack)mStack, (int)this.f_93620_, (int)this.f_93621_, (float)j, (float)(this.f_93622_ ? 13 : 0), (int)this.f_93618_, (int)this.f_93619_, (int)256, (int)256);
            RenderSystem.m_69465_();
        }

        public void m_7428_(@Nonnull PoseStack mStack, int mouseX, int mouseY) {
            if (this.f_93622_ && this.f_93624_) {
                TaskContainer.TaskAction action = ((ExtendedScreen)TaskItem.this.screen).getTaskContainer().buttonAction((ITaskInstance)TaskItem.this.item);
                TaskItem.this.screen.m_96602_(mStack, (Component)new TranslatableComponent(action.getTranslationKey()), mouseX, mouseY);
            }
        }
    }
}

