/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWidget;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWithDummyWidget;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.ActionSelectScreen;
import de.teamlapen.vampirism.client.gui.ExtendedScreen;
import de.teamlapen.vampirism.client.gui.SkillsScreen;
import de.teamlapen.vampirism.client.gui.VampirePlayerAppearanceScreen;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.container.TaskContainer;
import de.teamlapen.vampirism.inventory.container.VampirismContainer;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.util.Helper;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class VampirismScreen
extends AbstractContainerScreen<VampirismContainer>
implements ExtendedScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/vampirism_menu.png");
    private static final ResourceLocation BACKGROUND_REFINEMENTS = new ResourceLocation("vampirism", "textures/gui/vampirism_menu_refinements.png");
    private static final int display_width = 234;
    private static final int display_height = 205;
    private final IFactionPlayer<?> factionPlayer;
    private int oldMouseX;
    private int oldMouseY;
    private ScrollableListWidget<ITaskInstance> list;
    private final Map<Integer, Button> refinementRemoveButtons = new Int2ObjectOpenHashMap(3);

    public VampirismScreen(VampirismContainer container, Inventory playerInventory, Component titleIn) {
        super((AbstractContainerMenu)container, playerInventory, titleIn);
        this.f_97726_ = 234;
        this.f_97727_ = 205;
        this.f_97730_ = 36;
        this.f_97731_ = this.f_97727_ - 93;
        ((VampirismContainer)this.f_97732_).setReloadListener(() -> this.list.refresh());
        this.factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer(playerInventory.f_35978_).orElseThrow(() -> new IllegalStateException("Cannot open Vampirism container without faction player"));
    }

    @Override
    public ItemRenderer getItemRenderer() {
        return this.f_96542_;
    }

    @Override
    public TaskContainer getTaskContainer() {
        return (TaskContainer)this.f_97732_;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (ModKeys.VAMPIRISM_MENU.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        if (!this.f_97738_) {
            this.list.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public Collection<ITaskInstance> refreshTasks() {
        return ((VampirismContainer)this.f_97732_).getTaskInfos();
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (((VampirismContainer)this.f_97732_).areRefinementsAvailable()) {
            for (int i = 0; i < ((VampirismContainer)this.f_97732_).getRefinementStacks().size(); ++i) {
                ItemStack stack = (ItemStack)((VampirismContainer)this.f_97732_).getRefinementStacks().get(i);
                Slot slot = ((VampirismContainer)this.f_97732_).m_38853_(i);
                int x = slot.f_40220_ + this.f_97735_;
                int y = slot.f_40221_ + this.f_97736_;
                this.f_96542_.m_115203_(stack, x, y);
                this.f_96542_.m_115174_(this.f_96547_, stack, x, y, null);
            }
        }
        if (this.list.isEmpty()) {
            MutableComponent text = new TranslatableComponent("gui.vampirism.vampirism_menu.no_tasks").m_130940_(ChatFormatting.WHITE);
            int width = this.f_96547_.m_92852_((FormattedText)text);
            this.f_96547_.m_92763_(matrixStack, (Component)text, (float)(this.f_97735_ + 152) - (float)width / 2.0f, (float)(this.f_97736_ + 52), 0);
        }
        this.renderAccessorySlots(matrixStack, mouseX, mouseY, partialTicks);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
        this.list.m_7428_(matrixStack, mouseX, mouseY);
        this.m_7025_(matrixStack, mouseX, mouseY);
        if (((VampirismContainer)this.f_97732_).areRefinementsAvailable()) {
            this.renderHoveredRefinementTooltip(matrixStack, mouseX, mouseY);
        }
    }

    protected void renderAccessorySlots(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (Slot slot : ((VampirismContainer)this.f_97732_).f_38839_) {
            if (!this.m_97774_(slot, mouseX, mouseY) || !(slot instanceof VampirismContainer.RemovingSelectorSlot) || ((ItemStack)((VampirismContainer)this.f_97732_).getRefinementStacks().get(slot.getSlotIndex())).m_41619_()) continue;
            this.refinementRemoveButtons.get(slot.getSlotIndex()).m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.list = new ScrollableListWithDummyWidget<ITaskInstance>(this.f_97735_ + 83, this.f_97736_ + 7, 145, 104, 21, this::refreshTasks, (item, list1, isDummy) -> new TaskItem((ITaskInstance)item, list1, isDummy, this, this.factionPlayer));
        this.m_142416_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 5, this.f_97736_ + 90, 20, 20, 40, 205, 20, BACKGROUND, 256, 256, context -> {
            if (this.f_96541_.f_91074_.m_6084_() && VampirismPlayerAttributes.get((Player)this.f_96541_.f_91074_).faction != null) {
                Minecraft.m_91087_().m_91152_(new SkillsScreen((Screen)this));
            }
        }, (button, matrixStack, mouseX, mouseY) -> this.m_96602_(matrixStack, (Component)new TranslatableComponent("gui.vampirism.vampirism_menu.skill_screen"), mouseX, mouseY), TextComponent.f_131282_));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 26, this.f_97736_ + 90, 20, 20, 0, 205, 20, BACKGROUND, 256, 256, context -> {
            IPlayableFaction<?> factionNew = VampirismPlayerAttributes.get((Player)this.f_96541_.f_91074_).faction;
            Minecraft.m_91087_().m_91152_(new ActionSelectScreen(new Color(factionNew.getColor()), true));
        }, (button, matrixStack, mouseX, mouseY) -> this.m_96602_(matrixStack, (Component)new TranslatableComponent("gui.vampirism.vampirism_menu.edit_actions"), mouseX, mouseY), TextComponent.f_131282_));
        Button appearanceButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 47, this.f_97736_ + 90, 20, 20, 20, 205, 20, BACKGROUND, 256, 256, context -> Minecraft.m_91087_().m_91152_((Screen)new VampirePlayerAppearanceScreen((Screen)this)), (button1, matrixStack, mouseX, mouseY) -> this.m_96602_(matrixStack, (Component)new TranslatableComponent("gui.vampirism.vampirism_menu.appearance_menu"), mouseX, mouseY), TextComponent.f_131282_));
        if (!Helper.isVampire((Player)this.f_96541_.f_91074_)) {
            appearanceButton.f_93623_ = false;
            appearanceButton.f_93624_ = false;
        }
        final NonNullList<ItemStack> refinementList = ((VampirismContainer)this.f_97732_).getRefinementStacks();
        for (final Slot slot : ((VampirismContainer)this.f_97732_).f_38839_) {
            if (!(slot instanceof VampirismContainer.RemovingSelectorSlot)) continue;
            Button xButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.getGuiLeft() + slot.f_40220_ + 16 - 5, this.getGuiTop() + slot.f_40221_ + 16 - 5, 5, 5, 60, 205, 0, BACKGROUND_REFINEMENTS, 256, 256, button -> {
                VampirismMod.dispatcher.sendToServer(new InputEventPacket("dr", IRefinementItem.AccessorySlotType.values()[slot.f_40219_].name()));
                refinementList.set(slot.f_40219_, (Object)ItemStack.f_41583_);
            }, (button12, matrixStack, xPos, yPos) -> this.m_96602_(matrixStack, (Component)new TranslatableComponent("gui.vampirism.vampirism_menu.destroy_item").m_130940_(ChatFormatting.RED), xPos, yPos), TextComponent.f_131282_){

                public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.f_93624_ = !((ItemStack)refinementList.get(slot.f_40219_)).m_41619_() && VampirismScreen.this.f_97711_.m_41619_() && this.overSlot(slot, mouseX, mouseY);
                    super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
                }

                private boolean overSlot(Slot slot2, int mouseX, int mouseY) {
                    return slot2.f_40220_ <= (mouseX -= VampirismScreen.this.f_97735_) && slot2.f_40220_ + 16 > mouseX && slot2.f_40221_ <= (mouseY -= VampirismScreen.this.f_97736_) && slot2.f_40221_ + 16 > mouseY;
                }
            });
            this.refinementRemoveButtons.put(slot.getSlotIndex(), xButton);
        }
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float v, int i, int i1) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)(((VampirismContainer)this.f_97732_).areRefinementsAvailable() ? BACKGROUND_REFINEMENTS : BACKGROUND));
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        InventoryScreen.m_98850_((int)(this.f_97735_ + 31), (int)(this.f_97736_ + 72), (int)30, (float)((float)(this.f_97735_ + 10) - (float)this.oldMouseX), (float)((float)(this.f_97736_ + 75 - 50) - (float)this.oldMouseY), (LivingEntity)this.f_96541_.f_91074_);
    }

    protected void renderHoveredRefinementTooltip(PoseStack matrixStack, int mouseX, int mouseY) {
        NonNullList<ItemStack> list;
        int index;
        if (this.f_97734_ != null && (index = this.f_97734_.f_40219_) < (list = ((VampirismContainer)this.f_97732_).getRefinementStacks()).size() && index >= 0) {
            if (((VampirismContainer)this.m_6262_()).m_142621_().m_41619_() && !((ItemStack)list.get(index)).m_41619_()) {
                if (!this.refinementRemoveButtons.get(this.f_97734_.getSlotIndex()).m_198029_()) {
                    this.m_6057_(matrixStack, (ItemStack)list.get(index), mouseX, mouseY);
                }
            } else if (!((ItemStack)list.get(index)).m_41619_() && ((VampirismContainer)this.f_97732_).m_38853_(index).m_5857_(((VampirismContainer)this.m_6262_()).m_142621_())) {
                this.m_96602_(matrixStack, (Component)new TranslatableComponent("gui.vampirism.vampirism_menu.destroy_item").m_130940_(ChatFormatting.RED), mouseX, mouseY);
            }
        }
    }

    private class TaskItem
    extends de.teamlapen.vampirism.client.gui.widget.TaskItem<VampirismScreen> {
        private ImageButton button;

        public TaskItem(ITaskInstance item, ScrollableListWithDummyWidget<ITaskInstance> list, boolean isDummy, VampirismScreen screen, IFactionPlayer<?> factionPlayer) {
            super(item, list, isDummy, screen, factionPlayer);
            if (!item.isUnique()) {
                this.button = new ImageButton(0, 0, 8, 11, 0, 229, 11, TASKMASTER_GUI_TEXTURE, 256, 256, this::onClick, this::onTooltip, TextComponent.f_131282_);
            }
        }

        @Override
        public boolean onClick(double mouseX, double mouseY) {
            if (this.button != null && !this.isDummy && mouseX > (double)this.button.f_93620_ && mouseX < (double)(this.button.f_93620_ + this.button.m_5711_()) && mouseY > (double)this.button.f_93621_ && mouseY < (double)(this.button.f_93621_ + this.button.m_93694_())) {
                this.button.m_5716_(mouseX, mouseY);
                return true;
            }
            return super.onClick(mouseX, mouseY);
        }

        @Override
        public void renderItem(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
            super.renderItem(matrixStack, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, partialTicks, zLevel);
            if (this.button != null) {
                this.button.f_93620_ = x + listWidth - 13;
                this.button.f_93621_ = y + 1;
                this.button.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public void renderItemToolTip(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
            if (this.button != null && this.button.m_198029_()) {
                this.button.m_7428_(matrixStack, mouseX, mouseY);
            } else {
                super.renderItemToolTip(matrixStack, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, zLevel);
            }
        }

        private float getDistance(int x1, int z1, int x2, int z2) {
            int i = x2 - x1;
            int j = z2 - z1;
            return Mth.m_14116_((float)(i * i + j * j));
        }

        private void onClick(Button button) {
            Player player = this.factionPlayer.getRepresentingPlayer();
            Component position = (Component)((VampirismContainer)((VampirismScreen)VampirismScreen.this).f_97732_).taskWrapper.get(((ITaskInstance)this.item).getTaskBoard()).getLastSeenPos().map(pos -> {
                int i = Mth.m_14143_((float)this.getDistance(player.m_142538_().m_123341_(), player.m_142538_().m_123343_(), pos.m_123341_(), pos.m_123343_()));
                MutableComponent itextcomponent = ComponentUtils.m_130748_((Component)new TranslatableComponent("chat.coordinates", new Object[]{pos.m_123341_(), "~", pos.m_123343_()})).m_130938_(p_241055_1_ -> p_241055_1_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.m_123341_() + " ~ " + pos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.coordinates.tooltip"))));
                return itextcomponent.m_7220_((Component)new TranslatableComponent("gui.vampirism.vampirism_menu.distance", new Object[]{i}));
            }).orElseGet(() -> new TranslatableComponent("gui.vampirism.vampirism_menu.last_known_pos.unknown").m_130940_(ChatFormatting.GOLD));
            player.m_5661_((Component)new TranslatableComponent("gui.vampirism.vampirism_menu.last_known_pos").m_7220_(position), false);
        }

        private void onTooltip(Button button, PoseStack matrixStack, int mouseX, int mouseY) {
            Component position = (Component)((VampirismContainer)((VampirismScreen)VampirismScreen.this).f_97732_).taskWrapper.get(((ITaskInstance)this.item).getTaskBoard()).getLastSeenPos().map(pos -> new TextComponent("[" + pos.m_123344_() + "]").m_130940_(ChatFormatting.GREEN)).orElseGet(() -> new TranslatableComponent("gui.vampirism.vampirism_menu.last_known_pos.unknown").m_130940_(ChatFormatting.GOLD));
            VampirismScreen.this.renderComponentTooltip(matrixStack, Collections.singletonList(new TranslatableComponent("gui.vampirism.vampirism_menu.last_known_pos").m_7220_(position)), mouseX, mouseY, VampirismScreen.this.f_96547_);
        }
    }
}

