/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.gui.MinionStatsScreen;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class VampireMinionStatsScreen
extends MinionStatsScreen<VampireMinionEntity.VampireMinionData, VampireMinionEntity> {
    private final TranslatableComponent inventoryLevel = new TranslatableComponent("text.vampirism.minion.stats.inventory_level");
    private final TranslatableComponent healthLevel = new TranslatableComponent(Attributes.f_22276_.m_22087_());
    private final TranslatableComponent strengthLevel = new TranslatableComponent(Attributes.f_22281_.m_22087_());
    private final TranslatableComponent speedLevel = new TranslatableComponent(Attributes.f_22279_.m_22087_());

    public VampireMinionStatsScreen(VampireMinionEntity entity, @Nullable Screen backScreen) {
        super(entity, 4, backScreen);
    }

    @Override
    protected boolean areButtonsVisible(VampireMinionEntity.VampireMinionData d) {
        return d.getRemainingStatPoints() > 0 || d.getLevel() < 6;
    }

    @Override
    protected int getRemainingStatPoints(VampireMinionEntity.VampireMinionData d) {
        return d.getRemainingStatPoints();
    }

    @Override
    protected boolean isActive(VampireMinionEntity.VampireMinionData data, int i) {
        return switch (i) {
            case 0 -> {
                if (data.getRemainingStatPoints() > 0 && data.getInventoryLevel() < 2) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (data.getRemainingStatPoints() > 0 && data.getHealthLevel() < 3) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (data.getRemainingStatPoints() > 0 && data.getStrengthLevel() < 3) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (data.getRemainingStatPoints() > 0 && data.getSpeedLevel() < 3) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    protected void renderStats(PoseStack mStack, VampireMinionEntity.VampireMinionData data) {
        this.renderLevelRow(mStack, data.getLevel() + 1, 7);
        this.renderStatRow(mStack, 0, this.inventoryLevel, new TextComponent("" + data.getInventorySize()), data.getInventoryLevel() + 1, 3);
        this.renderStatRow(mStack, 1, this.healthLevel, new TextComponent("" + ((VampireMinionEntity)this.entity).m_21051_(Attributes.f_22276_).m_22115_()), data.getHealthLevel() + 1, 4);
        this.renderStatRow(mStack, 2, this.strengthLevel, new TextComponent("" + ((VampireMinionEntity)this.entity).m_21051_(Attributes.f_22281_).m_22115_()), data.getStrengthLevel() + 1, 4);
        this.renderStatRow(mStack, 3, this.speedLevel, new TextComponent("" + ((VampireMinionEntity)this.entity).m_21051_(Attributes.f_22279_).m_22115_()), data.getSpeedLevel() + 1, 4);
    }
}

