/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.player.skills.ActionSkill;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.skills.SkillNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.GuiUtils;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class SkillsScreen<T extends IFactionPlayer<T>>
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/skills_window.png");
    private static final int area_min_y = -77;
    private static final int skill_width = 24;
    private static final int display_width = 256;
    private static final int display_height = 202;
    private final List<SkillNode> skillNodes = new ArrayList<SkillNode>();
    @Nullable
    private final Screen backScreen;
    private final Map<ISkill<?>, List<Component>> skillToolTipsCache = new HashMap();
    private int area_min_x = 0;
    private int area_max_x = 0;
    private int area_max_y;
    private float zoomOut = 1.0f;
    private double displayX;
    private double displayY;
    private double displayXNew;
    private double displayYNew;
    private SkillHandler<T> skillHandler;
    private boolean display;
    private ISkill<T> selected;
    private int displayXWidth;
    private int displayYHeight;
    @Nullable
    private Component lordTitle;
    private int lordLevel;
    private Button resetSkills;

    public SkillsScreen() {
        this(null);
    }

    public SkillsScreen(@Nullable Screen backScreen) {
        super((Component)new TranslatableComponent("screen.vampirism.skills"));
        this.f_96543_ = 256;
        this.f_96544_ = 202;
        this.backScreen = backScreen;
    }

    public void m_7856_() {
        int guiLeft = (this.f_96543_ - 256) / 2;
        int guiTop = (this.f_96544_ - 202) / 2;
        if (this.backScreen != null) {
            this.m_142416_((GuiEventListener)new Button(guiLeft + 5, guiTop + 175, 80, 20, (Component)new TranslatableComponent("gui.back"), context -> this.f_96541_.m_91152_(this.backScreen)));
        }
        this.m_142416_((GuiEventListener)new Button(guiLeft + 171, guiTop + 175, 80, 20, (Component)new TranslatableComponent("gui.done"), context -> this.f_96541_.m_91152_(null)));
        FactionPlayerHandler.getOpt((Player)this.f_96541_.f_91074_).ifPresent(fph -> {
            this.lordTitle = fph.getLordTitle();
            this.lordLevel = fph.getLordLevel();
            fph.getCurrentFactionPlayer().ifPresent(factionPlayer -> {
                IFaction faction = factionPlayer.getFaction();
                this.display = true;
                this.skillHandler = (SkillHandler)factionPlayer.getSkillHandler();
                Integer[] info = VampirismMod.proxy.getSkillTree(true).getDisplayInfo(faction.getID());
                int w = info[0] * info[1] * 24 * 2;
                this.area_max_x = w + 10 - 256;
                this.area_min_x = -w - 10 - 256;
                this.area_max_y = info[2] * 24 * 2;
                this.displayXNew = -100.0;
                this.displayX = -100.0;
                this.displayYNew = -10.0;
                this.displayY = -10.0;
                this.skillNodes.clear();
                SkillNode root = VampirismMod.proxy.getSkillTree(true).getRootNodeForFaction(faction.getID());
                this.addToList(this.skillNodes, root);
                boolean test = VampirismMod.inDev || VampirismMod.instance.getVersionInfo().getCurrentVersion().isTestVersion();
                this.resetSkills = (Button)this.m_142416_((GuiEventListener)new Button(guiLeft + 88, guiTop + 175, 80, 20, (Component)new TranslatableComponent("text.vampirism.skill.resetall"), context -> {
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("rs", ""));
                    InventoryHelper.removeItemFromInventory((Container)factionPlayer.getRepresentingPlayer().m_150109_(), new ItemStack((ItemLike)ModItems.oblivion_potion));
                    if (!(factionPlayer.getLevel() >= 2 && this.f_96541_.f_91074_.m_150109_().m_18947_((Item)ModItems.oblivion_potion) > 1 || test)) {
                        context.f_93623_ = false;
                    }
                }, (button, stack, mouseX, mouseY) -> {
                    if (button.f_93623_) {
                        this.m_96602_(stack, (Component)new TranslatableComponent("text.vampirism.skills.reset_consume", new Object[]{ModItems.oblivion_potion.m_41466_()}), mouseX, mouseY);
                    } else {
                        this.m_96602_(stack, (Component)new TranslatableComponent("text.vampirism.skills.reset_req", new Object[]{ModItems.oblivion_potion.m_41466_()}), mouseX, mouseY);
                    }
                }));
                if (!(factionPlayer.getLevel() >= 2 && this.f_96541_.f_91074_.m_150109_().m_18947_((Item)ModItems.oblivion_potion) > 0 || test)) {
                    this.resetSkills.f_93623_ = false;
                }
            });
        });
        this.displayXWidth = this.skillNodes.stream().flatMap(node -> Arrays.stream(node.getElements())).mapToInt(ISkill::getRenderColumn).max().orElse(0) * 25;
        this.displayYHeight = this.skillNodes.stream().flatMap(node -> Arrays.stream(node.getElements())).mapToInt(ISkill::getRenderRow).max().orElse(0) * 20;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256 || ModKeys.VAMPIRISM_MENU.getKey().m_84873_() == p_keyPressed_1_) {
            this.f_96541_.m_91152_(null);
            this.f_96541_.m_7440_(true);
            return true;
        }
        super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean retur = super.m_6375_(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && this.selected != null) {
            this.unlockSkill();
            return true;
        }
        return retur;
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        this.displayY -= p_mouseDragged_8_;
        this.displayX -= p_mouseDragged_6_;
        this.checkDisplay();
        return true;
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        this.zoomOut = (float)((double)this.zoomOut + (p_mouseScrolled_5_ > 0.0 ? -0.25 : 0.25));
        this.zoomOut = Mth.m_14036_((float)this.zoomOut, (float)1.0f, (float)2.0f);
        this.checkDisplay();
        return true;
    }

    public void m_6305_(@Nonnull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (!this.display) {
            super.m_6305_(stack, mouseX, mouseY, partialTicks);
            return;
        }
        this.m_7333_(stack);
        this.drawSkills(stack, mouseX, mouseY, partialTicks);
        this.drawDisableText(stack);
        this.drawTitle(stack);
    }

    public void resetToolTipCache() {
        this.skillToolTipsCache.clear();
    }

    public void m_96624_() {
        if (!this.f_96541_.f_91074_.m_6084_()) {
            this.f_96541_.f_91074_.m_6915_();
        }
    }

    protected void drawTitle(PoseStack stack) {
        Object title = this.lordTitle != null ? this.lordTitle.m_6881_().m_130946_(" (" + this.lordLevel + ")") : new TranslatableComponent("text.vampirism.skills.gui_title");
        int x = (this.f_96543_ - 256) / 2;
        int y = (this.f_96544_ - 202) / 2;
        this.f_96547_.m_92744_(stack, title.m_7532_(), (float)(x + 15), (float)(y + 5), -1);
        TranslatableComponent points = new TranslatableComponent("text.vampirism.skills.points_left", new Object[]{this.skillHandler.getLeftSkillPoints()});
        if (this.f_96541_.f_91074_.m_21124_(ModEffects.oblivion) != null) {
            points.m_130940_(ChatFormatting.DARK_RED);
        }
        x = (this.f_96543_ + 256) / 2 - this.f_96547_.m_92852_((FormattedText)points);
        this.f_96547_.m_92744_(stack, points.m_7532_(), (float)(x - 15), (float)(y + 5), -1);
    }

    private void addToList(List<SkillNode> list, SkillNode root) {
        list.add(root);
        for (SkillNode node : root.getChildren()) {
            this.addToList(list, node);
        }
    }

    private boolean canUnlockSkill() {
        return this.skillHandler.canSkillBeEnabled(this.selected) == ISkillHandler.Result.OK;
    }

    private void checkDisplay() {
        this.displayY = Mth.m_14008_((double)this.displayY, (double)(-20.0f / this.zoomOut), (double)((float)(this.displayYHeight - 20) / this.zoomOut));
        this.displayXNew = this.displayX = Mth.m_14008_((double)this.displayX, (double)((float)(-400 - this.displayXWidth) / this.zoomOut + (this.zoomOut - 2.0f) * -1.0f * 250.0f), (double)((float)(-400 + this.displayXWidth) / this.zoomOut + (this.zoomOut - 2.0f) * -1.0f * 250.0f));
        this.displayYNew = this.displayY;
    }

    private void drawDisableText(PoseStack mStack) {
        if (this.f_96541_.f_91074_.m_21124_(ModEffects.oblivion) == null) {
            return;
        }
        int tooltipX = (this.f_96543_ - 256) / 2 + 19 + 3;
        int tooltipY = (this.f_96544_ - 202) / 2 + 4 + 19;
        int tooltipTextWidth = 212;
        int tooltipHeight = 17;
        int backgroundColor = -257292280;
        int borderColorStart = 1348406284;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        int zLevel = this.m_93252_();
        mStack.m_85836_();
        Matrix4f mat = mStack.m_85850_().m_85861_();
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        MultiBufferSource.BufferSource renderType = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        mStack.m_85837_(0.0, 0.0, (double)zLevel);
        MutableComponent f = new TranslatableComponent("text.vampirism.skill.unlock_unavailable").m_130940_(ChatFormatting.WHITE);
        FormattedCharSequence s = Language.m_128107_().m_5536_((FormattedText)f);
        this.f_96547_.m_92733_(s, (float)tooltipX + (float)tooltipTextWidth / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)f) / 2.0f, (float)tooltipY + (float)tooltipHeight / 2.0f - 3.0f, -1, true, mat, (MultiBufferSource)renderType, false, 0, 0xF000F0);
        renderType.m_109911_();
        mStack.m_85849_();
    }

    private void drawSkills(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        int offsetX = Mth.m_14107_((double)(this.displayX + (this.displayXNew - this.displayX) * (double)partialTicks));
        int offsetY = Mth.m_14107_((double)(this.displayY + (this.displayYNew - this.displayY) * (double)partialTicks));
        if (offsetX < this.area_min_x) {
            offsetX = this.area_min_x;
        }
        if (offsetY < -77) {
            offsetY = -77;
        }
        if (offsetX >= this.area_max_x) {
            offsetX = this.area_max_x - 1;
        }
        if (offsetY >= this.area_max_y) {
            offsetY = this.area_max_y - 1;
        }
        int k = (this.f_96543_ - 256) / 2;
        int l = (this.f_96544_ - 202) / 2;
        int i1 = k + 16;
        int j1 = l + 17;
        GL11.glEnable((int)3089);
        double scale = this.f_96541_.m_91268_().m_85449_();
        GL11.glScissor((int)((int)((double)k * scale)), (int)((int)((double)l * scale)), (int)((int)(256.0 * scale)), (int)((int)(202.0 * scale)));
        this.m_93250_(0);
        RenderSystem.m_69456_((int)518);
        stack.m_85836_();
        stack.m_85837_((double)i1, (double)j1, -200.0);
        stack.m_85841_(1.0f / this.zoomOut, 1.0f / this.zoomOut, 1.0f);
        RenderSystem.m_69493_();
        int k1 = offsetX + 288 >> 4;
        int l1 = offsetY + 288 >> 4;
        int i2 = (offsetX + 512) % 16;
        int j2 = (offsetY + 288) % 16;
        Random random = new Random();
        float f = 16.0f / this.zoomOut;
        float f1 = 16.0f / this.zoomOut;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        int y = 0;
        while ((float)y * f - (float)j2 < 155.0f) {
            float f2 = 0.6f - (float)(l1 + y) / 25.0f * 0.3f;
            RenderSystem.m_157429_((float)f2, (float)f2, (float)f2, (float)1.0f);
            int x = 0;
            while ((float)x * f1 - (float)i2 < 224.0f) {
                random.setSeed((long)(this.f_96541_.m_91094_().m_92545_().hashCode() + k1 + x) + (long)(l1 + y) * 16L);
                int j4 = random.nextInt(1 + l1 + y) + (l1 + y) / 2;
                TextureAtlasSprite textureatlassprite = this.getTexture(Blocks.f_49992_);
                if (j4 <= 37 && l1 + y != 35) {
                    if (j4 == 22) {
                        textureatlassprite = random.nextInt(2) == 0 ? this.getTexture(Blocks.f_50353_) : this.getTexture(Blocks.f_50330_);
                    } else if (j4 == 10) {
                        textureatlassprite = this.getTexture(ModBlocks.castle_block_dark_brick_bloody);
                    } else if (j4 == 8) {
                        textureatlassprite = this.getTexture(Blocks.f_50222_);
                    } else if (j4 > 4) {
                        textureatlassprite = this.getTexture(ModBlocks.castle_block_normal_brick);
                    } else if (j4 > 0) {
                        textureatlassprite = this.getTexture(Blocks.f_50493_);
                    }
                } else {
                    Block block = Blocks.f_50752_;
                    textureatlassprite = this.getTexture(block);
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                SkillsScreen.m_93200_((PoseStack)stack, (int)(x * 16 - i2), (int)(y * 16 - j2), (int)this.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
                ++x;
            }
            ++y;
        }
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        for (SkillNode node : this.skillNodes) {
            if (node.getParent() == null) continue;
            int xs = this.findHorizontalNodeCenter(node) - offsetX + 11;
            int ys = node.getElements()[0].getRenderRow() * 24 - offsetY + 11;
            int xp = this.findHorizontalNodeCenter(node.getParent()) - offsetX + 11;
            int yp = node.getParent().getElements()[0].getRenderRow() * 24 - offsetY + 11;
            int color = -16777216;
            if (this.skillHandler.isNodeEnabled(node)) {
                color = -6250336;
            } else if (this.skillHandler.isSkillNodeLocked(node)) {
                color = -6750208;
            } else if (this.skillHandler.isNodeEnabled(node.getParent())) {
                color = -16738048;
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93154_(stack, xs, xp, yp, color);
            this.m_93222_(stack, xs, ys - 11, yp, color);
            RenderSystem.m_157429_((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
            if (ys > yp) {
                this.m_93228_(stack, xs - 5, ys - 11 - 7, 96, 234, 11, 7);
                continue;
            }
            if (ys < yp) {
                this.m_93228_(stack, xs - 5, ys + 11, 96, 241, 11, 7);
                continue;
            }
            if (xs > xp) {
                this.m_93228_(stack, xs - 11 - 7, ys - 5, 114, 234, 7, 11);
                continue;
            }
            if (xs >= xp) continue;
            this.m_93228_(stack, xs + 11, ys - 5, 107, 234, 7, 11);
        }
        float mMouseX = (float)(mouseX - i1) * this.zoomOut;
        float mMouseY = (float)(mouseY - j1) * this.zoomOut;
        ISkill<?> newSelected = null;
        SkillNode newSelectedNode = null;
        for (SkillNode node : this.skillNodes) {
            ISkill<?>[] elements = node.getElements();
            if (elements.length > 1) {
                int minX = elements[0].getRenderColumn() * 24 - offsetX;
                int maxX = elements[elements.length - 1].getRenderColumn() * 24 - offsetX;
                int y2 = elements[0].getRenderRow() * 24 - offsetY;
                if (maxX >= -24 && y2 >= -24 && (float)minX <= 224.0f * this.zoomOut && (float)y2 <= 155.0f * this.zoomOut) {
                    RenderSystem.m_69478_();
                    this.m_93179_(stack, minX - 1, y2 - 1, maxX + 23, y2 + 23, -6578783, -6578783);
                    RenderSystem.m_69461_();
                }
            }
            for (int i = 0; i < elements.length; ++i) {
                ISkill<?> skill2 = elements[i];
                int x = skill2.getRenderColumn() * 24 - offsetX;
                int y3 = skill2.getRenderRow() * 24 - offsetY;
                if (x < -24 || y3 < -24 || !((float)x <= 224.0f * this.zoomOut) || !((float)y3 <= 155.0f * this.zoomOut)) continue;
                if (this.skillHandler.isSkillEnabled(skill2)) {
                    float f5 = 1.0f;
                    RenderSystem.m_157429_((float)f5, (float)f5, (float)f5, (float)1.0f);
                } else if (this.skillHandler.canSkillBeEnabled(skill2) == ISkillHandler.Result.OK) {
                    float f6 = 0.6f;
                    RenderSystem.m_157429_((float)f6, (float)f6, (float)f6, (float)1.0f);
                } else if (this.skillHandler.isNodeEnabled(node)) {
                    float f8 = 0.2f;
                    RenderSystem.m_157429_((float)f8, (float)f8, (float)f8, (float)1.0f);
                } else {
                    float f7 = 0.3f;
                    RenderSystem.m_157429_((float)f7, (float)f7, (float)f7, (float)1.0f);
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
                RenderSystem.m_69478_();
                this.m_93228_(stack, x - 2, y3 - 2, node.getLockingNodes().length == 0 ? 0 : 26, 202, 26, 26);
                RenderSystem.m_69461_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.getIconLoc(skill2));
                RenderSystem.m_69478_();
                UtilLib.drawTexturedModalRect(stack.m_85850_().m_85861_(), this.m_93252_(), x + 3, y3 + 3, 0, 0, 16, 16, 16, 16);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (mMouseX >= (float)x && mMouseX <= (float)(x + 22) && mMouseY >= (float)y3 && mMouseY <= (float)(y3 + 22)) {
                    newSelected = skill2;
                    newSelectedNode = node;
                }
                if (i + 1 >= elements.length) continue;
                Objects.requireNonNull(this.f_96547_);
                SkillsScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)"OR", (int)(x + 24 + 12), (int)(y3 + 1 + (24 - 9) / 2), (int)0xFFFFFF);
            }
        }
        GL11.glDisable((int)3089);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        stack.m_85849_();
        Color color = new Color(this.skillHandler.getPlayer().getFaction().getColor());
        RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(stack, k, l, 0, 0, 256, 202);
        this.m_93250_(0);
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69493_();
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        for (GuiEventListener button : this.m_6702_()) {
            if (!button.m_5953_((double)mouseX, (double)mouseY)) continue;
            newSelected = null;
            newSelectedNode = null;
        }
        this.selected = newSelected;
        SkillNode selectedNode = newSelectedNode;
        if (this.selected != null) {
            stack.m_85836_();
            stack.m_85837_(0.0, 0.0, 1.0);
            List tooltips = this.skillToolTipsCache.computeIfAbsent(this.selected, skill -> new ArrayList());
            if (tooltips.isEmpty()) {
                MutableComponent name = this.selected.getName().m_6879_().m_130940_(ChatFormatting.GRAY);
                Component desc = this.selected.getDescription();
                tooltips.add(name);
                if (desc != null) {
                    tooltips.add(desc.m_6881_().m_130940_(ChatFormatting.DARK_GRAY));
                }
                ISkillHandler.Result result = this.skillHandler.canSkillBeEnabled(this.selected);
                List<ISkill<T>> lockingSkills = null;
                ChatFormatting lockingColor = ChatFormatting.BLACK;
                if (selectedNode.getLockingNodes().length != 0) {
                    lockingSkills = this.skillHandler.getLockingSkills(selectedNode);
                    ChatFormatting chatFormatting = result == ISkillHandler.Result.ALREADY_ENABLED ? ChatFormatting.DARK_GRAY : (lockingColor = lockingSkills.stream().anyMatch(skill -> this.skillHandler.isSkillEnabled((ISkill<?>)skill)) ? ChatFormatting.DARK_RED : ChatFormatting.YELLOW);
                }
                if (lockingSkills != null) {
                    tooltips.add(new TranslatableComponent("text.vampirism.skill.excluding").m_130940_(lockingColor));
                    for (ISkill<T> lockingSkill : lockingSkills) {
                        tooltips.add(new TextComponent("  ").m_7220_((Component)lockingSkill.getName().m_6881_().m_130940_(lockingColor)));
                    }
                }
                if (result == ISkillHandler.Result.ALREADY_ENABLED) {
                    tooltips.add(new TranslatableComponent("text.vampirism.skill.unlocked").m_130940_(ChatFormatting.GOLD));
                } else if (result == ISkillHandler.Result.PARENT_NOT_ENABLED) {
                    tooltips.add(new TranslatableComponent("text.vampirism.skill.unlock_parent_first").m_130940_(ChatFormatting.DARK_RED));
                }
            }
            int width_name = Math.max(this.f_96547_.m_92852_((FormattedText)tooltips.get(0)), 110);
            this.renderTooltip(stack, tooltips.stream().flatMap(t -> this.f_96547_.m_92923_((FormattedText)t, width_name).stream()).collect(Collectors.toList()), mouseX, mouseY, this.f_96547_);
            stack.m_85849_();
        }
        RenderSystem.m_69482_();
    }

    private int findHorizontalNodeCenter(SkillNode node) {
        int width = (node.getElements().length - 1) * 2 * 24;
        return node.getElements()[0].getRenderColumn() * 24 + width / 2;
    }

    private ResourceLocation getIconLoc(ISkill<T> skill) {
        if (skill instanceof ActionSkill) {
            return new ResourceLocation(((ActionSkill)skill).getActionID().m_135827_(), "textures/actions/" + ((ActionSkill)skill).getActionID().m_135815_() + ".png");
        }
        return new ResourceLocation(skill.getRegistryName().m_135827_(), "textures/skills/" + skill.getRegistryName().m_135815_() + ".png");
    }

    private TextureAtlasSprite getTexture(BlockState blockstate) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(blockstate);
    }

    private TextureAtlasSprite getTexture(Block block) {
        return this.getTexture(block.m_49966_());
    }

    private void playSoundEffect(SoundEvent event, float pitch) {
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)event, (float)1.0f));
    }

    private void unlockSkill() {
        if (this.canUnlockSkill()) {
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("us", this.selected.getRegistryName().toString()));
            this.playSoundEffect(SoundEvents.f_12275_, 0.7f);
        } else {
            this.playSoundEffect(SoundEvents.f_12209_, 0.5f);
        }
    }
}

