/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.client.gui.widget.ScrollableArrayTextComponentList;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.AppearanceScreen;
import de.teamlapen.vampirism.client.render.entities.HunterMinionRenderer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.AppearancePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class HunterMinionAppearanceScreen
extends AppearanceScreen<HunterMinionEntity> {
    private static final Component NAME = new TranslatableComponent("gui.vampirism.minion_appearance");
    private int skinType;
    private int hatType;
    private boolean useLordSkin;
    private boolean isMinionSpecificSkin;
    private ScrollableArrayTextComponentList skinList;
    private ScrollableArrayTextComponentList hatList;
    private ExtendedButton skinButton;
    private ExtendedButton hatButton;
    private Checkbox useLordSkinButton;
    private EditBox nameWidget;
    private int normalSkinCount;
    private int minionSkinCount;

    public HunterMinionAppearanceScreen(HunterMinionEntity minion, Screen backScreen) {
        super(NAME, minion, backScreen);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.hatList.m_7979_(mouseX, mouseY, button, dragX, dragY) && !this.skinList.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void m_7861_() {
        Object name = this.nameWidget.m_94155_();
        if (((String)name).isEmpty()) {
            name = new TranslatableComponent("text.vampirism.minion").toString() + ((HunterMinionEntity)this.entity).getMinionId().orElse(0);
        }
        VampirismMod.dispatcher.sendToServer(new AppearancePacket(((HunterMinionEntity)this.entity).m_142049_(), (String)name, this.skinType, this.hatType, (this.isMinionSpecificSkin ? 2 : 0) | (this.useLordSkin ? 1 : 0)));
        super.m_7861_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.nameWidget = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + 21, this.guiTop + 29, 98, 12, (Component)new TranslatableComponent("gui.vampirism.minion_appearance.name")));
        this.nameWidget.m_94144_(((HunterMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.m_94205_(-1);
        this.nameWidget.m_94202_(-1);
        this.nameWidget.m_94199_(15);
        this.nameWidget.m_94151_(this::onNameChanged);
        this.normalSkinCount = ((HunterMinionRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((HunterMinionEntity)this.entity))).getHunterTextureCount();
        this.minionSkinCount = ((HunterMinionRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((HunterMinionEntity)this.entity))).getMinionSpecificTextureCount();
        this.isMinionSpecificSkin = ((HunterMinionEntity)this.entity).hasMinionSpecificSkin();
        if (this.isMinionSpecificSkin && this.minionSkinCount > 0) {
            this.skinType %= this.minionSkinCount;
        } else {
            this.skinType %= this.normalSkinCount;
            this.isMinionSpecificSkin = false;
        }
        this.hatType = ((HunterMinionEntity)this.entity).getHatType();
        this.useLordSkin = ((HunterMinionEntity)this.entity).shouldRenderLordSkin();
        this.skinList = (ScrollableArrayTextComponentList)this.m_142416_((GuiEventListener)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 80, 20, this.normalSkinCount + this.minionSkinCount, (BaseComponent)new TranslatableComponent("gui.vampirism.minion_appearance.skin"), this::skin, this::previewSkin));
        this.hatList = (ScrollableArrayTextComponentList)this.m_142416_((GuiEventListener)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 64 + 19, 99, 60, 20, 3, (BaseComponent)new TranslatableComponent("gui.vampirism.minion_appearance.hat"), this::hat, this::previewHat));
        this.skinButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.skinList.f_93620_, this.skinList.f_93621_ - 20, this.skinList.m_5711_() + 1, 20, (Component)new TextComponent(""), b -> this.setSkinListVisibility(!this.skinList.f_93624_)));
        this.hatButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.hatList.f_93620_, this.hatList.f_93621_ - 20, this.hatList.m_5711_() + 1, 20, (Component)new TextComponent(""), b -> this.setHatListVisibility(!this.hatList.f_93624_)));
        this.useLordSkinButton = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.guiLeft + 20, this.guiTop + 86, 99, 20, (Component)new TranslatableComponent("gui.vampirism.minion_appearance.use_lord_skin"), this.useLordSkin){

            public void m_5691_() {
                super.m_5691_();
                HunterMinionAppearanceScreen.this.useLordSkin = this.m_93840_();
                ((HunterMinionEntity)HunterMinionAppearanceScreen.this.entity).setUseLordSkin(HunterMinionAppearanceScreen.this.useLordSkin);
            }
        });
        this.setSkinListVisibility(false);
        this.setHatListVisibility(false);
    }

    private void hat(int type) {
        this.hatType = type;
        ((HunterMinionEntity)this.entity).setHatType(this.hatType);
        this.setHatListVisibility(false);
    }

    private void onNameChanged(String newName) {
        ((HunterMinionEntity)this.entity).changeMinionName(newName);
    }

    private void previewHat(int type, boolean hovered) {
        if (hovered) {
            ((HunterMinionEntity)this.entity).setHatType(type);
        } else if (((HunterMinionEntity)this.entity).getHatType() == type) {
            ((HunterMinionEntity)this.entity).setHatType(this.hatType);
        }
    }

    private void previewSkin(int type, boolean hovered) {
        boolean minionSpecific;
        boolean bl = minionSpecific = type >= this.normalSkinCount;
        if (hovered) {
            ((HunterMinionEntity)this.entity).setHunterType(type, minionSpecific);
        } else if (((HunterMinionEntity)this.entity).getHunterType() == type && ((HunterMinionEntity)this.entity).hasMinionSpecificSkin() == minionSpecific) {
            ((HunterMinionEntity)this.entity).setHunterType(this.skinType, this.isMinionSpecificSkin);
        }
    }

    private void setHatListVisibility(boolean show) {
        this.hatButton.m_93666_((Component)this.hatList.m_6035_().m_6881_().m_130946_(" " + (this.hatType + 1)));
        this.hatList.f_93624_ = show;
        if (show) {
            this.skinList.f_93624_ = false;
        }
        this.useLordSkinButton.f_93624_ = !show;
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.m_93666_((Component)this.skinList.m_6035_().m_6881_().m_130946_(" " + (this.skinType + 1)));
        this.skinList.f_93624_ = show;
        this.hatButton.f_93624_ = !show;
        boolean bl = this.useLordSkinButton.f_93624_ = !show;
        if (show) {
            this.hatList.f_93624_ = false;
        }
    }

    private void skin(int type) {
        boolean minionSpecific = type >= this.normalSkinCount;
        this.skinType = type;
        this.isMinionSpecificSkin = minionSpecific;
        ((HunterMinionEntity)this.entity).setHunterType(this.skinType, this.isMinionSpecificSkin);
        this.setSkinListVisibility(false);
    }
}

