/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AppearanceScreen<T extends LivingEntity>
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/appearance.png");
    protected final T entity;
    protected final int xSize = 256;
    protected final int ySize = 177;
    private final List<Button> buttons = Lists.newArrayList();
    @Nullable
    private final Screen backScreen;
    protected int guiLeft;
    protected int guiTop;

    public AppearanceScreen(Component titleIn, T entity, @Nullable Screen backScreen) {
        super(titleIn);
        this.entity = entity;
        this.backScreen = backScreen;
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        for (Button button : this.buttons) {
            if (!button.f_93624_ || !button.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_)) continue;
            return true;
        }
        return false;
    }

    public void m_6305_(@Nonnull PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(mStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        this.renderGuiBackground(mStack);
        this.drawTitle(mStack);
        InventoryScreen.m_98850_((int)(this.guiLeft + 200), (int)(this.guiTop + 145), (int)60, (float)((float)(this.guiLeft + 200) - (float)mouseX), (float)((float)(this.guiTop + 45) - (float)mouseY), this.entity);
        super.m_6305_(mStack, mouseX, mouseY, partialTicks);
        for (Button button : this.buttons) {
            button.m_6305_(mStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void m_7856_() {
        this.buttons.clear();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + this.xSize - 80 - 10, this.guiTop + 152, 80, 20, (Component)new TranslatableComponent("gui.done"), context -> this.m_7379_()));
        if (this.backScreen != null) {
            this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10, this.guiTop + 152, 80, 20, (Component)new TranslatableComponent("gui.back"), context -> {
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_(this.backScreen);
                }
            }));
        }
    }

    protected void renderGuiBackground(PoseStack mStack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        AppearanceScreen.m_93143_((PoseStack)mStack, (int)this.guiLeft, (int)this.guiTop, (int)this.m_93252_(), (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)300, (int)256);
    }

    private void drawTitle(PoseStack mStack) {
        this.f_96547_.m_92763_(mStack, this.f_96539_, (float)(this.guiLeft + 15), (float)(this.guiTop + 5), -1);
    }
}

