/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blockentity.PotionTableBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class PotionTableBlock
extends VampirismBlockContainer {
    protected static final VoxelShape shape = PotionTableBlock.makeShape();
    private static final String regName = "potion_table";

    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape b = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape c = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
        VoxelShape d = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
        return Shapes.m_83124_((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d});
    }

    public PotionTableBlock() {
        super(regName, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.0f).m_60955_());
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new PotionTableBlockEntity(pos, state);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return shape;
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos blockPos, @Nonnull BlockState blockState, LivingEntity entity, @Nonnull ItemStack stack) {
        super.m_6402_(world, blockPos, blockState, entity, stack);
        BlockEntity tile = world.m_7702_(blockPos);
        if (entity instanceof Player && tile instanceof PotionTableBlockEntity) {
            ((PotionTableBlockEntity)tile).setOwnerID((Player)entity);
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        BlockEntity tile;
        if (!worldIn.f_46443_ && player instanceof ServerPlayer && (tile = worldIn.m_7702_(pos)) instanceof PotionTableBlockEntity && ((PotionTableBlockEntity)tile).m_7525_(player)) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((PotionTableBlockEntity)tile), buffer -> buffer.writeBoolean(((PotionTableBlockEntity)tile).isExtended()));
            player.m_36220_(ModStats.interact_alchemical_cauldron);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void clearContainer(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof PotionTableBlockEntity) {
            for (int i = 0; i < 8; ++i) {
                this.dropItem(worldIn, pos, ((PotionTableBlockEntity)te).m_8016_(i));
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return PotionTableBlock.m_152132_(type, ModTiles.potion_table, PotionTableBlockEntity::tick);
    }
}

