/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.CastleBricksBlock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CastleStairsBlock
extends StairBlock {
    private static final String REGNAME_BASE = "castle_stairs";
    private final CastleBricksBlock.EnumVariant variant;

    public CastleStairsBlock(BlockState state, CastleBricksBlock.EnumVariant variant) {
        super(state, BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56742_));
        this.setRegistryName("vampirism", "castle_stairs_" + variant.getName());
        this.variant = variant;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter player, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag advanced) {
        super.m_5871_(stack, player, tooltip, advanced);
        tooltip.add((Component)new TranslatableComponent("block.vampirism.castle_block" + (this.variant == CastleBricksBlock.EnumVariant.DARK_STONE ? ".no_spawn" : ".vampire_spawn")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    public CastleBricksBlock.EnumVariant getVariant() {
        return this.variant;
    }
}

