/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.CastleStairsBlock;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.core.ModSounds;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class CastleBricksBlock
extends VampirismBlock {
    private static final String name = "castle_block";
    private final EnumVariant variant;

    public CastleBricksBlock(EnumVariant variant) {
        super("castle_block_" + variant.getName(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56742_));
        this.variant = variant;
    }

    public void m_7100_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (!CastleStairsBlock.m_56980_((BlockState)state) && this.variant == EnumVariant.DARK_BRICK_BLOODY && rand.nextInt(180) == 0) {
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSounds.ambient_castle, SoundSource.AMBIENT, 0.8f, 1.0f, false);
        }
    }

    @Override
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag advanced) {
        super.m_5871_(stack, world, tooltip, advanced);
        tooltip.add((Component)new TranslatableComponent("block.vampirism.castle_block" + (this.variant == EnumVariant.DARK_STONE ? ".no_spawn" : ".vampire_spawn")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    public EnumVariant getVariant() {
        return this.variant;
    }

    public static enum EnumVariant implements StringRepresentable
    {
        DARK_BRICK("dark_brick"),
        PURPLE_BRICK("purple_brick"),
        DARK_BRICK_BLOODY("dark_brick_bloody"),
        NORMAL_BRICK("normal_brick"),
        DARK_STONE("dark_stone");

        private final String name;

        private EnumVariant(String name) {
            this.name = name;
        }

        public String getName() {
            return this.m_7912_();
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }
    }
}

