/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.particle.FlyingBloodParticleData;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class PedestalBlockEntity
extends BlockEntity
implements IItemHandler {
    private final Random rand = new Random();
    private final LazyOptional<IItemHandler> opt = LazyOptional.of(() -> this);
    private final int chargeRate = 30;
    private int ticksExistedClient;
    private int chargingTicks;
    private int bloodStored = 0;
    @Nonnull
    private ItemStack internalStack = ItemStack.f_41583_;

    public PedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModTiles.blood_pedestal, pos, state);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.internalStack;
        if (slot == 0 && !stack.m_41619_()) {
            if (!simulate) {
                this.removeStack();
                this.markDirtyAndUpdateClient();
            }
            return simulate ? stack.m_41777_() : stack;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != Direction.DOWN) {
            return this.opt.cast();
        }
        return super.getCapability(capability, facing);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackForRender() {
        return this.internalStack;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.internalStack : ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTickForRender() {
        return this.ticksExistedClient;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean hasStack() {
        return !this.internalStack.m_41619_();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot == 0 && this.internalStack.m_41619_()) {
            if (!simulate) {
                this.setStack(stack);
                this.markDirtyAndUpdateClient();
            }
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.internalStack = compound.m_128441_("item") ? ItemStack.m_41712_((CompoundTag)compound.m_128469_("item")) : ItemStack.f_41583_;
        this.bloodStored = compound.m_128451_("blood_stored");
        this.chargingTicks = compound.m_128451_("charging_ticks");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58898_()) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Nonnull
    public ItemStack removeStack() {
        ItemStack stack = this.internalStack;
        this.internalStack = ItemStack.f_41583_;
        return stack;
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        if (this.hasStack()) {
            compound.m_128365_("item", (Tag)this.internalStack.serializeNBT());
        }
        compound.m_128405_("blood_stored", this.bloodStored);
        compound.m_128405_("charging_ticks", this.chargingTicks);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PedestalBlockEntity blockEntity) {
        if (blockEntity.chargingTicks > 0) {
            --blockEntity.chargingTicks;
            if (blockEntity.chargingTicks == 0) {
                IBloodChargeable chargeable = PedestalBlockEntity.getChargeItem(blockEntity.internalStack);
                if (chargeable != null && blockEntity.bloodStored > 0) {
                    int charged = chargeable.charge(blockEntity.internalStack, blockEntity.bloodStored);
                    blockEntity.bloodStored -= Math.max(0, charged);
                }
                blockEntity.markDirtyAndUpdateClient();
            }
        } else if (blockEntity.chargingTicks == 0) {
            IBloodChargeable chargeable = PedestalBlockEntity.getChargeItem(blockEntity.internalStack);
            if (chargeable != null && chargeable.canBeCharged(blockEntity.internalStack)) {
                if (blockEntity.bloodStored < blockEntity.chargeRate) {
                    blockEntity.drainBlood();
                }
                if (blockEntity.bloodStored > 0) {
                    blockEntity.chargingTicks = 20;
                    blockEntity.markDirtyAndUpdateClient();
                } else {
                    blockEntity.chargingTicks = -40;
                }
            } else {
                blockEntity.chargingTicks = -40;
            }
        } else {
            ++blockEntity.chargingTicks;
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, PedestalBlockEntity blockEntity) {
        ++blockEntity.ticksExistedClient;
        if (blockEntity.chargingTicks > 0 && blockEntity.ticksExistedClient % 8 == 0) {
            PedestalBlockEntity.spawnChargedParticle(level, pos, blockEntity.rand);
        }
    }

    private void drainBlood() {
        if (this.f_58857_ == null) {
            return;
        }
        FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)this.f_58858_.m_7495_(), (Direction)Direction.UP).ifPresent(handler -> {
            FluidStack drained = handler.drain(new FluidStack(ModFluids.blood, 100), IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty() && drained.getAmount() == 100) {
                drained = handler.drain(new FluidStack(ModFluids.blood, 100), IFluidHandler.FluidAction.EXECUTE);
                this.bloodStored += drained.getAmount();
            }
        });
    }

    @Nullable
    private static IBloodChargeable getChargeItem(@Nonnull ItemStack stack) {
        return stack.m_41619_() ? null : (stack.m_41720_() instanceof IBloodChargeable ? (IBloodChargeable)stack.m_41720_() : null);
    }

    private void markDirtyAndUpdateClient() {
        if (this.f_58857_ != null) {
            super.m_6596_();
            BlockState block = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, block, block, 3);
        }
    }

    private void setStack(@Nonnull ItemStack stack) {
        this.chargingTicks = 0;
        if (this.internalStack.m_41619_()) {
            this.internalStack = stack;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnChargedParticle(Level level, BlockPos blockPos, Random rand) {
        Vec3 pos = Vec3.m_82514_((Vec3i)blockPos, (double)0.8);
        ModParticles.spawnParticleClient(level, new FlyingBloodParticleData(ModParticles.flying_blood, (int)(4.0f / (rand.nextFloat() * 0.9f + 0.1f)), true, pos.f_82479_ + (double)(1.0f - rand.nextFloat()) * 0.1, pos.f_82480_ + (double)(1.0f - rand.nextFloat()) * 0.2, pos.f_82481_ + (double)(1.0f - rand.nextFloat()) * 0.1, new ResourceLocation("minecraft", "glitter_1")), (double)blockPos.m_123341_() + 0.2, (double)blockPos.m_123342_() + 0.65, (double)blockPos.m_123343_() + 0.2);
        ModParticles.spawnParticleClient(level, new FlyingBloodParticleData(ModParticles.flying_blood, (int)(4.0f / (rand.nextFloat() * 0.9f + 0.1f)), true, pos.f_82479_ + (double)(1.0f - rand.nextFloat()) * 0.1, pos.f_82480_ + (double)(1.0f - rand.nextFloat()) * 0.2, pos.f_82481_ + (double)(1.0f - rand.nextFloat()) * 0.1, new ResourceLocation("minecraft", "glitter_1")), (double)blockPos.m_123341_() + 0.8, (double)blockPos.m_123342_() + 0.65, (double)blockPos.m_123343_() + 0.2);
        ModParticles.spawnParticleClient(level, new FlyingBloodParticleData(ModParticles.flying_blood, (int)(4.0f / (rand.nextFloat() * 0.9f + 0.1f)), true, pos.f_82479_ + (double)(1.0f - rand.nextFloat()) * 0.1, pos.f_82480_ + (double)(1.0f - rand.nextFloat()) * 0.2, pos.f_82481_ + (double)(1.0f - rand.nextFloat()) * 0.1, new ResourceLocation("minecraft", "glitter_1")), (double)blockPos.m_123341_() + 0.2, (double)blockPos.m_123342_() + 0.65, (double)blockPos.m_123343_() + 0.8);
        ModParticles.spawnParticleClient(level, new FlyingBloodParticleData(ModParticles.flying_blood, (int)(3.0f / (rand.nextFloat() * 0.6f + 0.4f)), true, pos.f_82479_ + (double)(1.0f - rand.nextFloat()) * 0.1, pos.f_82480_ + (double)(1.0f - rand.nextFloat()) * 0.2, pos.f_82481_ + (double)(1.0f - rand.nextFloat()) * 0.1, new ResourceLocation("minecraft", "glitter_1")), (double)blockPos.m_123341_() + 0.8, (double)blockPos.m_123342_() + 0.65, (double)blockPos.m_123343_() + 0.8);
    }
}

