/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.FluidTankWithListener;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.TileFluidHandler;

public class BloodContainerBlockEntity
extends TileFluidHandler
implements FluidTankWithListener.IFluidTankListener {
    public static final int LEVEL_AMOUNT = 900;
    public static final int CAPACITY = 12600;
    public static final ModelProperty<Integer> FLUID_LEVEL_PROP = new ModelProperty();
    public static final ModelProperty<Boolean> FLUID_IMPURE = new ModelProperty();
    private int lastSyncedAmount = Integer.MIN_VALUE;
    private IModelData modelData;

    public static void setBloodValue(BlockGetter worldIn, Random randomIn, BlockPos blockPosIn) {
        BlockEntity tileEntity = worldIn.m_7702_(blockPosIn);
        if (tileEntity instanceof BloodContainerBlockEntity) {
            ((BloodContainerBlockEntity)tileEntity).setFluidStack(new FluidStack(ModFluids.blood, BloodBottleFluidHandler.getAdjustedAmount((int)(12600.0f * randomIn.nextFloat()))));
        }
    }

    public BloodContainerBlockEntity(BlockPos pos, BlockState state) {
        super(ModTiles.blood_container, pos, state);
        this.tank = new FluidTankWithListener(12600, fluidStack -> ModFluids.blood.m_6212_(fluidStack.getFluid()) || ModFluids.impure_blood.m_6212_(fluidStack.getFluid())).setListener(this);
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @Nonnull
    public IModelData getModelData() {
        if (this.modelData == null) {
            this.updateModelData(false);
        }
        return this.modelData;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbtTag = new CompoundTag();
        this.m_183515_(nbtTag);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        this.tank.writeToNBT(tag);
        return tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        FluidStack old = this.tank.getFluid();
        if (this.m_58898_()) {
            super.onDataPacket(net, pkt);
            if (!old.isEmpty() && !old.isFluidStackIdentical(this.tank.getFluid()) || old.isEmpty() && !this.tank.getFluid().isEmpty()) {
                this.m_6596_();
            }
        }
    }

    @Override
    public void onTankContentChanged() {
        FluidStack fluid = this.tank.getFluid();
        if (this.lastSyncedAmount != Integer.MIN_VALUE || !fluid.isEmpty() && Math.abs(fluid.getAmount() - this.lastSyncedAmount) >= 100) {
            this.m_6596_();
            this.lastSyncedAmount = fluid.isEmpty() ? Integer.MIN_VALUE : fluid.getAmount();
        }
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.updateModelData(true);
            }
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
            super.m_6596_();
        }
    }

    public void setFluidStack(FluidStack stack) {
        this.tank.setFluid(stack);
    }

    private void updateModelData(boolean refresh) {
        FluidStack fluid = this.tank.getFluid();
        int l = 0;
        if (!fluid.isEmpty()) {
            float amount = (float)fluid.getAmount() / 900.0f;
            l = amount > 0.0f && amount < 1.0f ? 1 : (int)amount;
        }
        this.modelData = new ModelDataMap.Builder().withInitial(FLUID_LEVEL_PROP, (Object)l).withInitial(FLUID_IMPURE, (Object)fluid.getFluid().equals(ModFluids.impure_blood)).build();
        if (refresh) {
            ModelDataManager.requestModelDataRefresh((BlockEntity)this);
        }
    }
}

