/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.blockentity.InventoryBlockEntity;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.util.ValuedObject;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.container.AltarInfusionContainer;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.particle.FlyingBloodParticleData;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AltarInfusionBlockEntity
extends InventoryBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger(AltarInfusionBlockEntity.class);
    private static final int DURATION_TICK = 450;
    private final LazyOptional<IItemHandler> itemHandlerOptional = LazyOptional.of(() -> this.createWrapper());
    private UUID playerToLoadUUID;
    private Player player;
    private BlockPos[] tips;
    private int runningTick;
    private int targetLevel;

    public AltarInfusionBlockEntity(BlockPos pos, BlockState state) {
        super(ModTiles.altar_infusion, pos, state, 3, AltarInfusionContainer.SELECTOR_INFOS);
    }

    public Result canActivate(Player player, boolean messagePlayer) {
        if (this.runningTick > 0) {
            if (messagePlayer) {
                player.m_5661_((Component)new TranslatableComponent("text.vampirism.altar_infusion.ritual_still_running"), true);
            }
            return Result.ISRUNNING;
        }
        this.player = null;
        this.targetLevel = VampirismPlayerAttributes.get((Player)player).vampireLevel + 1;
        int requiredLevel = this.checkRequiredLevel();
        if (requiredLevel == -1) {
            if (messagePlayer) {
                player.m_5661_((Component)new TranslatableComponent("text.vampirism.altar_infusion.ritual_level_wrong"), true);
            }
            return Result.WRONGLEVEL;
        }
        if (player.m_20193_().m_46461_()) {
            if (messagePlayer) {
                player.m_5661_((Component)new TranslatableComponent("text.vampirism.altar_infusion.ritual_night_only"), true);
            }
            return Result.NIGHTONLY;
        }
        if (!this.checkStructureLevel(requiredLevel)) {
            if (messagePlayer) {
                player.m_5661_((Component)new TranslatableComponent("text.vampirism.altar_infusion.ritual_structure_wrong"), true);
            }
            this.tips = null;
            return Result.STRUCTUREWRONG;
        }
        if (!this.checkItemRequirements(player, messagePlayer)) {
            this.tips = null;
            return Result.INVMISSING;
        }
        return Result.OK;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public PHASE getCurrentPhase() {
        if (this.runningTick < 1) {
            return PHASE.NOT_RUNNING;
        }
        if (this.runningTick == 1) {
            return PHASE.CLEAN_UP;
        }
        if (this.runningTick > 350) {
            return PHASE.PARTICLE_SPREAD;
        }
        if (this.runningTick < 290 && this.runningTick >= 250) {
            return PHASE.BEAM1;
        }
        if (this.runningTick < 250 && this.runningTick > 50) {
            return PHASE.BEAM2;
        }
        if (this.runningTick == 50) {
            return PHASE.LEVELUP;
        }
        if (this.runningTick < 50) {
            return PHASE.ENDING;
        }
        return PHASE.WAITING;
    }

    public Player getPlayer() {
        if (this.runningTick <= 1) {
            return null;
        }
        return this.player;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int getRunningTick() {
        return this.runningTick;
    }

    public BlockPos[] getTips() {
        if (this.runningTick <= 1) {
            return null;
        }
        return this.tips;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        int tick = tagCompound.m_128451_("tick");
        if (tick > 0 && this.player == null && tagCompound.m_128403_("playerUUID")) {
            UUID playerID = tagCompound.m_128342_("playerUUID");
            if (!this.loadRitual(playerID)) {
                this.playerToLoadUUID = playerID;
            }
            this.runningTick = tick;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58898_()) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("tick", this.runningTick);
        if (this.player != null) {
            compound.m_128362_("playerUUID", this.player.m_142081_());
        }
    }

    public void startRitual(Player player) {
        if (this.f_58857_ == null) {
            return;
        }
        LOGGER.debug("Starting ritual for {}", (Object)player);
        this.player = player;
        this.runningTick = 450;
        this.m_6596_();
        if (!this.f_58857_.f_46443_) {
            for (BlockPos pTip : this.tips) {
                ModParticles.spawnParticlesServer(this.f_58857_, new FlyingBloodParticleData(ModParticles.flying_blood, 60, false, (double)pTip.m_123341_() + 0.5, (double)pTip.m_123342_() + 0.3, (double)pTip.m_123343_() + 0.5), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 3, 0.1, 0.1, 0.1, 0.0);
            }
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 450, 10));
        this.m_6596_();
    }

    private void tickRitual() {
        if (this.player == null || !this.player.m_6084_()) {
            this.runningTick = 1;
        } else if (this.player.m_20184_().f_82480_ >= 0.0) {
            this.player.m_20334_(0.0, 0.0, 0.0);
        } else {
            this.player.m_20334_(0.0, this.player.m_20184_().f_82480_, 0.0);
            this.player.m_20256_(this.player.m_20184_().m_82542_(1.0, 0.5, 1.0));
        }
        PHASE phase = this.getCurrentPhase();
        if (this.f_58857_.f_46443_) {
            if (phase.equals((Object)PHASE.PARTICLE_SPREAD) && this.runningTick % 15 == 0) {
                BlockPos pos = this.m_58899_();
                for (BlockPos pTip : this.tips) {
                    ModParticles.spawnParticlesClient(this.f_58857_, new FlyingBloodParticleData(ModParticles.flying_blood, 60, false, (double)pTip.m_123341_() + 0.5, (double)pTip.m_123342_() + 0.3, (double)pTip.m_123343_() + 0.5), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0, 5, 0.1, new Random());
                }
            }
            if (this.runningTick == 250 && this.getPlayer().m_7578_()) {
                VampirismMod.proxy.renderScreenFullColor(200, 50, 0xFF0000);
            }
        }
        if (phase.equals((Object)PHASE.CLEAN_UP)) {
            this.player = null;
            this.tips = null;
            this.m_6596_();
            this.runningTick = 0;
        }
        if (phase.equals((Object)PHASE.LEVELUP)) {
            if (!this.f_58857_.f_46443_) {
                assert (this.player.m_6084_());
                LazyOptional<FactionPlayerHandler> handler = FactionPlayerHandler.getOpt(this.player);
                if (handler.map(h -> h.getCurrentLevel(VReference.VAMPIRE_FACTION) != this.targetLevel - 1).orElse(false).booleanValue()) {
                    LOGGER.warn("Player {} changed level while the ritual was running. Cannot levelup.", (Object)this.player);
                    return;
                }
                handler.ifPresent(h -> h.setFactionLevel(VReference.VAMPIRE_FACTION, h.getCurrentLevel(VReference.VAMPIRE_FACTION) + 1));
                VampirePlayer.getOpt(this.player).ifPresent(v -> v.drinkBlood(Integer.MAX_VALUE, 0.0f, false));
                if (this.player instanceof ServerPlayer) {
                    ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayer)this.player, VampireActionTrigger.Action.PERFORM_RITUAL_INFUSION);
                }
            } else {
                this.f_58857_.m_7785_(this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_58857_.f_46441_.nextFloat() - this.f_58857_.f_46441_.nextFloat()) * 0.2f) * 0.7f, true);
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), 1.0, 0.0, 0.0);
            }
            this.player.m_7292_(new MobEffectInstance(ModEffects.saturation, 400, 2));
            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 2));
            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 400, 2));
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AltarInfusionBlockEntity blockEntity) {
        if (blockEntity.playerToLoadUUID != null) {
            if (!blockEntity.loadRitual(blockEntity.playerToLoadUUID)) {
                return;
            }
            blockEntity.playerToLoadUUID = null;
            blockEntity.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
        if (blockEntity.runningTick == 450 && !level.f_46443_) {
            LOGGER.debug("Ritual started");
            blockEntity.consumeItems();
            blockEntity.m_6596_();
        }
        if (blockEntity.runningTick > 0) {
            --blockEntity.runningTick;
            blockEntity.tickRitual();
        }
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int id, @Nonnull Inventory player) {
        return new AltarInfusionContainer(id, player, (Container)this, this.f_58857_ == null ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }

    @Nonnull
    protected Component m_6820_() {
        return new TranslatableComponent("tile.vampirism.altar_infusion");
    }

    private boolean checkItemRequirements(Player player, boolean messagePlayer) {
        int newLevel = this.targetLevel;
        VampireLevelingConf.AltarInfusionRequirements requirements = VampireLevelingConf.getInstance().getAltarInfusionRequirements(newLevel);
        ItemStack missing = InventoryHelper.checkItems((Container)this, new Item[]{PureBloodItem.getBloodItemForLevel(requirements.pureBloodLevel()), ModItems.human_heart, ModItems.vampire_book}, new int[]{requirements.blood(), requirements.heart(), requirements.vampireBook()}, (supplied, required) -> supplied.equals(required) || supplied instanceof PureBloodItem && required instanceof PureBloodItem && ((PureBloodItem)((Object)supplied)).getLevel() >= ((PureBloodItem)((Object)required)).getLevel());
        if (!missing.m_41619_()) {
            if (messagePlayer) {
                TranslatableComponent item = missing.m_41720_() instanceof PureBloodItem ? ((PureBloodItem)missing.m_41720_()).getCustomName() : new TranslatableComponent(missing.m_41778_());
                TranslatableComponent main = new TranslatableComponent("text.vampirism.altar_infusion.ritual_missing_items", new Object[]{missing.m_41613_(), item});
                player.m_6352_((Component)main, Util.f_137441_);
            }
            return false;
        }
        return true;
    }

    private int checkRequiredLevel() {
        int newLevel = this.targetLevel;
        if (!VampireLevelingConf.getInstance().isLevelValidForAltarInfusion(newLevel)) {
            return -1;
        }
        return VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(newLevel);
    }

    private boolean checkStructureLevel(int required) {
        int i;
        int v;
        if (this.f_58857_ == null) {
            return false;
        }
        BlockPos[] tips = this.findTips();
        ValuedObject[] valuedTips = new ValuedObject[tips.length];
        for (int i2 = 0; i2 < tips.length; ++i2) {
            BlockState temp;
            BlockPos pPos = tips[i2];
            int j = 0;
            AltarPillarBlock.EnumPillarType type = null;
            while ((temp = this.f_58857_.m_8055_(pPos.m_142082_(0, -j - 1, 0))).m_60734_().equals((Object)ModBlocks.altar_pillar)) {
                AltarPillarBlock.EnumPillarType t = (AltarPillarBlock.EnumPillarType)((Object)temp.m_61143_(AltarPillarBlock.TYPE_PROPERTY));
                if (type == null) {
                    type = t;
                    ++j;
                    continue;
                }
                if (!type.equals((Object)t)) break;
                ++j;
            }
            int value = (int)((float)(10 * Math.min(j, 3)) * (type == null ? 0.0f : type.getValue()));
            valuedTips[i2] = new ValuedObject<BlockPos>(tips[i2], value);
        }
        Arrays.sort(valuedTips, ValuedObject.getInvertedComparator());
        int found = 0;
        for (i = 0; found < required * 10 && i < valuedTips.length && i < 9 && (v = valuedTips[i].value) != 0; found += v, ++i) {
        }
        valuedTips = Arrays.copyOfRange(valuedTips, 0, i);
        this.tips = ValuedObject.extract(BlockPos.class, valuedTips);
        return found >= required * 10;
    }

    private void consumeItems() {
        VampireLevelingConf.AltarInfusionRequirements requirements = VampireLevelingConf.getInstance().getAltarInfusionRequirements(this.targetLevel);
        InventoryHelper.removeItems((Container)this, new int[]{requirements.blood(), requirements.heart(), requirements.vampireBook()});
    }

    private BlockPos[] findTips() {
        if (this.f_58857_ == null) {
            return new BlockPos[0];
        }
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = this.m_58899_().m_123341_() - 4; x < this.m_58899_().m_123341_() + 5; ++x) {
            for (int y = this.m_58899_().m_123342_() + 1; y < this.m_58899_().m_123342_() + 4; ++y) {
                for (int z = this.m_58899_().m_123343_() - 4; z < this.m_58899_().m_123343_() + 5; ++z) {
                    if (!this.f_58857_.m_8055_((BlockPos)pos.m_122178_(x, y, z)).m_60734_().equals((Object)ModBlocks.altar_tip)) continue;
                    list.add(new BlockPos(x, y, z));
                }
            }
        }
        return list.toArray(new BlockPos[0]);
    }

    private boolean loadRitual(UUID playerID) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_6907_().size() == 0) {
            return false;
        }
        this.player = this.f_58857_.m_46003_(playerID);
        if (this.player != null && this.player.m_6084_()) {
            this.targetLevel = VampirismPlayerAttributes.get((Player)this.player).vampireLevel + 1;
            this.checkStructureLevel(this.checkRequiredLevel());
        } else {
            this.runningTick = 0;
            this.tips = null;
            LOGGER.warn("Failed to find player {}", (Object)playerID);
        }
        return true;
    }

    public static enum Result {
        OK,
        ISRUNNING,
        WRONGLEVEL,
        NIGHTONLY,
        STRUCTUREWRONG,
        INVMISSING;

    }

    public static enum PHASE {
        NOT_RUNNING,
        PARTICLE_SPREAD,
        BEAM1,
        BEAM2,
        WAITING,
        LEVELUP,
        ENDING,
        CLEAN_UP;

    }
}

